/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.pdf.PDFViewCtrl;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class PDFViewScrollPane
extends JPanel {
    PDFViewCtrl view;
    JScrollBar vbar;
    JScrollBar hbar;
    GroupLayout layout;
    boolean vScrollBarIsSource;

    public PDFViewScrollPane(PDFViewCtrl pDFViewCtrl) {
        this.view = pDFViewCtrl;
        this.layout = new GroupLayout(this);
        this.setLayout(this.layout);
        this.vbar = new JScrollBar(1, 0, pDFViewCtrl.getVisibleRect().height, 0, pDFViewCtrl.getHeight());
        this.hbar = new JScrollBar(0, 0, pDFViewCtrl.getVisibleRect().width, 0, pDFViewCtrl.getWidth());
        this.vScrollBarIsSource = true;
        this.initComponents();
    }

    public void refresh() {
        this.remove(this.vbar);
        this.remove(this.hbar);
        this.initComponents();
    }

    public void updateScrollbarValue() {
        this.updateVScrollbarValue();
        this.updateHScrollbarValue();
    }

    public void updateHScrollbarValue() {
        try {
            if (Math.abs((double)this.hbar.getValue() - this.view.getHScrollPos()) >= (double)this.hbar.getUnitIncrement()) {
                this.hbar.setValue((int)this.view.getHScrollPos());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateVScrollbarValue() {
        try {
            if (Math.abs((double)this.vbar.getValue() - this.view.getVScrollPos()) >= (double)this.vbar.getUnitIncrement()) {
                this.vScrollBarIsSource = false;
                this.vbar.setValue((int)this.view.getVScrollPos());
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.vScrollBarIsSource = true;
        }
    }

    private void initComponents() {
        if (this.view.getWidth() > this.view.getVisibleRect().width && this.view.getHeight() > this.view.getVisibleRect().height) {
            this.vbar.setUnitIncrement(this.view.getScrollableUnitIncrement(this.view.getVisibleRect(), 1, 1));
            this.vbar.setBlockIncrement(this.view.getScrollableBlockIncrement(this.view.getVisibleRect(), 1, 1));
            this.vbar.setVisibleAmount(this.view.getVisibleRect().height);
            this.vbar.setMaximum(this.view.getHeight());
            this.hbar.setUnitIncrement(this.view.getScrollableUnitIncrement(this.view.getVisibleRect(), 0, 1));
            this.hbar.setBlockIncrement(this.view.getScrollableBlockIncrement(this.view.getVisibleRect(), 0, 1));
            this.hbar.setVisibleAmount(this.view.getVisibleRect().width);
            this.hbar.setMaximum(this.view.getWidth());
            this.updateScrollbarValue();
            this.vbar.addAdjustmentListener(new VAdjustmentListener());
            this.hbar.addAdjustmentListener(new HAdjustmentListener());
            this.layout.setHorizontalGroup(this.layout.createSequentialGroup().addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.view).addComponent(this.hbar)).addComponent(this.vbar));
            this.layout.setVerticalGroup(this.layout.createSequentialGroup().addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.view).addComponent(this.vbar)).addComponent(this.hbar));
        } else if (this.view.getHeight() > this.view.getVisibleRect().height) {
            this.vbar.setUnitIncrement(this.view.getScrollableUnitIncrement(this.view.getVisibleRect(), 1, 1));
            this.vbar.setBlockIncrement(this.view.getScrollableBlockIncrement(this.view.getVisibleRect(), 1, 1));
            this.vbar.setVisibleAmount(this.view.getVisibleRect().height);
            this.vbar.setMaximum(this.view.getHeight());
            this.updateVScrollbarValue();
            this.vbar.addAdjustmentListener(new VAdjustmentListener());
            this.layout.setHorizontalGroup(this.layout.createSequentialGroup().addComponent(this.view).addComponent(this.vbar));
            this.layout.setVerticalGroup(this.layout.createSequentialGroup().addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.view).addComponent(this.vbar)));
        } else if (this.view.getWidth() > this.view.getVisibleRect().width) {
            this.hbar.setUnitIncrement(this.view.getScrollableUnitIncrement(this.view.getVisibleRect(), 0, 1));
            this.hbar.setBlockIncrement(this.view.getScrollableBlockIncrement(this.view.getVisibleRect(), 0, 1));
            this.hbar.setVisibleAmount(this.view.getVisibleRect().width);
            this.hbar.setMaximum(this.view.getWidth());
            this.updateHScrollbarValue();
            this.hbar.addAdjustmentListener(new HAdjustmentListener());
            this.layout.setHorizontalGroup(this.layout.createSequentialGroup().addGroup(this.layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.view).addComponent(this.hbar)));
            this.layout.setVerticalGroup(this.layout.createSequentialGroup().addComponent(this.view).addComponent(this.hbar));
        } else {
            this.layout.setHorizontalGroup(this.layout.createSequentialGroup().addComponent(this.view));
            this.layout.setVerticalGroup(this.layout.createSequentialGroup().addComponent(this.view));
        }
        this.view.requestFocusInWindow();
    }

    public JScrollBar getHScrollbar() {
        return this.hbar;
    }

    public JScrollBar getVScrollbar() {
        return this.vbar;
    }

    private class HAdjustmentListener
    implements AdjustmentListener {
        private HAdjustmentListener() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            PDFViewScrollPane.this.view.setHScrollPos(adjustmentEvent.getValue());
        }
    }

    private class VAdjustmentListener
    implements AdjustmentListener {
        private VAdjustmentListener() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            if (PDFViewScrollPane.this.vScrollBarIsSource) {
                PDFViewScrollPane.this.view.setVScrollPos(adjustmentEvent.getValue());
            }
        }
    }
}

