// This file is autogenerated: please see the codegen template "Options"
#ifndef PDFTRON_H_CPPPDFPDFUAOptions
#define PDFTRON_H_CPPPDFPDFUAOptions

#include <PDF/OptionsBase.h>
#include <PDF/PDFUA/PDFUAConformance.h> // Required for SWIG include order

namespace pdftron{ namespace PDF{ namespace PDFUA{ 

class PDFUAOptions : public OptionsBase
{
public:
	PDFUAOptions();
	~PDFUAOptions();

	
	/**
	* Gets the value ConformanceLevel from the options object.
	* The PDF/UA conformance level. By default the conformance level is PDF/UA-1.
	* @return The current value for ConformanceLevel.
	*/
	PDFUAConformance::Level GetConformanceLevel();

	/**
	* Sets the value for ConformanceLevel in the options object.
	* The PDF/UA conformance level. By default the conformance level is PDF/UA-1.
	* @param value The new value for ConformanceLevel.
	* @return This object, for call chaining.
	*/
	PDFUAOptions& SetConformanceLevel(PDFUAConformance::Level value);

	
	/**
	* Gets the value DefaultLangCode from the options object.
	* The natural language code to set on the document if it is missing.
	* @return The current value for DefaultLangCode.
	*/
	UString GetDefaultLangCode();

	/**
	* Sets the value for DefaultLangCode in the options object.
	* The natural language code to set on the document if it is missing.
	* @param value The new value for DefaultLangCode.
	* @return This object, for call chaining.
	*/
	PDFUAOptions& SetDefaultLangCode(const UString& value);

	
	/**
	* Gets the value FigureAltTextPrefix from the options object.
	* The prefix to use when setting Alt for Image and Graphic tags. By
	* default, and when this is empty, the tag name will be used.
	* @return The current value for FigureAltTextPrefix.
	*/
	UString GetFigureAltTextPrefix();

	/**
	* Sets the value for FigureAltTextPrefix in the options object.
	* The prefix to use when setting Alt for Image and Graphic tags. By
	* default, and when this is empty, the tag name will be used.
	* @param value The new value for FigureAltTextPrefix.
	* @return This object, for call chaining.
	*/
	PDFUAOptions& SetFigureAltTextPrefix(const UString& value);

	
	/**
	* Gets the value FirstStop from the options object.
	* Whether to stop processing after the first PDF/UA error is detected. By default, processing continues.
	* @return The current value for FirstStop.
	*/
	bool GetFirstStop();

	/**
	* Sets the value for FirstStop in the options object.
	* Whether to stop processing after the first PDF/UA error is detected. By default, processing continues.
	* @param value The new value for FirstStop.
	* @return This object, for call chaining.
	*/
	PDFUAOptions& SetFirstStop(bool value);

	
	/**
	* Gets the value MaxRefObjs from the options object.
	* The maximum number of object references per error condition. This is 10 by default.
	* @return The current value for MaxRefObjs.
	*/
	UInt32 GetMaxRefObjs();

	/**
	* Sets the value for MaxRefObjs in the options object.
	* The maximum number of object references per error condition. This is 10 by default.
	* @param value The new value for MaxRefObjs.
	* @return This object, for call chaining.
	*/
	PDFUAOptions& SetMaxRefObjs(UInt32 value);

	
	/**
	* Gets the value Password from the options object.
	* The password to be used for encrypted PDF documents. By default, no password is used.
	* @return The current value for Password.
	*/
	UString GetPassword();

	/**
	* Sets the value for Password in the options object.
	* The password to be used for encrypted PDF documents. By default, no password is used.
	* @param value The new value for Password.
	* @return This object, for call chaining.
	*/
	PDFUAOptions& SetPassword(const UString& value);

	
	/**
	* Gets the value SaveLinearized from the options object.
	* Whether to linearize when saving converted output. By default, the output is not linearized.
	* @return The current value for SaveLinearized.
	*/
	bool GetSaveLinearized();

	/**
	* Sets the value for SaveLinearized in the options object.
	* Whether to linearize when saving converted output. By default, the output is not linearized.
	* @param value The new value for SaveLinearized.
	* @return This object, for call chaining.
	*/
	PDFUAOptions& SetSaveLinearized(bool value);


};

}
}
}

#include "../Impl/PDFUAOptions.inl"
#endif // PDFTRON_H_CPPPDFPDFUAOptions
