'
' Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
'

Imports System

Imports pdftron
Imports pdftron.Common
Imports pdftron.Filters
Imports pdftron.SDF
Imports pdftron.PDF

Module AddImageTestVB
    Dim pdfNetLoader As PDFNetLoader
    Sub New()
        pdfNetLoader = pdftron.PDFNetLoader.Instance()
    End Sub

    '-----------------------------------------------------------------------------------
    ' This sample illustrates how to embed various raster image formats 
    ' (e.g. TIFF, JPEG, JPEG2000, JBIG2, GIF, PNG, BMP, etc.) in a PDF document.
    '-----------------------------------------------------------------------------------
    Sub Main()

        PDFNet.Initialize(PDFTronLicense.Key)

        ' Relative path to the folder containing test files.
        Dim input_path As String = "../../../../TestFiles/"
        Dim output_path As String = "../../../../TestFiles/Output/"

        Try


            Using doc As PDFDoc = New PDFDoc
                Using bld As ElementBuilder = New ElementBuilder       ' Used to build new Element objects
                    Using writer As ElementWriter = New ElementWriter      ' Used to write Elements to the page	

                        Dim page As Page = doc.PageCreate()     ' Start a new page 
                        writer.Begin(page)    ' Begin writing to this page

                        ' ----------------------------------------------------------
                        ' Embed a JPEG image to the output document. 

                        Dim img As Image = Image.Create(doc.GetSDFDoc(), input_path + "peppers.jpg")

                        ' You can also directly add any .NET Bitmap. The following commented-out code 
                        ' is equivalent to the above line:
                        Dim bmp As System.Drawing.Bitmap
                        '   bmp = New System.Drawing.Bitmap(input_path + "peppers.jpg")
                        '   Dim img As Image = Image.Create(doc, bmp)

                        Dim element As Element = bld.CreateImage(img, 50, 500, img.GetImageWidth() / 2, img.GetImageHeight() / 2)
                        writer.WritePlacedElement(element)

                        ' ----------------------------------------------------------
                        ' Add a PNG image to the output file
                        img = Image.Create(doc.GetSDFDoc(), input_path + "butterfly.png")
                        element = bld.CreateImage(img, New Matrix2D(100, 0, 0, 100, 300, 500))
                        writer.WritePlacedElement(element)

                        ' ----------------------------------------------------------
                        ' Add a GIF image to the output file
                        img = Image.Create(doc.GetSDFDoc(), input_path + "pdfnet.gif")
                        element = bld.CreateImage(img, New Matrix2D(img.GetImageWidth(), 0, 0, img.GetImageHeight(), 50, 350))
                        writer.WritePlacedElement(element)

                        ' ----------------------------------------------------------
                        ' Add a TIFF image to the output file
                        img = Image.Create(doc.GetSDFDoc(), input_path + "grayscale.tif")
                        element = bld.CreateImage(img, New Matrix2D(img.GetImageWidth(), 0, 0, img.GetImageHeight(), 10, 50))
                        writer.WritePlacedElement(element)

                        writer.End()           ' Save the page
                        doc.PagePushBack(page) ' Add the page to the document page sequence

                        ' ----------------------------------------------------------
                        ' Embed a multi-page TIFF to the output file

                        ' Create a new page 
                        page = doc.PageCreate(New Rect(0, 0, 612, 794))
                        writer.Begin(page)    ' Begin writing to the page

                        ' Embed the first TIFF page. Use JBIG2 Encoding

                        ' Use JBIG2 Encoding


                        Dim hint_set As ObjSet = New ObjSet
                        Dim enc As Obj = hint_set.CreateArray()
                        enc.PushBackName("JBIG2")
            enc.PushBackName("Lossy")
            

                        img = Image.Create(doc.GetSDFDoc(), input_path + "multipage.tif", enc)
                        element = bld.CreateImage(img, New Matrix2D(612, 0, 0, 794, 0, 0))
                        writer.WritePlacedElement(element)



                        writer.End()           ' Save the page
                        doc.PagePushBack(page) ' Add the page to the document page sequence

                        ' ----------------------------------------------------------
                        ' Add a JPEG2000 (JP2) image to the output file

                        ' Create a new page 
                        page = doc.PageCreate()
                        writer.Begin(page)    ' Begin writing to the page

                        ' Embed the image.
                        img = Image.Create(doc.GetSDFDoc(), input_path + "palm.jp2")

                        ' Position the image on the page.
                        element = bld.CreateImage(img, New Matrix2D(img.GetImageWidth(), 0, 0, img.GetImageHeight(), 96, 80))
                        writer.WritePlacedElement(element)

                        ' Write 'JPEG2000 Sample' text string under the image.
                        writer.WriteElement(bld.CreateTextBegin(Font.Create(doc, Font.StandardType1Font.e_times_roman), 32))
                        element = bld.CreateTextRun("JPEG2000 Sample")
                        element.SetTextMatrix(1, 0, 0, 1, 190, 30)
                        writer.WriteElement(element)
                        writer.WriteElement(bld.CreateTextEnd())

                        writer.End()    ' Finish writing to the page
                        doc.PagePushBack(page)



                    End Using
                End Using

                doc.Save(output_path + "addimage.pdf", SDF.SDFDoc.SaveOptions.e_linearized)
                Console.WriteLine("Done. Result saved in addimage.pdf...")
            End Using

        Catch e As PDFNetException
            Console.WriteLine(e.Message)
        End Try
        PDFNet.Terminate()
    End Sub

End Module
