Imports System
Imports System.Drawing
Imports System.Drawing.Imaging
Imports System.Runtime.InteropServices
Imports pdftron
Imports pdftron.Common
Imports pdftron.PDF
Imports pdftron.SDF

Namespace AdvancedImagingTestVB
    Class Class1
        Private Shared pdfNetLoader As pdftron.PDFNetLoader = pdftron.PDFNetLoader.Instance()

        Shared Sub Main(ByVal args As String())
            PDFNet.Initialize(PDFTronLicense.Key)
            PDFNet.AddResourceSearchPath("../../../../../Lib/")

            If Not AdvancedImagingModule.IsModuleAvailable() Then
                Console.WriteLine()
                Console.WriteLine("Unable to run AdvancedImagingTest: Apryse SDK AdvancedImaging module not available.")
                Console.WriteLine("---------------------------------------------------------------")
                Console.WriteLine("The AdvancedImaging module is an optional add-on, available for download")
                Console.WriteLine("at http://www.pdftron.com/. If you have already downloaded this")
                Console.WriteLine("module, ensure that the SDK is able to find the required files")
                Console.WriteLine("using the PDFNet::AddResourceSearchPath() function.")
                Console.WriteLine()
            End If

            Dim input_path As String = "../../../../TestFiles/AdvancedImaging/"
            Dim output_path As String = "../../../../TestFiles/Output/"

            Dim dicom_input_file As String = "xray.dcm"
            Dim heic_input_file As String = "jasper.heic"
            Dim psd_input_file As String = "tiger.psd"

            Console.WriteLine("Example of advanced imaging module:")

            Try

                Using pdfdoc As PDFDoc = New PDFDoc()
        
                    Dim opts As AdvancedImagingConvertOptions = New AdvancedImagingConvertOptions()
                    opts.SetDefaultDPI(72.0)

                    pdftron.PDF.Convert.FromDICOM(pdfdoc, input_path & dicom_input_file, opts)
                    pdfdoc.Save(output_path & dicom_input_file & ".pdf", SDFDoc.SaveOptions.e_linearized)

                End Using

                Using pdfdoc As PDFDoc = New PDFDoc()

                    pdftron.PDF.Convert.ToPdf(pdfdoc, input_path & heic_input_file)
                    pdfdoc.Save(output_path & heic_input_file & ".pdf", SDFDoc.SaveOptions.e_linearized)

                End Using

                Using pdfdoc As PDFDoc = New PDFDoc()

                    pdftron.PDF.Convert.ToPdf(pdfdoc, input_path & psd_input_file)
                    pdfdoc.Save(output_path & psd_input_file & ".pdf", SDFDoc.SaveOptions.e_linearized)

                End Using

                Console.WriteLine("Done.")
            Catch e As PDFNetException
                Console.WriteLine(e.Message)
            End Try
            PDFNet.Terminate()
        End Sub
    End Class
End Namespace
