'
' Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
'
Imports pdftron
Imports pdftron.Common
Imports pdftron.Filters
Imports pdftron.SDF
Imports pdftron.PDF
Imports pdftron.PDF.Annots

Namespace AnnotationTestVB

    ''' <summary>
    ''' Summary description for Class1.
    ''' </summary>
    Class Class1

        Private Shared pdfNetLoader As pdftron.PDFNetLoader
        Shared Sub New()
            pdfNetLoader = pdftron.PDFNetLoader.Instance
        End Sub

        Private Shared Sub AnnotationHighLevelAPI(ByVal doc As PDFDoc)
            ' The following code snippet traverses all annotations in the document
            System.Console.WriteLine("Traversing all annotations in the document...")
            Dim uri As String
            Dim page_num As Integer = 1
            Dim itr As PageIterator = doc.GetPageIterator
            Do While itr.HasNext
                System.Console.WriteLine("Page " & page_num & ": ")
                page_num = page_num + 1
                Dim page As Page = itr.Current
                Dim num_annots As Integer = page.GetNumAnnots
                Dim i As Integer = 0
                Do While (i < num_annots)
                    Dim annot As Annot = page.GetAnnot(i)
                    If Not annot.IsValid Then
                        'TODO: Warning!!! continue If
                    End If

                    System.Console.WriteLine(("Annot Type: " & annot.GetSDFObj.Get("Subtype").Value.GetName))
                    Dim bbox As Rect = annot.GetRect
                    System.Console.WriteLine("  Position: " & bbox.x1 & ", " &
                                    bbox.y1 & ", " & bbox.x2 & ", " & bbox.y2)
                    Select Case (annot.GetType)
                        Case annot.Type.e_Link
                            Dim action As Action = New Link(annot).GetAction
                            If Not action.IsValid Then
                                'TODO: Warning!!! continue If
                            End If

                            If (action.GetType = action.Type.e_GoTo) Then
                                Dim dest As Destination = action.GetDest
                                If Not dest.IsValid Then
                                    System.Console.WriteLine("  Destination is not valid")
                                Else
                                    Dim pg_num As Integer = dest.GetPage.GetIndex
                                    System.Console.WriteLine("  Links to: page number " &
                                                    pg_num & " in this document")
                                End If

                            ElseIf (action.GetType = action.Type.e_URI) Then
                                uri = action.GetSDFObj.Get("URI").Value.GetAsPDFText
                                System.Console.WriteLine("  Links to: " & uri)
                            End If

                            ' ...
                        Case annot.Type.e_Widget
                        Case annot.Type.e_FileAttachment
                    End Select

                    i = (i + 1)
                Loop

                itr.Next()
            Loop

            ' Use the high-level API to create new annotations.
            Dim first_page As Page = doc.GetPage(1)
            ' Create a hyperlink...
            Dim hyperlink As Link = Link.Create(doc, New Rect(85, 570, 503, 524), Action.CreateURI(doc, "http://www.pdftron.com"))
            first_page.AnnotPushBack(hyperlink)
            ' Create an intra-document link...
            Dim goto_page_3 As Action = Action.CreateGoto(Destination.CreateFitH(doc.GetPage(3), 0))
            Dim lnk As Link = Link.Create(doc, New Rect(85, 458, 503, 502), goto_page_3)
            lnk.SetColor(New ColorPt(0, 0, 1))
            ' Add the new annotation to the first page
            first_page.AnnotPushBack(lnk)
            ' Create a stamp annotation ...
            Dim stamp As RubberStamp = RubberStamp.Create(doc, New Rect(30, 30, 300, 200))
            stamp.SetIcon("Draft")
            first_page.AnnotPushBack(stamp)
            ' Create a file attachment annotation (embed the 'peppers.jpg').
            Dim file_attach As FileAttachment = FileAttachment.Create(doc, New Rect(80, 280, 108, 320), (input_path + "peppers.jpg"))
            first_page.AnnotPushBack(file_attach)
            Dim inkobj As Ink = Ink.Create(doc, New Rect(110, 10, 300, 200))
            Dim pt3 As Point = New Point(110, 10)
            'pt3.x = 110; pt3.y = 10;
            inkobj.SetPoint(0, 0, pt3)
            pt3.x = 150
            pt3.y = 50
            inkobj.SetPoint(0, 1, pt3)
            pt3.x = 190
            pt3.y = 60
            inkobj.SetPoint(0, 2, pt3)
            pt3.x = 180
            pt3.y = 90
            inkobj.SetPoint(1, 0, pt3)
            pt3.x = 190
            pt3.y = 95
            inkobj.SetPoint(1, 1, pt3)
            pt3.x = 200
            pt3.y = 100
            inkobj.SetPoint(1, 2, pt3)
            pt3.x = 166
            pt3.y = 86
            inkobj.SetPoint(2, 0, pt3)
            pt3.x = 196
            pt3.y = 96
            inkobj.SetPoint(2, 1, pt3)
            pt3.x = 221
            pt3.y = 121
            inkobj.SetPoint(2, 2, pt3)
            pt3.x = 288
            pt3.y = 188
            inkobj.SetPoint(2, 3, pt3)
            inkobj.SetColor(New ColorPt(0, 1, 1), 3)
            first_page.AnnotPushBack(inkobj)
        End Sub

        Private Shared Sub AnnotationLowLevelAPI(ByVal doc As PDFDoc)
            Dim page As Page = doc.GetPage(1)
            Dim annots As Obj = page.GetAnnots
            If (annots Is Nothing) Then
                ' If there are no annotations, create a new annotation 
                ' array for the page.
                annots = doc.CreateIndirectArray
                page.GetSDFObj.Put("Annots", annots)
            End If

            ' Create the Text annotation
            Dim text_annot As Obj = doc.CreateIndirectDict
            text_annot.PutName("Subtype", "Text")
            text_annot.PutBool("Open", True)
            text_annot.PutString("Contents", "The quick brown fox ate the lazy mouse.")
            text_annot.PutRect("Rect", 266, 116, 430, 204)
            ' Insert the annotation in the page annotation array
            annots.PushBack(text_annot)
            ' Create a Link annotation
            Dim link1 As Obj = doc.CreateIndirectDict
            link1.PutName("Subtype", "Link")
            Dim dest As Destination = Destination.CreateFit(doc.GetPage(2))
            link1.Put("Dest", dest.GetSDFObj)
            link1.PutRect("Rect", 85, 705, 503, 661)
            annots.PushBack(link1)
            ' Create another Link annotation
            Dim link2 As Obj = doc.CreateIndirectDict
            link2.PutName("Subtype", "Link")
            Dim dest2 As Destination = Destination.CreateFit(doc.GetPage(3))
            link2.Put("Dest", dest2.GetSDFObj)
            link2.PutRect("Rect", 85, 638, 503, 594)
            annots.PushBack(link2)
            ' Note that PDFNet APi can be used to modify existing annotations. 
            ' In the following example we will modify the second link annotation 
            ' (link2) so that it points to the 10th page. We also use a different 
            ' destination page fit type.
            link2.Put("Dest", Destination.CreateXYZ(doc.GetPage(10), 100, (792 - 70), 10).GetSDFObj)
            ' Create a third link annotation with a hyperlink action (all other 
            ' annotation types can be created in a similar way)
            Dim link3 As Obj = doc.CreateIndirectDict
            link3.PutName("Subtype", "Link")
            link3.PutRect("Rect", 85, 570, 503, 524)
            ' Create a URI action
            Dim action As Obj = link3.PutDict("A")
            action.PutName("S", "URI")
            action.PutString("URI", "http://www.pdftron.com")
            annots.PushBack(link3)
        End Sub

        Private Shared Sub CreateTestAnnots(ByVal doc As PDFDoc)
            Dim ew As ElementWriter = New ElementWriter
            Dim eb As ElementBuilder = New ElementBuilder
            Dim element As Element
            Dim first_page As Page = doc.PageCreate(New Rect(0, 0, 600, 600))
            doc.PagePushBack(first_page)
            ew.Begin(first_page, ElementWriter.WriteMode.e_overlay, False)
            ' begin writing to this page
            ew.End()
            ' save changes to the current page
            '
            ' Test of a free text annotation.
            '
            Dim txtannot As FreeText = FreeText.Create(doc, New Rect(10, 400, 160, 570))
            txtannot.SetContents(ControlChars.Lf + ControlChars.Lf + "Some swift brown fox snatched a gray hare out of the air by freezing it with an angry glare." + ControlChars.Lf + ControlChars.Lf + "Aha!" + ControlChars.Lf + ControlChars.Lf + "And there was much rejoicing!")
            txtannot.SetBorderStyle(New Annot.BorderStyle(Annot.BorderStyle.Style.e_solid, 1, 10, 20))
            txtannot.SetQuaddingFormat(0)
            first_page.AnnotPushBack(txtannot)
            txtannot.RefreshAppearance()
            txtannot = FreeText.Create(doc, New Rect(100, 100, 350, 500))
            txtannot.SetContentRect(New Rect(200, 200, 350, 500))
            txtannot.SetContents(ControlChars.Lf + ControlChars.Lf + "Some swift brown fox snatched a gray hare out of the air by freezing it with an angry glare." + ControlChars.Lf + ControlChars.Lf + "Aha!" + ControlChars.Lf + ControlChars.Lf + "And there was much rejoicing!")
            txtannot.SetCalloutLinePoints(New Point(200, 300), New Point(150, 290), New Point(110, 110))
            txtannot.SetBorderStyle(New Annot.BorderStyle(Annot.BorderStyle.Style.e_solid, 1, 10, 20))
            txtannot.SetEndingStyle(Line.EndingStyle.e_ClosedArrow)
            txtannot.SetColor(New ColorPt(0, 1, 0))
            txtannot.SetQuaddingFormat(1)
            first_page.AnnotPushBack(txtannot)
            txtannot.RefreshAppearance()
            txtannot = FreeText.Create(doc, New Rect(400, 10, 550, 400))
            txtannot.SetContents(ControlChars.Lf + ControlChars.Lf + "Some swift brown fox snatched a gray hare out of the air by freezing it with an angry glare." + ControlChars.Lf + ControlChars.Lf + "Aha!" + ControlChars.Lf + ControlChars.Lf + "And there was much rejoicing!")
            txtannot.SetBorderStyle(New Annot.BorderStyle(Annot.BorderStyle.Style.e_solid, 1, 10, 20))
            txtannot.SetColor(New ColorPt(0, 0, 1))
            txtannot.SetOpacity(0.2)
            txtannot.SetQuaddingFormat(2)
            first_page.AnnotPushBack(txtannot)
            txtannot.RefreshAppearance()
            Dim page As Page = doc.PageCreate(New Rect(0, 0, 600, 600))
            doc.PagePushBack(page)
            ew.Begin(page, ElementWriter.WriteMode.e_overlay, False)
            ' begin writing to this page
            eb.Reset()
            ' Reset the GState to default
            ew.End()
            ' save changes to the current page
            'Create a Line annotation...
            Dim lineobj As Line = Line.Create(doc, New Rect(250, 250, 400, 400))
            lineobj.SetStartPoint(New Point(350, 270))
            lineobj.SetEndPoint(New Point(260, 370))
            lineobj.SetStartStyle(Line.EndingStyle.e_Square)
            lineobj.SetEndStyle(Line.EndingStyle.e_Circle)
            lineobj.SetColor(New ColorPt(0.3, 0.5, 0), 3)
            lineobj.SetContents("Dashed Captioned")
            lineobj.SetShowCaption(True)
            lineobj.SetCaptionPosition(Line.CapPos.e_Top)
            Dim dash() As Double = New Double((2) - 1) {}
            dash(0) = 2
            dash(1) = 2
            lineobj.SetBorderStyle(New Annot.BorderStyle(Annot.BorderStyle.Style.e_dashed, 2, 0, 0, dash))
            lineobj.RefreshAppearance()
            page.AnnotPushBack(lineobj)
            lineobj = Line.Create(doc, New Rect(347, 377, 600, 600))
            lineobj.SetStartPoint(New Point(385, 410))
            lineobj.SetEndPoint(New Point(540, 555))
            lineobj.SetStartStyle(Line.EndingStyle.e_Circle)
            lineobj.SetEndStyle(Line.EndingStyle.e_OpenArrow)
            lineobj.SetColor(New ColorPt(1, 0, 0), 3)
            lineobj.SetInteriorColor(New ColorPt(0, 1, 0), 3)
            lineobj.SetContents("Inline Caption")
            lineobj.SetShowCaption(True)
            lineobj.SetCaptionPosition(Line.CapPos.e_Inline)
            lineobj.SetLeaderLineExtensionLength(4)
            lineobj.SetLeaderLineLength(-12)
            lineobj.SetLeaderLineOffset(2)
            lineobj.RefreshAppearance()
            page.AnnotPushBack(lineobj)
            lineobj = Line.Create(doc, New Rect(10, 400, 200, 600))
            lineobj.SetStartPoint(New Point(25, 426))
            lineobj.SetEndPoint(New Point(180, 555))
            lineobj.SetStartStyle(Line.EndingStyle.e_Circle)
            lineobj.SetEndStyle(Line.EndingStyle.e_Square)
            lineobj.SetColor(New ColorPt(0, 0, 1), 3)
            lineobj.SetInteriorColor(New ColorPt(1, 0, 0), 3)
            lineobj.SetContents("Offset Caption")
            lineobj.SetShowCaption(True)
            lineobj.SetCaptionPosition(Line.CapPos.e_Top)
            lineobj.SetTextHOffset(-60)
            lineobj.SetTextVOffset(10)
            lineobj.RefreshAppearance()
            page.AnnotPushBack(lineobj)
            lineobj = Line.Create(doc, New Rect(200, 10, 400, 70))
            lineobj.SetStartPoint(New Point(220, 25))
            lineobj.SetEndPoint(New Point(370, 60))
            lineobj.SetStartStyle(Line.EndingStyle.e_Butt)
            lineobj.SetEndStyle(Line.EndingStyle.e_OpenArrow)
            lineobj.SetColor(New ColorPt(0, 0, 1), 3)
            lineobj.SetContents("Regular Caption")
            lineobj.SetShowCaption(True)
            lineobj.SetCaptionPosition(Line.CapPos.e_Top)
            lineobj.RefreshAppearance()
            page.AnnotPushBack(lineobj)
            lineobj = Line.Create(doc, New Rect(200, 70, 400, 130))
            lineobj.SetStartPoint(New Point(220, 111))
            lineobj.SetEndPoint(New Point(370, 78))
            lineobj.SetStartStyle(Line.EndingStyle.e_Circle)
            lineobj.SetEndStyle(Line.EndingStyle.e_Diamond)
            lineobj.SetContents("Circle to Diamond")
            lineobj.SetColor(New ColorPt(0, 0, 1), 3)
            lineobj.SetInteriorColor(New ColorPt(0, 1, 0), 3)
            lineobj.SetShowCaption(True)
            lineobj.SetCaptionPosition(Line.CapPos.e_Top)
            lineobj.RefreshAppearance()
            page.AnnotPushBack(lineobj)
            lineobj = Line.Create(doc, New Rect(10, 100, 160, 200))
            lineobj.SetStartPoint(New Point(15, 110))
            lineobj.SetEndPoint(New Point(150, 190))
            lineobj.SetStartStyle(Line.EndingStyle.e_Slash)
            lineobj.SetEndStyle(Line.EndingStyle.e_ClosedArrow)
            lineobj.SetContents("Slash to CArrow")
            lineobj.SetColor(New ColorPt(1, 0, 0), 3)
            lineobj.SetInteriorColor(New ColorPt(0, 1, 1), 3)
            lineobj.SetShowCaption(True)
            lineobj.SetCaptionPosition(Line.CapPos.e_Top)
            lineobj.RefreshAppearance()
            page.AnnotPushBack(lineobj)
            lineobj = Line.Create(doc, New Rect(270, 270, 570, 433))
            lineobj.SetStartPoint(New Point(300, 400))
            lineobj.SetEndPoint(New Point(550, 300))
            lineobj.SetStartStyle(Line.EndingStyle.e_RClosedArrow)
            lineobj.SetEndStyle(Line.EndingStyle.e_ROpenArrow)
            lineobj.SetContents("ROpen & RClosed arrows")
            lineobj.SetColor(New ColorPt(0, 0, 1), 3)
            lineobj.SetInteriorColor(New ColorPt(0, 1, 0), 3)
            lineobj.SetShowCaption(True)
            lineobj.SetCaptionPosition(Line.CapPos.e_Top)
            lineobj.RefreshAppearance()
            page.AnnotPushBack(lineobj)
            lineobj = Line.Create(doc, New Rect(195, 395, 205, 505))
            lineobj.SetStartPoint(New Point(200, 400))
            lineobj.SetEndPoint(New Point(200, 500))
            lineobj.RefreshAppearance()
            page.AnnotPushBack(lineobj)
            lineobj = Line.Create(doc, New Rect(55, 299, 150, 301))
            lineobj.SetStartPoint(New Point(55, 300))
            lineobj.SetEndPoint(New Point(155, 300))
            lineobj.SetStartStyle(Line.EndingStyle.e_Circle)
            lineobj.SetEndStyle(Line.EndingStyle.e_Circle)
            lineobj.SetContents("Caption that's longer than its line.")
            lineobj.SetColor(New ColorPt(1, 0, 1), 3)
            lineobj.SetInteriorColor(New ColorPt(0, 1, 0), 3)
            lineobj.SetShowCaption(True)
            lineobj.SetCaptionPosition(Line.CapPos.e_Top)
            lineobj.RefreshAppearance()
            page.AnnotPushBack(lineobj)
            lineobj = Line.Create(doc, New Rect(300, 200, 390, 234))
            lineobj.SetStartPoint(New Point(310, 210))
            lineobj.SetEndPoint(New Point(380, 220))
            lineobj.SetColor(New ColorPt(0, 0, 0), 3)
            lineobj.RefreshAppearance()
            page.AnnotPushBack(lineobj)
            Dim page3 As Page = doc.PageCreate(New Rect(0, 0, 600, 600))
            ew.Begin(page3)
            ' begin writing to the page
            ew.End()
            ' save changes to the current page
            doc.PagePushBack(page3)
            Dim circle As Circle = Circle.Create(doc, New Rect(300, 300, 390, 350))
            circle.SetColor(New ColorPt(0, 0, 0), 3)
            circle.RefreshAppearance()
            page3.AnnotPushBack(circle)
            circle = Circle.Create(doc, New Rect(100, 100, 200, 200))
            circle.SetColor(New ColorPt(0, 1, 0), 3)
            circle.SetInteriorColor(New ColorPt(0, 0, 1), 3)
            dash = New Double((2) - 1) {}
            dash(0) = 2
            dash(1) = 4
            circle.SetBorderStyle(New Annot.BorderStyle(Annot.BorderStyle.Style.e_dashed, 3, 0, 0, dash))
            circle.SetPadding(New Rect(2, 2, 2, 2))
            circle.RefreshAppearance()
            page3.AnnotPushBack(circle)
            Dim sq As Square = Square.Create(doc, New Rect(10, 200, 80, 300))
            sq.SetColor(New ColorPt(0, 0, 0), 3)
            sq.RefreshAppearance()
            page3.AnnotPushBack(sq)
            sq = Square.Create(doc, New Rect(500, 200, 580, 300))
            sq.SetColor(New ColorPt(1, 0, 0), 3)
            sq.SetInteriorColor(New ColorPt(0, 1, 1), 3)
            dash = New Double((2) - 1) {}
            dash(0) = 4
            dash(1) = 2
            sq.SetBorderStyle(New Annot.BorderStyle(Annot.BorderStyle.Style.e_dashed, 6, 0, 0, dash))
            sq.SetPadding(New Rect(4, 4, 4, 4))
            sq.RefreshAppearance()
            page3.AnnotPushBack(sq)
            Dim poly As Polygon = Polygon.Create(doc, New Rect(5, 500, 125, 590))
            poly.SetColor(New ColorPt(1, 0, 0), 3)
            poly.SetInteriorColor(New ColorPt(1, 1, 0), 3)
            poly.SetVertex(0, New Point(12, 510))
            poly.SetVertex(1, New Point(100, 510))
            poly.SetVertex(2, New Point(100, 555))
            poly.SetVertex(3, New Point(35, 544))
            poly.SetBorderStyle(New Annot.BorderStyle(Annot.BorderStyle.Style.e_solid, 4, 0, 0))
            poly.SetPadding(New Rect(4, 4, 4, 4))
            poly.RefreshAppearance()
            page3.AnnotPushBack(poly)
            Dim polyln As PolyLine = PolyLine.Create(doc, New Rect(400, 10, 500, 90))
            polyln.SetColor(New ColorPt(1, 0, 0), 3)
            polyln.SetInteriorColor(New ColorPt(0, 1, 0), 3)
            polyln.SetVertex(0, New Point(405, 20))
            polyln.SetVertex(1, New Point(440, 40))
            polyln.SetVertex(2, New Point(410, 60))
            polyln.SetVertex(3, New Point(470, 80))
            polyln.SetBorderStyle(New Annot.BorderStyle(Annot.BorderStyle.Style.e_solid, 2, 0, 0))
            polyln.SetPadding(New Rect(4, 4, 4, 4))
            polyln.SetStartStyle(Line.EndingStyle.e_RClosedArrow)
            polyln.SetEndStyle(Line.EndingStyle.e_ClosedArrow)
            polyln.RefreshAppearance()
            page3.AnnotPushBack(polyln)
            Dim lk As Link = Link.Create(doc, New Rect(5, 5, 55, 24))
            'lk.SetColor( ColorPt(0,1,0), 3 );
            lk.RefreshAppearance()
            page3.AnnotPushBack(lk)
            Dim page4 As Page = doc.PageCreate(New Rect(0, 0, 600, 600))
            ew.Begin(page4)
            ' begin writing to the page
            ew.End()
            ' save changes to the current page
            doc.PagePushBack(page4)
            ew.Begin(page4)
            Dim font As Font = Font.Create(doc, Font.StandardType1Font.e_helvetica)
            element = eb.CreateTextBegin(font, 16)
            element.SetPathFill(True)
            ew.WriteElement(element)
            element = eb.CreateTextRun("Some random text on the page", font, 16)
            element.SetTextMatrix(1, 0, 0, 1, 100, 500)
            ew.WriteElement(element)
            ew.WriteElement(eb.CreateTextEnd)
            ew.End()
            Dim hl As Highlight = Highlight.Create(doc, New Rect(100, 490, 150, 515))
            hl.SetColor(New ColorPt(0, 1, 0), 3)
            hl.RefreshAppearance()
            page4.AnnotPushBack(hl)
            Dim squig As Squiggly = Squiggly.Create(doc, New Rect(100, 450, 250, 600))
            'sq.SetColor( ColorPt(1,0,0), 3 );
            squig.SetQuadPoint(0, New QuadPoint(New Point(122, 455), New Point(240, 545), New Point(230, 595), New Point(101, 500)))
            squig.RefreshAppearance()
            page4.AnnotPushBack(squig)
            Dim cr As Caret = Caret.Create(doc, New Rect(100, 40, 129, 69))
            cr.SetColor(New ColorPt(0, 0, 1), 3)
            cr.SetSymbol("P")
            cr.RefreshAppearance()
            page4.AnnotPushBack(cr)
            Dim page5 As Page = doc.PageCreate(New Rect(0, 0, 600, 600))
            ew.Begin(page5)
            ' begin writing to the page
            ew.End()
            ' save changes to the current page
            doc.PagePushBack(page5)
            Dim page6 As Page = doc.PageCreate(New Rect(0, 0, 600, 600))
            ew.Begin(page6)
            ' begin writing to the page
            ew.End()
            ' save changes to the current page
            doc.PagePushBack(page6)
            Dim txt As Text = Text.Create(doc, New Rect(10, 20, 30, 40))
            txt.SetIcon("UserIcon")
            txt.SetContents("User defined icon, unrecognized by appearance generator")
            txt.SetColor(New ColorPt(0, 1, 0))
            txt.RefreshAppearance()
            page6.AnnotPushBack(txt)
            Dim ink As Ink = Ink.Create(doc, New Rect(100, 400, 200, 550))
            ink.SetColor(New ColorPt(0, 0, 1))
            ink.SetPoint(1, 3, New Point(220, 505))
            ink.SetPoint(1, 0, New Point(100, 490))
            ink.SetPoint(0, 1, New Point(120, 410))
            ink.SetPoint(0, 0, New Point(100, 400))
            ink.SetPoint(1, 2, New Point(180, 490))
            ink.SetPoint(1, 1, New Point(140, 440))
            ink.SetBorderStyle(New Annot.BorderStyle(Annot.BorderStyle.Style.e_solid, 3, 0, 0))
            ink.RefreshAppearance()
            page6.AnnotPushBack(ink)
            Dim page7 As Page = doc.PageCreate(New Rect(0, 0, 600, 600))
            ew.Begin(page7)
            ' begin writing to the page
            ew.End()
            ' save changes to the current page
            doc.PagePushBack(page7)
            Dim snd As Sound = Sound.Create(doc, New Rect(100, 500, 120, 520))
            snd.SetColor(New ColorPt(1, 1, 0))
            snd.SetIcon(Sound.Icon.e_Speaker)
            snd.RefreshAppearance()
            page7.AnnotPushBack(snd)
            snd = Sound.Create(doc, New Rect(200, 500, 220, 520))
            snd.SetColor(New ColorPt(1, 1, 0))
            snd.SetIcon(Sound.Icon.e_Mic)
            snd.RefreshAppearance()
            page7.AnnotPushBack(snd)
            Dim page8 As Page = doc.PageCreate(New Rect(0, 0, 600, 600))
            ew.Begin(page8)
            ' begin writing to the page
            ew.End()
            ' save changes to the current page
            doc.PagePushBack(page8)
            Dim ipage As Integer = 0
            Do While (ipage < 2)
                Dim py As Double = 520
                Dim px As Double = 5
                Dim istamp As RubberStamp.Icon = RubberStamp.Icon.e_Approved
                Do While (istamp <= RubberStamp.Icon.e_Draft)
                    Dim stmp As RubberStamp = RubberStamp.Create(doc, New Rect(1, 1, 100, 100))
                    stmp.SetIcon(istamp)
                    stmp.SetContents(stmp.GetIconName)
                    stmp.SetRect(New Rect(px, py, (px + 100), (py + 25)))
                    py = (py - 100)
                    If (py < 0) Then
                        py = 520
                        px = (px + 200)
                    End If

                    If (ipage = 0) Then

                    Else
                        page8.AnnotPushBack(stmp)
                        stmp.RefreshAppearance()
                    End If

                    istamp = CType((CType(istamp, Integer) + 1), RubberStamp.Icon)
                Loop

                ipage = (ipage + 1)
            Loop

            Dim st As RubberStamp = RubberStamp.Create(doc, New Rect(400, 5, 550, 45))
            st.SetIcon("UserStamp")
            st.SetContents("User defined stamp")
            page8.AnnotPushBack(st)
            st.RefreshAppearance()
        End Sub

        ' Relative path to the folder containing test files.
        Private Const input_path As String = "../../../../TestFiles/"

        Private Const output_path As String = "../../../../TestFiles/Output/"

        ''' <summary>
        ''' The main entry point for the application.
        ''' </summary>
        <System.STAThread()>
        Public Shared Sub Main(ByVal args() As String)
            PDFNet.Initialize(PDFTronLicense.Key)

            Try
                Dim doc As PDFDoc = New PDFDoc((input_path + "numbered.pdf"))
                doc.InitSecurityHandler()
                ' An example of using SDF/Cos API to add any type of annotations.
                Class1.AnnotationLowLevelAPI(doc)
                doc.Save((output_path + "annotation_test1.pdf"), SDFDoc.SaveOptions.e_linearized)
                System.Console.WriteLine("Done. Results saved in annotation_test1.pdf")
                ' An example of using the high-level PDFNet API to read existing annotations,
                ' to edit existing annotations, and to create new annotation from scratch.
                Class1.AnnotationHighLevelAPI(doc)
                doc.Save((output_path + "annotation_test2.pdf"), SDFDoc.SaveOptions.e_linearized)
                System.Console.WriteLine("Done. Results saved in annotation_test2.pdf")
                ' an example of creating various annotations in a brand new document
                Dim doc1 As PDFDoc = New PDFDoc
                Class1.CreateTestAnnots(doc1)
                doc1.Save((output_path + "new_annot_test_api.pdf"), SDFDoc.SaveOptions.e_linearized)
                System.Console.WriteLine("Saved new_annot_test_api.pdf")
            Catch e As PDFNetException
                System.Console.WriteLine(e.Message)
            End Try
            PDFNet.Terminate()
        End Sub
    End Class
End Namespace