Imports System
Imports System.Drawing
Imports System.Drawing.Imaging
Imports System.Runtime.InteropServices
Imports pdftron
Imports pdftron.Common
Imports pdftron.PDF
Imports pdftron.SDF

Namespace CAD2PDFTestVB
    Class Class1
        Private Shared pdfNetLoader As pdftron.PDFNetLoader = pdftron.PDFNetLoader.Instance()

        Private Shared Function IsRVTFile(ByVal input_file_name As String) As Boolean
            Dim rvt_input As Boolean = False

            If input_file_name.Length > 2 Then

                If input_file_name.Substring(input_file_name.Length - 3, 3) = "rvt" Then
                    rvt_input = True
                End If
            End If

            Return rvt_input
        End Function

        Shared Sub Main(ByVal args As String())
            PDFNet.Initialize(PDFTronLicense.Key)
            PDFNet.AddResourceSearchPath("../../../../../Lib/")

            If Not CADModule.IsModuleAvailable() Then
                Console.WriteLine()
                Console.WriteLine("Unable to run CAD2PDFTest: Apryse SDK CAD module not available.")
                Console.WriteLine("---------------------------------------------------------------")
                Console.WriteLine("The CAD module is an optional add-on, available for download")
                Console.WriteLine("at http://www.pdftron.com/. If you have already downloaded this")
                Console.WriteLine("module, ensure that the SDK is able to find the required files")
                Console.WriteLine("using the PDFNet::AddResourceSearchPath() function.")
                Console.WriteLine()
            End If

            Dim input_path As String = "../../../../TestFiles/CAD/"
            Dim output_path As String = "../../../../TestFiles/Output/"
            Dim input_file_name As String = "construction drawings color-28.05.18.dwg"
            Dim output_file_name As String = "construction drawings color-28.05.18.pdf"

            If args.Length <> 0 Then
                input_file_name = args(0)
                output_file_name = input_file_name & ".pdf"
            End If

            Console.WriteLine("Example cad:")

            Try

                Using pdfdoc As PDFDoc = New PDFDoc()

                    If IsRVTFile(input_file_name) Then
                        Dim opts As CADConvertOptions = New CADConvertOptions()
                        opts.SetPageWidth(800)
                        opts.SetPageHeight(600)
                        opts.SetRasterDPI(150)
                        pdftron.PDF.Convert.FromCAD(pdfdoc, input_path & input_file_name, opts)
                    Else
                        pdftron.PDF.Convert.FromCAD(pdfdoc, input_path & input_file_name, Nothing)
                    End If

                    pdfdoc.Save(output_path & output_file_name, SDFDoc.SaveOptions.e_remove_unused)
                End Using

                Console.WriteLine("Done.")
            Catch e As PDFNetException
                Console.WriteLine(e.Message)
            End Try
            PDFNet.Terminate()
        End Sub
    End Class
End Namespace
