'
' Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
'

Imports System

Imports pdftron
Imports pdftron.Common
Imports pdftron.Filters
Imports pdftron.SDF
Imports pdftron.PDF

Module ContentReplacerTestVB
	Dim pdfNetLoader As PDFNetLoader
	Sub New()
		pdfNetLoader = pdftron.PDFNetLoader.Instance()
	End Sub
'-----------------------------------------------------------------------------------------
' The sample code illustrates how to use the ContentReplacer class to make using 
' 'template' pdf documents easier.
'-----------------------------------------------------------------------------------------

	Sub Main()


		PDFNet.Initialize(PDFTronLicense.Key)

		' Relative path to the folder containing test files.
		Dim input_path As String = "../../../../TestFiles/"
		Dim output_path As String = "../../../../TestFiles/Output/"


		' Example 1) Update a business card template with personalized info
		Try
			Using doc As PDFDoc = New PDFDoc(input_path + "BusinessCardTemplate.pdf")
				doc.InitSecurityHandler()

				' first, replace the image on the first page
				Using replacer As ContentReplacer = New ContentReplacer()
					Dim page As Page = doc.GetPage(1)
					Dim img As Image = Image.Create(doc.GetSDFDoc(), input_path + "peppers.jpg")
					replacer.AddImage(page.GetMediaBox(), img.GetSDFObj())
					' next, replace the text place holders on the second page
					replacer.AddString("NAME", "John Smith")
					replacer.AddString("QUALIFICATIONS", "Philosophy Doctor")
					replacer.AddString("JOB_TITLE", "Software Developer")
					replacer.AddString("ADDRESS_LINE1", "#100 123 Software Rd")
					replacer.AddString("ADDRESS_LINE2", "Vancouver, BC")
					replacer.AddString("PHONE_OFFICE", "604-730-8989")
					replacer.AddString("PHONE_MOBILE", "604-765-4321")
					replacer.AddString("EMAIL", "info@pdftron.com")
					replacer.AddString("WEBSITE_URL", "http://www.pdftron.com")
					' finally, apply
					replacer.Process(page)
				End Using

				doc.Save(output_path + "BusinessCard.pdf", 0)
			End Using
			Console.WriteLine("Done. Result saved in BusinessCard.pdf")
		Catch e As PDFNetException
			Console.WriteLine(e.Message)
		End Try

		' Example 2) Replace text in a region with new text
		Try
			Using doc1 As PDFDoc = New PDFDoc(input_path + "newsletter.pdf")
				doc1.InitSecurityHandler()

				Dim replacer1 As ContentReplacer = New ContentReplacer()
				Dim page1 As Page = doc1.GetPage(1)
				replacer1.AddText(page1.GetMediaBox(), "hello hello hello hello hello hello hello hello hello hello")
				replacer1.Process(page1)

				doc1.Save(output_path + "ContentReplaced.pdf", SDFDoc.SaveOptions.e_linearized)
			End Using
			Console.WriteLine("Done. Result saved in ContentReplaced.pdf")
		Catch e As PDFNetException
			Console.WriteLine(e.Message)
		End Try
		PDFNet.Terminate()
		Console.WriteLine("Done.")
	End Sub

End Module
