'
' Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
'

Imports System
Imports System.Collections.Generic

Imports pdftron
Imports pdftron.Common
Imports pdftron.Filters
Imports pdftron.SDF
Imports pdftron.PDF

Imports XSet = System.Collections.Generic.List(Of Integer)

Module ElementEditTestVB
    Dim pdfNetLoader As PDFNetLoader
    Sub New()
        pdfNetLoader = pdftron.PDFNetLoader.Instance()
    End Sub

    ' The sample code shows how to edit the page display list and how to modify graphics state 
    ' attributes on existing Elements. In particular the sample program strips all images from 
    ' the page, changes the path fill color to red, and changes text color to blue. 

    Sub ProcessElements(ByVal reader As ElementReader, ByVal writer As ElementWriter, ByVal visited As XSet)
        Dim element As Element = reader.Next()
        While Not IsNothing(element) ' Read page contents
            If element.GetType() = element.Type.e_image Then
                ' remove all images by skipping them
                element = reader.Next()
            ElseIf element.GetType() = element.Type.e_inline_image Then
                ' remove all images by skipping them
                element = reader.Next()
            ElseIf element.GetType() = element.Type.e_path Then
                ' Set all paths to red color.
                Dim gs As GState = element.GetGState()
                gs.SetFillColorSpace(ColorSpace.CreateDeviceRGB())
                gs.SetFillColor(New ColorPt(1, 0, 0))
                writer.WriteElement(element)
                element = reader.Next()
            ElseIf element.GetType() = element.Type.e_text Then
                ' Set all text to blue color.
                Dim gs As GState = element.GetGState()
                gs.SetFillColorSpace(ColorSpace.CreateDeviceRGB())
                gs.SetFillColor(New ColorPt(0, 0, 1))
                writer.WriteElement(element)
                element = reader.Next()
            ElseIf element.GetType() = element.Type.e_form Then
                writer.WriteElement(element) ' write Form XObject reference to current stream

                Dim form_obj As Obj = element.GetXObject()
                If Not visited.Contains(form_obj.GetObjNum()) Then ' if this XObject has not been processed
                    ' recursively process the Form XObject
                    visited.Add(form_obj.GetObjNum())
                    Dim new_writer As ElementWriter = New ElementWriter
                    reader.FormBegin()
                    new_writer.Begin(form_obj, True)

                    reader.ClearChangeList()
                    new_writer.SetDefaultGState(reader)

                    ProcessElements(reader, new_writer, visited)
                    new_writer.End()
                    reader.End()
                End If
            Else
                writer.WriteElement(element)
                element = reader.Next()
            End If
        End While
    End Sub

    Sub Main()

        PDFNet.Initialize(PDFTronLicense.Key)

        ' Relative path to the folder containing test files.
        Dim input_path As String = "../../../../TestFiles/"
        Dim output_path As String = "../../../../TestFiles/Output/"
        Dim input_filename As String = "newsletter.pdf"
        Dim output_filename As String = "newsletter_edited.pdf"

        Try

            Console.WriteLine("Opening the input file...")
            Using doc As PDFDoc = New PDFDoc(input_path + input_filename)
                doc.InitSecurityHandler()

                Dim writer As ElementWriter = New ElementWriter
                Dim reader As ElementReader = New ElementReader
                Dim visited As XSet = New XSet()

                Dim itr As PageIterator = doc.GetPageIterator()

                While itr.HasNext()
                    Try
                        Dim page As Page = itr.Current()
                        visited.Add(page.GetSDFObj().GetObjNum())

                        reader.Begin(page)
                        writer.Begin(page, ElementWriter.WriteMode.e_replacement, False, True, page.GetResourceDict())
                        
                        ProcessElements(reader, writer, visited)
                        writer.End()
                        reader.End()

                        itr.Next()
                    Catch e As PDFNetException
                        Console.WriteLine(e.Message)
                    End Try
                End While


                doc.Save(output_path + output_filename, SDF.SDFDoc.SaveOptions.e_remove_unused)
            End Using
            Console.WriteLine("Done. Result saved in {0}...", output_filename)
        Catch e As PDFNetException
            Console.WriteLine(e.Message)
        End Try
        PDFNet.Terminate()
    End Sub

End Module
