'---------------------------------------------------------------------------------------
' Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
' Consult legal.txt regarding legal and license information.
'---------------------------------------------------------------------------------------
Imports System

Imports pdftron
Imports pdftron.Common
Imports pdftron.PDF

Module FindReplaceTestVB
    Dim pdfNetLoader As PDFNetLoader
    Sub New()
        pdfNetLoader = pdftron.PDFNetLoader.Instance()
    End Sub

    ' The following sample illustrates how to find and replace text in a document
    Sub Main()

        ' The first step in every application using PDFNet is to initialize the 
        ' library and set the path to common PDF resources. The library is usually 
        ' initialized only once, but calling Initialize() multiple times is also fine.
        PDFNet.Initialize(PDFTronLicense.Key)

        ' Relative path to the folder containing test files.
        Dim input_path As String = "../../../../TestFiles/"
        Dim output_path As String = "../../../../TestFiles/Output/"

        Try

            ' Open a PDF document to edit
            Using doc As PDFDoc = New PDFDoc(input_path + "find-replace-test.pdf")
                Dim options As FindReplaceOptions = New FindReplaceOptions

                ' Set some find/replace options
                options.SetWholeWords(True)
                options.SetMatchCase(True)
                options.SetMatchMode(FindReplaceOptions.MatchType.e_exact)
                options.SetReflowMode(FindReplaceOptions.ReflowType.e_para)
                options.SetAlignment(FindReplaceOptions.HorizAlignment.e_left)

                ' Perform a Find/Replace finding "the" with "THE INCREDIBLE"
                FindReplace.FindReplaceText(doc, "the", "THE INCREDIBLE", options)

                ' Save the edited PDF
                doc.Save(output_path + "find-replace-test-replaced.pdf", SDF.SDFDoc.SaveOptions.e_linearized)
                doc.Close()
            End Using
        Catch e As PDFNetException
            Console.WriteLine(e.Message)
        End Try
        PDFNet.Terminate()
    End Sub

End Module
