'
' Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
'

Imports System
Imports System.Collections

Imports pdftron
Imports pdftron.Common
Imports pdftron.Filters
Imports pdftron.SDF
Imports pdftron.PDF

'-----------------------------------------------------------------------------------
' The sample illustrates how multiple pages can be combined/imposed 
' using PDFNet. Page imposition can be used to arrange/order pages 
' prior to printing or to assemble a 'master' page from several 'source' 
' pages. Using PDFNet API it is possible to write applications that can 
' re-order the pages such that they will display in the correct order 
' when the hard copy pages are compiled and folded correctly. 
'-----------------------------------------------------------------------------------

Module ImpositionTestVB
	Dim pdfNetLoader As PDFNetLoader
	Sub New()
		pdfNetLoader = pdftron.PDFNetLoader.Instance()
	End Sub

	Sub Main()

		PDFNet.Initialize(PDFTronLicense.Key)

		' Relative path to the folder containing test files.
		Dim input_path As String = "../../../../TestFiles/"
		Dim output_path As String = "../../../../TestFiles/Output/"

		Try
			Console.WriteLine("-------------------------------------------------")
			Console.WriteLine("Opening the input pdf...")
			Using in_doc As PDFDoc = New PDFDoc(input_path + "newsletter.pdf")
				in_doc.InitSecurityHandler()

				' Create a list of pages to import from one PDF document to another.
				Dim import_list As ArrayList = New ArrayList
				Dim itr As PageIterator = in_doc.GetPageIterator()
				While itr.HasNext()
					import_list.Add(itr.Current())
					itr.Next()
				End While

				Using new_doc As PDFDoc = New PDFDoc		  ' Create a new document
					Dim imported_pages As ArrayList = new_doc.ImportPages(import_list)

					' Paper dimension for A3 format in points. Because one inch has 
					' 72 points, 11.69 inch 72 = 841.69 points
					Dim media_box As Rect = New Rect(0, 0, 1190.88, 841.69)
					Dim mid_point As Double = media_box.Width() / 2

					Using builder As ElementBuilder = New ElementBuilder
						Using writer As ElementWriter = New ElementWriter

							Dim i As Integer = 0
							While i < imported_pages.Count
								' Create a blank new A3 page and place on it two pages from the input document.
								Dim new_page As Page = new_doc.PageCreate(media_box)
								writer.Begin(new_page)

								' Place the first page
								Dim src_page As Page = imported_pages(i)
								Dim element As Element = builder.CreateForm(src_page)

								Dim sc_x As Double = mid_point / src_page.GetPageWidth()
								Dim sc_y As Double = media_box.Height() / src_page.GetPageHeight()
								Dim scale As Double = Math.Min(sc_x, sc_y)
								element.GetGState().SetTransform(scale, 0, 0, scale, 0, 0)
								writer.WritePlacedElement(element)

								' Place the second page
								i = i + 1
								If i < imported_pages.Count Then
									src_page = imported_pages(i)
									element = builder.CreateForm(src_page)

									sc_x = mid_point / src_page.GetPageWidth()
									sc_y = media_box.Height() / src_page.GetPageHeight()
									scale = Math.Min(sc_x, sc_y)
									element.GetGState().SetTransform(scale, 0, 0, scale, mid_point, 0)
									writer.WritePlacedElement(element)
									i = i + 1
								End If

								writer.End()
								new_doc.PagePushBack(new_page)
							End While

						End Using
					End Using

					new_doc.Save(output_path + "newsletter_booklet.pdf", SDFDoc.SaveOptions.e_linearized)

				End Using
			End Using
			Console.WriteLine("Done. Result saved in newsletter_booklet.pdf...")

		Catch e As Exception
			Console.WriteLine("Exception caught:\n{0}", e)
		End Try
		PDFNet.Terminate()
	End Sub

End Module
