'
' Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
'
Imports System.Windows.Forms

Imports pdftron
Imports pdftron.Common
Imports pdftron.Filters
Imports pdftron.SDF
Imports pdftron.PDF

' This sample project illustrates how to recompress bi-tonal images in an 
' existing PDF document using JBIG2 compression. The sample is not intended 
' to be a generic PDF optimization tool.
' 
' You can download a sample scanned document using the following link:
'   http://www.pdftron.com/net/samplecode/data/US061222892.pdf
'
' Also a sample page compressed using CCITT Fax compression is located under 
' 'PDFNet/Samples/TestFiles' folder.

Module Program
    Dim pdfNetLoader As PDFNetLoader
    Sub New()
        pdfNetLoader = pdftron.PDFNetLoader.Instance()
    End Sub

    Sub Main(args As String())
        ' Initialize PDFNet before calling any other PDFNet function.
        PDFNet.Initialize(PDFTronLicense.Key)

        Dim pdfdoc As PDFDoc = New PDFDoc("../../../../TestFiles/US061222892-a.pdf")
        pdfdoc.InitSecurityHandler()
        Dim cos_doc As SDFDoc = pdfdoc.GetSDFDoc()
        Dim num_objs As Integer = cos_doc.XRefSize()

        For i As Integer = 1 To num_objs - 1
            Dim obj As Obj = cos_doc.GetObj(i)
            If Not (obj Is Nothing Or obj.IsFree()) Then
                ' Process only images
                If obj.IsStream() Then
                    Dim itr As DictIterator = obj.Find("Subtype")
                    If itr.HasCurrent() Then
                        If itr.Value().GetName() = "Image" Then
                            Dim input_image As pdftron.PDF.Image = New pdftron.PDF.Image(obj)
                            Dim new_image As pdftron.PDF.Image = Nothing

                            ' Process only gray-scale images
                            If input_image.GetComponentNum() = 1 Then
                                Dim bpc As Integer = input_image.GetBitsPerComponent()
                                If bpc = 1 Then
                                    Dim reader As FilterReader = New FilterReader(obj.GetDecodedStream())

                                    Dim hint_set As ObjSet = New ObjSet
                                    Dim hint As Obj = hint_set.CreateArray()
                                    hint.PushBackName("JBIG2")
                                    ' hint.PushBackName("Lossless")
                                    hint.PushBackName("Threshold")
                                    hint.PushBackNumber(0.4)
                                    hint.PushBackName("SharePages")
                                    hint.PushBackNumber(10000)

                                    new_image = pdftron.PDF.Image.Create(cos_doc, reader, input_image.GetImageWidth(), input_image.GetImageHeight(), 1, ColorSpace.CreateDeviceGray(), hint)
                                End If

                                If Not new_image Is Nothing Then
                                    Dim new_img_obj As Obj = new_image.GetSDFObj()

                                    ' Copy any important entries from the image dictionary
                                    itr = obj.Find("ImageMask")
                                    If itr.HasCurrent() Then
                                        new_img_obj.Put("ImageMask", itr.Value())
                                    End If
                                    itr = obj.Find("Mask")
                                    If itr.HasCurrent() Then
                                        new_img_obj.Put("Mask", itr.Value())
                                    End If
                                    cos_doc.Swap(i, new_image.GetSDFObj().GetObjNum())
                                End If
                            End If
                        End If
                    End If
                End If
            End If
        Next

        pdfdoc.Save("../../../../TestFiles/Output/US061222892_JBIG2.pdf", SDFDoc.SaveOptions.e_remove_unused)
        pdfdoc.Close()
        PDFNet.Terminate()
    End Sub
End Module