'
' Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
'

Imports pdftron
Imports pdftron.Common
Imports System.Text
Imports pdftron.SDF
Imports pdftron.PDF


' The following sample illustrates how to use the PDF::Convert utility class to convert 
' .docx files to PDF and replace templated tags present in the document with content supplied via json
'
' For a detailed specification of the template format and supported features,
' see: https://docs.apryse.com/documentation/core/guides/generate-via-template/data-model/
'
' This conversion is performed entirely within the PDFNet and has *no* external or
' system dependencies dependencies 
'
' Please contact us if you have any questions.	
Module OfficeToPDFTestVB
    Dim pdfNetLoader As PDFNetLoader
    Sub New()
        pdfNetLoader = pdftron.PDFNetLoader.Instance()
    End Sub

    ' Relative path to the folder containing test files.
    Dim input_path As String = "../../../../TestFiles/"
    Dim output_path As String = "../../../../TestFiles/Output/"
    Dim input_filename As String = "SYH_Letter.docx"
    Dim output_filename As String = "SYH_Letter.pdf"

    Sub Main()

        PDFNet.Initialize(PDFTronLicense.Key)

        Try
            ' Create a TemplateDocument object from an input office file.
            Using template_doc as TemplateDocument = pdftron.PDF.Convert.CreateOfficeTemplate(input_path + input_filename, Nothing)
                Dim builder As New StringBuilder()
                builder.Append("{""dest_given_name"": ""Janice N."", ""dest_street_address"": ""187 Duizelstraat"", ""dest_surname"": ""Symonds"", ""dest_title"": ""Ms."", ""land_location"": ""225 Parc St., Rochelle, QC "",")
                builder.Append("""lease_problem"":""According to the city records, the lease was initiated in September 2010 and never terminated"", ""logo"": {""image_url"": """ + input_path + "logo_red.png"", ""width"" : 64, ""height"" : 64},")
                builder.Append("""sender_name"": ""Arnold Smith""}")
                Dim json As String = builder.ToString()

                ' Fill the template with data from a JSON string, producing a PDF document.
                Dim pdfdoc As PDFDoc = template_doc.FillTemplateJson(json)

                ' Save the PDF to a file.
                pdfdoc.Save(output_path + output_filename, SDFDoc.SaveOptions.e_linearized)

                ' And we're done!
                Console.WriteLine("Saved " + output_filename)
                Console.WriteLine("Done.")
            End Using

        Catch ex As PDFNetException

            Console.WriteLine(ex.Message)

        Catch ex As Exception

            MsgBox(ex.Message)

        End Try

        PDFNet.Terminate()

    End Sub

End Module
