'
' Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
'

Imports System

Imports pdftron
Imports pdftron.Common
Imports pdftron.Filters
Imports pdftron.SDF
Imports pdftron.PDF


' The following sample illustrates how to use the PDF::Convert utility class to convert 
' .docx files to PDF
'
' This conversion is performed entirely within the PDFNet and has *no* external or
' system dependencies dependencies 
'
' Please contact us if you have any questions.	
Module OfficeToPDFTestVB
    Dim pdfNetLoader As PDFNetLoader
    Sub New()
        pdfNetLoader = pdftron.PDFNetLoader.Instance()
    End Sub

    ' Relative path to the folder containing test files.
    Dim input_path As String = "../../../../TestFiles/"
    Dim output_path As String = "../../../../TestFiles/Output/"

    Private Sub SimpleConvert(ByVal input_filename As String, ByVal output_filename As String)
        ' Start with a PDFDoc (the conversion destination)
        Using pdfdoc As PDFDoc = New PDFDoc

            ' perform the conversion with no optional parameters
            pdftron.PDF.Convert.OfficeToPDF(pdfdoc, input_path + input_filename, Nothing)

            ' save the result
            pdfdoc.Save(output_path + output_filename, SDFDoc.SaveOptions.e_linearized)

            ' And we're done!
            Console.WriteLine("Saved " + (output_path + output_filename))
        End Using
    End Sub

    Private Sub FlexibleConvert(ByVal input_filename As String, ByVal output_filename As String)
        ' Start with a PDFDoc (the conversion destination)
        Using pdfdoc As PDFDoc = New PDFDoc
            Dim options As OfficeToPDFOptions = New OfficeToPDFOptions
            options.SetResourceDocPath("SomePath")
            ' perform the conversion with no optional parameters
            Using conversion As DocumentConversion = pdftron.PDF.Convert.StreamingPDFConversion(pdfdoc, input_path + input_filename, options)

                If conversion.TryConvert() = DocumentConversionResult.e_document_conversion_success Then
                    Dim num_warnings As Integer = conversion.GetNumWarnings()
                    For i As Integer = 0 To num_warnings - 1
                        Console.WriteLine("Warning: " + conversion.GetWarningString(i))
                    Next i

                    ' save the result
                    pdfdoc.Save(output_path + output_filename, SDFDoc.SaveOptions.e_linearized)

                    ' And we're done!
                    Console.WriteLine("Saved " + (output_path + output_filename))
                Else
                    Console.WriteLine("Error: " + conversion.GetErrorString())
                End If
            End Using
        End Using
    End Sub



    Sub Main()

        PDFNet.Initialize(PDFTronLicense.Key)

        Try
            ' first the one-line conversion method
            SimpleConvert("Fishermen.docx", "Fishermen.pdf")

            ' Then the more flexible conversion process
            FlexibleConvert("simple-word_2007.docx", "simple-word_2007_b.pdf")

            ' conversion of RTL content
            FlexibleConvert("factsheet_Arabic.docx", "factsheet_Arabic.pdf")

        Catch ex As PDFNetException

            Console.WriteLine(ex.Message)

        Catch ex As Exception

            MsgBox(ex.Message)

        End Try

        PDFNet.Terminate()

    End Sub

End Module
