'
' Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
'

Imports System
Imports pdftron
Imports pdftron.Common
Imports pdftron.PDF

' The following sample illustrates how to use the PDF:Convert utility Class To convert 
' documents And files to HTML.
'
' There are two HTML modules And one of them Is an optional PDFNet Add-on.
' 1. The built-in HTML module Is used to convert PDF documents to fixed-position HTML
'    documents.
' 2. The optional add-on module Is used to convert PDF documents to HTML documents with
'    text flowing across the browser window.
'
' The Apryse SDK HTML add-on module can be downloaded from http://www.pdftron.com/
'
' Please contact us if you have any questions.	
'
' Also note that conversion under ASP.NET can be tricky to configure. Please see the following document for advice: 
' http://www.pdftron.com/pdfnet/faq_files/Converting_Documents_in_Windows_Service_or_ASP.NET_Application_using_PDFNet.pdf

Module PDF2HtmlTestVB
    Class Class1
        Shared pdfNetLoader As pdftron.PDFNetLoader = pdftron.PDFNetLoader.Instance()

        Shared Sub New()
        End Sub

        ' Relative path to the folder containing test files.
        Const inputPath As String = "../../../../TestFiles/"
        Const outputPath As String = "../../../../TestFiles/Output/"

        <STAThread>
        Shared Sub Main(ByVal args As String())
            ' The first step in every application using PDFNet Is to initialize the 
            ' library. The library Is usually initialized only once, but calling 
            ' Initialize() multiple times Is also fine.
            PDFNet.Initialize(PDFTronLicense.Key)

            Dim err As Boolean = False

            '//////////////////////////////////////////////////////////////////////////

            Try
                ' Convert PDF document to HTML with fixed positioning option turned on (default)
                Console.WriteLine("Converting PDF to HTML with fixed positioning option turned on (default)")

                Dim outputFile As String = outputPath & "paragraphs_and_tables_fixed_positioning.html"

                pdftron.PDF.Convert.ToHtml(inputPath & "paragraphs_and_tables.pdf", outputFile)

                Console.WriteLine("Result saved in " & outputFile)
            Catch e As PDFNetException
                Console.WriteLine("Unable to convert PDF document to HTML, error: " & e.Message)
                err = True
            Catch e As Exception
                Console.WriteLine("Unknown Exception, error: ")
                Console.WriteLine(e)
                err = True
            End Try

            '//////////////////////////////////////////////////////////////////////////

            PDFNet.AddResourceSearchPath("../../../../../Lib/")

            If Not StructuredOutputModule.IsModuleAvailable() Then
                Console.WriteLine()
                Console.WriteLine("Unable to run part of the sample: Apryse SDK Structured Output module not available.")
                Console.WriteLine("-------------------------------------------------------------------------------------")
                Console.WriteLine("The Structured Output module is an optional add-on, available for download")
                Console.WriteLine("at http://www.pdftron.com/. If you have already downloaded this")
                Console.WriteLine("module, ensure that the SDK is able to find the required files")
                Console.WriteLine("using the PDFNet::AddResourceSearchPath() function.")
                Console.WriteLine()
                Return
            End If

            '//////////////////////////////////////////////////////////////////////////

            Try
                ' Convert PDF document to HTML with reflow full option turned on (1)
                Console.WriteLine("Converting PDF to HTML with reflow full option turned on (1)")

                Dim outputFile As String = outputPath & "paragraphs_and_tables_reflow_full.html"

                Dim htmlOutputOptions As pdftron.PDF.Convert.HTMLOutputOptions = New pdftron.PDF.Convert.HTMLOutputOptions()

                ' Set e_reflow_full content reflow setting
                htmlOutputOptions.SetContentReflowSetting(pdftron.PDF.Convert.HTMLOutputOptions.ContentReflowSetting.e_reflow_full)

                pdftron.PDF.Convert.ToHtml(inputPath & "paragraphs_and_tables.pdf", outputFile, htmlOutputOptions)

                Console.WriteLine("Result saved in " & outputFile)
            Catch e As PDFNetException
                Console.WriteLine("Unable to convert PDF document to HTML, error: " & e.Message)
                err = True
            Catch e As Exception
                Console.WriteLine("Unknown Exception, error: ")
                Console.WriteLine(e)
                err = True
            End Try

            '//////////////////////////////////////////////////////////////////////////

            Try
                ' Convert PDF document to HTML with reflow full option turned on (only converting the first page) (2)
                Console.WriteLine("Converting PDF to HTML with reflow full option turned on (only converting the first page) (2)")

                Dim outputFile As String = outputPath & "paragraphs_and_tables_reflow_full_first_page.html"

                Dim htmlOutputOptions As pdftron.PDF.Convert.HTMLOutputOptions = New pdftron.PDF.Convert.HTMLOutputOptions()

                ' Set e_reflow_full content reflow setting
                htmlOutputOptions.SetContentReflowSetting(pdftron.PDF.Convert.HTMLOutputOptions.ContentReflowSetting.e_reflow_full)

                ' Convert only the first page
                htmlOutputOptions.SetPages(1, 1)

                pdftron.PDF.Convert.ToHtml(inputPath & "paragraphs_and_tables.pdf", outputFile, htmlOutputOptions)

                Console.WriteLine("Result saved in " & outputFile)
            Catch e As PDFNetException
                Console.WriteLine("Unable to convert PDF document to HTML, error: " & e.Message)
                err = True
            Catch e As Exception
                Console.WriteLine("Unknown Exception, error: ")
                Console.WriteLine(e)
                err = True
            End Try

            '//////////////////////////////////////////////////////////////////////////

            PDFNet.Terminate()
            Console.WriteLine("Done.")
        End Sub
    End Class
End Module
