'
' Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
'

Imports System
Imports pdftron
Imports pdftron.Common
Imports pdftron.PDF

' The following sample illustrates how to use the PDF:Convert utility Class To convert 
' documents And files to Office.
'
' The Structured Output module is an optional PDFNet Add-on that can be used to convert PDF
' and other documents into Word, Excel, PowerPoint and HTML format.
'
' The Apryse SDK Structured Output module can be downloaded from
' https://docs.apryse.com/documentation/core/info/modules/
'
' Please contact us if you have any questions.	
'
' Also note that conversion under ASP.NET can be tricky to configure. Please see the following document for advice: 
' http://www.pdftron.com/pdfnet/faq_files/Converting_Documents_in_Windows_Service_or_ASP.NET_Application_using_PDFNet.pdf

Module PDF2OfficeTestVB
    Class Class1
        Shared pdfNetLoader As pdftron.PDFNetLoader = pdftron.PDFNetLoader.Instance()

        Shared Sub New()
        End Sub

        ' Relative path to the folder containing test files.
        Const inputPath As String = "../../../../TestFiles/"
        Const outputPath As String = "../../../../TestFiles/Output/"

        <STAThread>
        Shared Sub Main(ByVal args As String())
            ' The first step in every application using PDFNet Is to initialize the 
            ' library. The library Is usually initialized only once, but calling 
            ' Initialize() multiple times Is also fine.
            PDFNet.Initialize(PDFTronLicense.Key)

            PDFNet.AddResourceSearchPath("../../../../../Lib/")

            If Not StructuredOutputModule.IsModuleAvailable() Then
                Console.WriteLine()
                Console.WriteLine("Unable to run the sample: Apryse SDK Structured Output module not available.")
                Console.WriteLine("-----------------------------------------------------------------------------")
                Console.WriteLine("The Structured Output module is an optional add-on, available for download")
                Console.WriteLine("at https://docs.apryse.com/documentation/core/info/modules/. If you have already")
                Console.WriteLine("downloaded this module, ensure that the SDK is able to find the required files")
                Console.WriteLine("using the PDFNet::AddResourceSearchPath() function.")
                Console.WriteLine()
                Return
            End If

            Dim err As Boolean = False

            '//////////////////////////////////////////////////////////////////////////
            '// Word
            '//////////////////////////////////////////////////////////////////////////

            Try
                ' Convert PDF document to Word
                Console.WriteLine("Converting PDF to Word")

                Dim outputFile As String = outputPath & "paragraphs_and_tables.docx"

                pdftron.PDF.Convert.ToWord(inputPath & "paragraphs_and_tables.pdf", outputFile)

                Console.WriteLine("Result saved in " & outputFile)
            Catch e As PDFNetException
                Console.WriteLine("Unable to convert PDF document to Word, error: " & e.Message)
                err = True
            Catch e As Exception
                Console.WriteLine("Unknown Exception, error: ")
                Console.WriteLine(e)
                err = True
            End Try

            '//////////////////////////////////////////////////////////////////////////

            Try
                ' Convert PDF document to Word with options
                Console.WriteLine("Converting PDF to Word with options")

                Dim outputFile As String = outputPath & "paragraphs_and_tables_first_page.docx"

                Dim wordOutputOptions As pdftron.PDF.Convert.WordOutputOptions = New pdftron.PDF.Convert.WordOutputOptions()

                ' Convert only the first page
                wordOutputOptions.SetPages(1, 1)

                pdftron.PDF.Convert.ToWord(inputPath & "paragraphs_and_tables.pdf", outputFile, wordOutputOptions)

                Console.WriteLine("Result saved in " & outputFile)
            Catch e As PDFNetException
                Console.WriteLine("Unable to convert PDF document to Word, error: " & e.Message)
                err = True
            Catch e As Exception
                Console.WriteLine("Unknown Exception, error: ")
                Console.WriteLine(e)
                err = True
            End Try

            '//////////////////////////////////////////////////////////////////////////
            '// Excel
            '//////////////////////////////////////////////////////////////////////////

            Try
                ' Convert PDF document to Excel
                Console.WriteLine("Converting PDF to Excel")

                Dim outputFile As String = outputPath & "paragraphs_and_tables.xlsx"

                pdftron.PDF.Convert.ToExcel(inputPath & "paragraphs_and_tables.pdf", outputFile)

                Console.WriteLine("Result saved in " & outputFile)
            Catch e As PDFNetException
                Console.WriteLine("Unable to convert PDF document to Excel, error: " & e.Message)
                err = True
            Catch e As Exception
                Console.WriteLine("Unknown Exception, error: ")
                Console.WriteLine(e)
                err = True
            End Try

            '//////////////////////////////////////////////////////////////////////////

            Try
                ' Convert PDF document to Excel with options
                Console.WriteLine("Converting PDF to Excel with options")

                Dim outputFile As String = outputPath & "paragraphs_and_tables_second_page.xlsx"

                Dim excelOutputOptions As pdftron.PDF.Convert.ExcelOutputOptions = New pdftron.PDF.Convert.ExcelOutputOptions()

                ' Convert only the second page
                excelOutputOptions.SetPages(2, 2)

                pdftron.PDF.Convert.ToExcel(inputPath & "paragraphs_and_tables.pdf", outputFile, excelOutputOptions)

                Console.WriteLine("Result saved in " & outputFile)
            Catch e As PDFNetException
                Console.WriteLine("Unable to convert PDF document to Excel, error: " & e.Message)
                err = True
            Catch e As Exception
                Console.WriteLine("Unknown Exception, error: ")
                Console.WriteLine(e)
                err = True
            End Try

            '//////////////////////////////////////////////////////////////////////////
            '// PowerPoint
            '//////////////////////////////////////////////////////////////////////////

            Try
                ' Convert PDF document to PowerPoint
                Console.WriteLine("Converting PDF to PowerPoint")

                Dim outputFile As String = outputPath & "paragraphs_and_tables.pptx"

                pdftron.PDF.Convert.ToPowerPoint(inputPath & "paragraphs_and_tables.pdf", outputFile)

                Console.WriteLine("Result saved in " & outputFile)
            Catch e As PDFNetException
                Console.WriteLine("Unable to convert PDF document to PowerPoint, error: " & e.Message)
                err = True
            Catch e As Exception
                Console.WriteLine("Unknown Exception, error: ")
                Console.WriteLine(e)
                err = True
            End Try

            '//////////////////////////////////////////////////////////////////////////

            Try
                ' Convert PDF document to PowerPoint with options
                Console.WriteLine("Converting PDF to PowerPoint with options")

                Dim outputFile As String = outputPath & "paragraphs_and_tables_first_page.pptx"

                Dim powerPointOutputOptions As pdftron.PDF.Convert.PowerPointOutputOptions = New pdftron.PDF.Convert.PowerPointOutputOptions()

                ' Convert only the first page
                powerPointOutputOptions.SetPages(1, 1)

                pdftron.PDF.Convert.ToPowerPoint(inputPath & "paragraphs_and_tables.pdf", outputFile, powerPointOutputOptions)

                Console.WriteLine("Result saved in " & outputFile)
            Catch e As PDFNetException
                Console.WriteLine("Unable to convert PDF document to PowerPoint, error: " & e.Message)
                err = True
            Catch e As Exception
                Console.WriteLine("Unknown Exception, error: ")
                Console.WriteLine(e)
                err = True
            End Try

            '//////////////////////////////////////////////////////////////////////////

            PDFNet.Terminate()
            Console.WriteLine("Done.")
        End Sub
    End Class
End Module
