'---------------------------------------------------------------------------------------
' Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
' Consult legal.txt regarding legal and license information.     
'---------------------------------------------------------------------------------------
Imports System

Imports pdftron
Imports pdftron.PDF
Imports pdftron.PDF.PDFA

'-----------------------------------------------------------------------------------
' The sample illustrates how to use PDF/A related API-s.
'-----------------------------------------------------------------------------------

Module mainModule
    Dim pdfNetLoader As PDFNetLoader
    Sub New()
        pdfNetLoader = pdftron.PDFNetLoader.Instance()
    End Sub

    ' The main entry point for the application.
    Sub Main()

        PDFNet.Initialize(PDFTronLicense.Key)
        PDFNet.SetColorManagement(PDFNet.CMSType.e_lcms) 'Required for PDFA validation.

        'Relative path to the folder containing test files.
        Dim input_path As String = "../../../../TestFiles/"
        Dim filename As String = "newsletter.pdf"
        Dim output_path As String = "../../../../TestFiles/Output/"


        '//-----------------------------------------------------------
        '// Example 1: PDF/A Validation
        '//-----------------------------------------------------------
        Try
            filename = "newsletter.pdf"
            Dim pdf_a As PDFACompliance = New PDFACompliance(False, input_path + filename, Nothing, PDFACompliance.Conformance.e_Level2B, Nothing, 10, False)
            PrintResults(pdf_a, filename)
            pdf_a.Dispose()
        Catch e As PDFTRON.Common.PDFNetException
            Console.WriteLine(e.Message)
        End Try

        '//-----------------------------------------------------------
        '// Example 2: PDF/A Conversion
        '//-----------------------------------------------------------
        Try
            filename = "fish.pdf"
            Using pdf_a As PDFACompliance = New PDFACompliance(True, input_path + filename, Nothing, PDFACompliance.Conformance.e_Level2B, Nothing, 10, False)
                filename = "pdfa.pdf"
                pdf_a.SaveAs(output_path + filename, False)
            End Using

            '// Re-validate the document after the conversion...
            filename = "pdfa.pdf"
            Using pdf_a As PDFACompliance = New PDFACompliance(False, output_path + filename, Nothing, PDFACompliance.Conformance.e_Level2B, Nothing, 10, False)
                PrintResults(pdf_a, filename)
            End Using
        Catch e As pdftron.Common.PDFNetException
            Console.WriteLine(e.Message)
        End Try
        PDFNet.Terminate()
        Console.WriteLine("PDFACompliance test completed.")
    End Sub

    Function PrintResults(ByRef pdf_a As PDFACompliance, ByVal filename As String) As Int32
        PrintResults = 0
        Dim err_cnt As Int32 = pdf_a.GetErrorCount()
        If err_cnt = 0 Then
            Console.WriteLine("{0}: OK.", filename)
        Else
            Dim i As Int32
            Console.WriteLine("{0} is NOT a valid PDFA.", filename)
            For i = 0 To err_cnt - 1 Step 1
                Dim c As PDFACompliance.ErrorCode = pdf_a.GetError(i)
                Console.WriteLine(" - e_PDFA {0}: {1}.", Int(c), PDFACompliance.GetPDFAErrorMessage(c))
                If True Then
                    Dim num_refs As Int32 = pdf_a.GetRefObjCount(c)
                    If num_refs > 0 Then
                        Console.Write("   Objects: ")
                        Dim j As Int32
                        For j = 0 To num_refs - 1 Step 1
                            Console.Write("{0}", pdf_a.GetRefObj(c, j))
                            If Not (j + 1) = num_refs Then
                                Console.Write(", ")
                            End If
                        Next j
                        Console.WriteLine()
                    End If
                End If
            Next i
            Console.WriteLine()
        End If
    End Function

End Module

