'
' Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
'

Imports System
Imports System.Drawing
Imports System.Drawing.Drawing2D

Imports pdftron
Imports pdftron.Common
Imports pdftron.Filters
Imports pdftron.SDF
Imports pdftron.PDF

' This sample shows how to create and use PDFDC (i.e. a PDF Device Context).
' Windows developers can use standard GDI or GDIPlus API-s to write on PDFDC 
' and to generate PDF documents based on their existing drawing functions.
' 
' The second portion of this sample shows how to create and use PDFDCEX.
' Windows developers can use standard GDI or GDIPlus API-s to write multi-page
' PDF documents using existing drawing code.
'
' PDFDCEX can also be used to implement file conversion from any printable 
' file format to PDF (i.e. a virtual PDF printer driver).

Module PDFDCTestVB
	Dim pdfNetLoader As PDFNetLoader
	Sub New()
		pdfNetLoader = pdftron.PDFNetLoader.Instance()
	End Sub

	' Relative path to the folder containing test files.
	Dim input_path As String = "../../../../TestFiles/"
	Dim output_path As String = "../../../../TestFiles/Output/"

	Sub Main()

		PDFNet.Initialize(PDFTronLicense.Key)

		Try

			Console.WriteLine("-------------------------------------------------")

			' Start with a PDFDoc to put the picture into, and a PDFDC to translate GDI to PDF
			Using pdf_doc As PDFDoc = New PDFDoc
				Dim pdf_dc As PDFDC = New PDFDC
				' Set the scale between GDI logical units and the PDF page at 50/inch.
				pdf_dc.SetDPI(50)

				' Create a page to put the GDI content onto
				Dim pg As Page = pdf_doc.PageCreate()

				' Begin the translation from GDI to PDF.
				' Provide the page to place the picture onto, and the bounding box for the content.
				' We're going to scale the GDI content to fill the page while preserving the aspect
				''/ ratio.
				' Get back a GDI Device Context
				Using gr As Graphics = pdf_dc.Begin(pg, pg.GetCropBox())
					Dim myImage As System.Drawing.Image = System.Drawing.Image.FromFile(input_path + "butterfly.png")
					Dim myTextureBrush As TextureBrush = New TextureBrush(myImage)
					gr.FillEllipse(myTextureBrush, 0, 0, 100, 50)

					pdf_dc.End() ' Close PDF Device Context
				End Using

				' Add the page to the document
				pdf_doc.PagePushBack(pg)

				pdf_doc.Save(output_path + "PDFDCTest.pdf", SDF.SDFDoc.SaveOptions.e_linearized)
			End Using
			Console.WriteLine("Wrote " + output_path + "PDFDCTest12.pdf")

			''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
			' 
			' Now the PDFDCEX example
			' Start with a PDFDoc to put the picture into, and a PDFDCEX to translate GDI to PDF
			Using pdf_doc2 As PDFDoc = New PDFDoc
				Dim pdf_dcex As PDFDCEX = New PDFDCEX

				' Begin the translation from GDI to PDF.
				' Get back a GDI Device Context -- this will be managed by the PDFDCEX class
				pdf_dcex.Begin(pdf_doc2)
				Dim gr2 As Graphics = pdf_dcex.StartPage()

				Dim myImage2 As System.Drawing.Image = System.Drawing.Image.FromFile(input_path + "butterfly.png")
				Dim myTextureBrush2 As TextureBrush = New TextureBrush(myImage2)
				gr2.FillEllipse(myTextureBrush2, 0, 0, 100, 50)

				pdf_dcex.EndPage() ' This also disposes of the Graphics Object gr2
				pdf_dcex.End() ' Close PDF Device Context

				pdf_doc2.Save(output_path + "PDFDCEXTest.pdf", SDF.SDFDoc.SaveOptions.e_linearized)
			End Using
			Console.WriteLine("Wrote " + output_path + "PDFDCEXTest.pdf")
			Console.WriteLine("Done.")

		Catch ex As PDFNetException

			Console.WriteLine(ex.Message)

		Catch ex As Exception

			MsgBox(ex.Message)

		End Try
		PDFNet.Terminate()
	End Sub

End Module
