'
' Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
'

Imports System
Imports System.IO

Imports pdftron
Imports pdftron.Common
Imports pdftron.Filters
Imports pdftron.SDF
Imports pdftron.PDF

' The following sample illustrates how to read/write a PDF document from/to 
' a memory buffer.  This is useful for applications that work with dynamic PDF
' documents that don't need to be saved/read from a disk.
Module PDFDocMemoryTestVB
	Dim pdfNetLoader As PDFNetLoader
	Sub New()
		pdfNetLoader = pdftron.PDFNetLoader.Instance()
	End Sub

	Sub Main()

		PDFNet.Initialize(PDFTronLicense.Key)

		' Relative path to the folder containing test files.
		Dim input_path As String = "../../../../TestFiles/"
		Dim output_path As String = "../../../../TestFiles/Output/"

		Try
			' Read a PDF document in a memory buffer.
			Dim istm As FileStream = New FileStream(input_path + "tiger.pdf", FileMode.Open, FileAccess.Read)
			Using doc As PDFDoc = New PDFDoc(istm)
				doc.InitSecurityHandler()
				Dim num_pages As Integer = doc.GetPageCount()

				Using writer As ElementWriter = New ElementWriter
					Using reader As ElementReader = New ElementReader
						Dim element As Element

						' Perform some document editing ...
						' Here we simply copy all elements from one page to another.
						Dim i As Integer
						For i = 1 To num_pages Step 1
							Dim pg As Page = doc.GetPage(2 * i - 1)
							reader.Begin(pg)
							Dim new_page As Page = doc.PageCreate(pg.GetMediaBox())
							doc.PageInsert(doc.GetPageIterator(2 * i), new_page)

							writer.Begin(new_page)
							element = reader.Next()
							While (Not IsNothing(element))		' Read page contents
								writer.WriteElement(element)
								element = reader.Next()
							End While

							writer.End()
							reader.End()
						Next i

						doc.Save(output_path + "doc_memory_edit.pdf", SDF.SDFDoc.SaveOptions.e_remove_unused)

						' Save the document to a stream or a memory buffer...
						Dim ostm As FileStream = New FileStream(output_path + "doc_memory_edit.txt", FileMode.Create, FileAccess.Write)
						doc.Save(ostm, SDF.SDFDoc.SaveOptions.e_remove_unused)
						ostm.Close()

						' Read some data from the file stored in memory
						reader.Begin(doc.GetPage(1))
						element = reader.Next()
						While (Not IsNothing(element))	 ' Read page contents
							If element.GetType() = element.Type.e_path Then
								Console.Write("Path, ")
							End If

							element = reader.Next()
						End While
						reader.End()
					End Using
				End Using
			End Using
			Console.WriteLine("")
			Console.WriteLine("")
			Console.WriteLine("Done. Result saved in doc_memory_edit.pdf and doc_memory_edit.txt ...")
		Catch ex As PDFNetException
			Console.WriteLine(ex.Message)
		Catch ex As Exception
			MsgBox(ex.Message)
		End Try
		PDFNet.Terminate()
	End Sub
End Module
