'
' Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
'

Imports System

Imports pdftron
Imports pdftron.Common
Imports pdftron.Filters
Imports pdftron.SDF
Imports pdftron.PDF

Module PackageTestVB
    Dim pdfNetLoader As PDFNetLoader
    Sub New()
        pdfNetLoader = pdftron.PDFNetLoader.Instance()
    End Sub


    Sub Main()

        PDFNet.Initialize(PDFTronLicense.Key)

        ' Relative path to the folder containing test files.
        Dim input_path As String = "../../../../TestFiles/"
        Dim output_path As String = "../../../../TestFiles/Output/"
        Try

            Using doc As PDFDoc = New PDFDoc
                AddPackage(doc, input_path & "numbered.pdf", "My File 1")
                AddPackage(doc, input_path & "newsletter.pdf", "My Newsletter...")
                AddPackage(doc, input_path & "peppers.jpg", "An image")
                AddCoverPage(doc)
                doc.Save(output_path & "package.pdf", SDFDoc.SaveOptions.e_linearized)
                Console.WriteLine("Done.")
            End Using

        Catch e As PDFNetException
            Console.WriteLine(e.Message)
        End Try

        Try

            Using doc As PDFDoc = New PDFDoc(output_path & "package.pdf")
                doc.InitSecurityHandler()
                Dim files As pdftron.SDF.NameTree = NameTree.Find(doc, "EmbeddedFiles")

                If files.IsValid() Then
                    ' Traverse the list of embedded files.
                    Dim i As NameTreeIterator = files.GetIterator()
                    Dim counter As Integer = 0

                    While i.HasNext()
                        Dim entry_name As String = i.Key().GetAsPDFText()
                        Console.WriteLine("Part: {0}", entry_name)
                        Dim file_spec As FileSpec = New FileSpec(i.Value())
                        Dim stm As Filter = file_spec.GetFileData()

                        If stm IsNot Nothing Then
                            Dim fname As String = output_path & "extract_" & counter.ToString() & System.IO.Path.GetExtension(entry_name)
                            stm.WriteToFile(fname, False)
                        End If

                        i.Next()
                        counter += 1
                    End While
                End If
            End Using

            Console.WriteLine("Done.")
        Catch e As PDFNetException
            Console.WriteLine(e.Message)
        End Try
        PDFNet.Terminate()
    End Sub

    Private Sub AddPackage(ByVal doc As PDFDoc, ByVal file As String, ByVal desc As String)
        Dim files As NameTree = NameTree.Create(doc, "EmbeddedFiles")
        Dim fs As FileSpec = FileSpec.Create(doc, file, True)
        Dim file1_name As Byte() = System.Text.Encoding.UTF8.GetBytes(file)
        files.Put(file1_name, fs.GetSDFObj())
        fs.GetSDFObj().PutText("Desc", desc)
        Dim collection As Obj = doc.GetRoot().FindObj("Collection")
        If collection Is Nothing Then collection = doc.GetRoot().PutDict("Collection")
    ' You could here manipulate any entry in the Collection dictionary. 
    ' For example, the following line sets the tile mode for initial view mode
    ' Please refer to section '2.3.5 Collections' in PDF Reference for details.
        collection.PutName("View", "T")
    End Sub

    Private Sub AddCoverPage(ByVal doc As PDFDoc)
    ' Here we dynamically generate cover page (please see ElementBuilder 
    ' sample for more extensive coverage of PDF creation API).
        Dim page As Page = doc.PageCreate(New Rect(0, 0, 200, 200))

        Using b As ElementBuilder = New ElementBuilder()

            Using w As ElementWriter = New ElementWriter()
                w.Begin(page)
                Dim font As Font = Font.Create(doc, Font.StandardType1Font.e_helvetica)
                w.WriteElement(b.CreateTextBegin(font, 12))
                Dim e As Element = b.CreateTextRun("My PDF Collection")
                e.SetTextMatrix(1, 0, 0, 1, 50, 96)
                e.GetGState().SetFillColorSpace(ColorSpace.CreateDeviceRGB())
                e.GetGState().SetFillColor(New ColorPt(1, 0, 0))
                w.WriteElement(e)
                w.WriteElement(b.CreateTextEnd())
                w.End()
                doc.PagePushBack(page)
            End Using
        End Using
    ' Alternatively we could import a PDF page from a template PDF document
    ' (for an example please see PDFPage sample project).
    ' ...
    End Sub
End Module
