'
' Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
'

Imports System
Imports System.Collections

Imports pdftron
Imports pdftron.Common
Imports pdftron.Filters
Imports pdftron.SDF
Imports pdftron.PDF


Module PDFPageTestVB
	Dim pdfNetLoader As PDFNetLoader
	Sub New()
		pdfNetLoader = pdftron.PDFNetLoader.Instance()
	End Sub

	Sub Main()

		PDFNet.Initialize(PDFTronLicense.Key)

		' Relative path to the folder containing test files.
		Dim input_path As String = "../../../../TestFiles/"
		Dim output_path As String = "../../../../TestFiles/Output/"

		Try
			'---------------------------------------------------------------------------------
			' Sample 1 - Split a PDF document into multiple pages

			Console.WriteLine("_______________________________________________")
			Console.WriteLine("Sample 1 - Split a PDF document into multiple pages...")
			Console.WriteLine("Opening the input pdf...")

			Using in_doc As PDFDoc = New PDFDoc(input_path + "newsletter.pdf")
				in_doc.InitSecurityHandler()

				Dim page_num As Integer = in_doc.GetPageCount()
				Dim i As Integer

				For i = 1 To page_num
					Dim new_doc As PDFDoc = New PDFDoc()
					new_doc.InsertPages(0, in_doc, i, i, PDFDoc.InsertFlag.e_none)
					new_doc.Save(output_path + "newsletter_split_page_" + CStr(i) + ".pdf", SDFDoc.SaveOptions.e_remove_unused)
					Console.WriteLine("Done. Result saved in newsletter_split_page_" + CStr(i) + ".pdf")
					new_doc.Close()
				Next i
			End Using

			'---------------------------------------------------------------------------------
			' Sample 2 - Merge several PDF documents into one

			Console.WriteLine("_______________________________________________")
			Console.WriteLine("Sample 2 - Merge several PDF documents into one...")

			Using new1_doc As PDFDoc = New PDFDoc()
				new1_doc.InitSecurityHandler()

				Dim page_num1 As Integer = 15
				Dim i1 As Integer

				For i1 = 1 To page_num1
					Console.WriteLine("Opening newsletter_split_page_" + CStr(i1) + ".pdf")
					Dim in0_doc As PDFDoc = New PDFDoc(output_path + "newsletter_split_page_" + CStr(i1) + ".pdf")
					new1_doc.InsertPages(i1, in0_doc, 1, in0_doc.GetPageCount(), PDFDoc.InsertFlag.e_none)
					in0_doc.Close()
				Next i1

				new1_doc.Save(output_path + "newsletter_merge_pages.pdf", SDFDoc.SaveOptions.e_remove_unused)
				Console.WriteLine("Done. Result saved in newsletter_merge_pages.pdf")
			End Using

			'---------------------------------------------------------------------------------
			' Sample 3 - Delete every second page

			Console.WriteLine("_______________________________________________")
			Console.WriteLine("Sample 3 - Delete every second page...")
			Console.WriteLine("Opening the input pdf...")

			Using in1_doc As PDFDoc = New PDFDoc(input_path + "newsletter.pdf")
				in1_doc.InitSecurityHandler()

				Dim page_num2 As Integer = in1_doc.GetPageCount()
				Dim itr As PageIterator

				While page_num2 >= 1
					itr = in1_doc.GetPageIterator(page_num2)
					in1_doc.PageRemove(itr)
					page_num2 -= 2
				End While

				in1_doc.Save(output_path + "newsletter_page_remove.pdf", 0)
				Console.WriteLine("Done. Result saved in newsletter_page_remove.pdf...")
			End Using

			'---------------------------------------------------------------------------------
			' Sample 4 - Inserts a page from one document at different 
			' locations within another document
			Console.WriteLine("_______________________________________________")
			Console.WriteLine("Sample 4 - Insert a page at different locations...")
			Console.WriteLine("Opening the input pdf...")

			Using in2_doc As PDFDoc = New PDFDoc(input_path + "newsletter.pdf")
				in2_doc.InitSecurityHandler()

				Using in3_doc As PDFDoc = New PDFDoc(input_path + "fish.pdf")
					in3_doc.InitSecurityHandler()

					Dim src_page4 As Page = in3_doc.GetPage(1) ' Get the first page
					Dim dst_page4 As PageIterator = in2_doc.GetPageIterator(1)
					Dim page_num4 As Integer = 1
					While dst_page4.HasNext()
						If page_num4 Mod 3 = 0 Then
							in2_doc.PageInsert(dst_page4, src_page4)
						End If
						page_num4 = page_num4 + 1
						dst_page4.Next()
					End While

					in2_doc.Save(output_path + "newsletter_page_insert.pdf", 0)
					Console.WriteLine("Done. Result saved in newsletter_page_insert.pdf...")
				End Using
			End Using

			'---------------------------------------------------------------------------------
			' Sample 5 - Replicate pages within a single document

			Console.WriteLine("_______________________________________________")
			Console.WriteLine("Sample 5 - Replicate pages within a single document...")
			Console.WriteLine("Opening the input pdf...")
			Using doc5 As PDFDoc = New PDFDoc(input_path + "newsletter.pdf")
				doc5.InitSecurityHandler()

				' Replicate the cover page three times (copy page #1 and place it before the 
				' seventh page in the document page sequence)
				Dim cover As Page = doc5.GetPage(1)
				Dim p7 as PageIterator = doc5.GetPageIterator(7)
				doc5.PageInsert(p7, cover)
				doc5.PageInsert(p7, cover)
				doc5.PageInsert(p7, cover)

				' Replicate the cover page two more times by placing it before and after
				' existing pages.
				doc5.PagePushFront(cover)
				doc5.PagePushBack(cover)

				doc5.Save(output_path + "newsletter_page_clone.pdf", 0)
				Console.WriteLine("Done. Result saved in newsletter_page_clone.pdf...")
			End Using

			'---------------------------------------------------------------------------------
			' Sample 6 - Use ImportPages() in order to copy multiple pages at once 
			' in order to preserve shared resources between pages (e.g. images, fonts, 
			' colorspaces, etc.)
			Console.WriteLine("_______________________________________________")
			Console.WriteLine("Sample 6 - Preserving shared resources using ImportPages...")
			Console.WriteLine("Opening the input pdf...")
			Using in_doc6 As PDFDoc = New PDFDoc(input_path + "newsletter.pdf")
				in_doc6.InitSecurityHandler()

				Using new_doc6 As PDFDoc = New PDFDoc
					Dim copy_pages As ArrayList = New ArrayList
					Dim itr6 As PageIterator = in_doc6.GetPageIterator()
					While itr6.HasNext()
						copy_pages.Add(itr6.Current())
						itr6.Next()
					End While

					Dim imported_pages As ArrayList = new_doc6.ImportPages(copy_pages)
					Dim i6 As Integer
					For i6 = 0 To imported_pages.Count - 1
						new_doc6.PagePushFront(imported_pages(i6))	  ' Order pages in reverse order. 
						' Use PagePushBack() if you would like to preserve the same order.
					Next i6

					new_doc6.Save(output_path + "newsletter_import_pages.pdf", 0)
					Console.WriteLine("Done. Result saved in newsletter_import_pages.pdf...")
					Console.WriteLine()
					Console.WriteLine("Note that the output file size is less than half the size")
					Console.WriteLine("of the file produced using individual page copy operations")
					Console.WriteLine("between two documents")
				End Using
			End Using

		Catch ex As PDFNetException
			Console.WriteLine(ex.Message)
		Catch ex As Exception
			MsgBox(ex.Message)
		End Try
		PDFNet.Terminate()
	End Sub
End Module
