'
' Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
'

Imports System
Imports System.Collections

Imports pdftron
Imports pdftron.Common
Imports pdftron.Filters
Imports pdftron.SDF
Imports pdftron.PDF

Module PDFRedactTestVB
    Dim pdfNetLoader As PDFNetLoader
    Sub New()
        pdfNetLoader = pdftron.PDFNetLoader.Instance()
    End Sub

    ' PDF Redactor is a separately licensable Add-on that offers options to remove 
    ' (not just covering or obscuring) content within a region of PDF. 
    ' With printed pages, redaction involves blacking-out or cutting-out areas of 
    ' the printed page. With electronic documents that use formats such as PDF, 
    ' redaction typically involves removing sensitive content within documents for 
    ' safe distribution to courts, patent and government institutions, the media, 
    ' customers, vendors or any other audience with restricted access to the content. 
    '
    ' The redaction process in PDFNet consists of two steps:
    ' 
    '  a) Content identification: A user applies redact annotations that specify the 
    ' pieces or regions of content that should be removed. The content for redaction 
    ' can be identified either interactively (e.g. using 'pdftron.PDF.PDFViewCtrl' 
    ' as shown in PDFView sample) or programmatically (e.g. using 'pdftron.PDF.TextSearch'
    ' or 'pdftron.PDF.TextExtractor'). Up until the next step is performed, the user 
    ' can see, move and redefine these annotations.
    '  b) Content removal: Using 'pdftron.PDF.Redactor.Redact()' the user instructs 
    ' PDFNet to apply the redact regions, after which the content in the area specified 
    ' by the redact annotations is removed. The redaction function includes number of 
    ' options to control the style of the redaction overlay (including color, text, 
    ' font, border, transparency, etc.).
    ' 
    ' PDFTron Redactor makes sure that if a portion of an image, text, or vector graphics 
    ' is contained in a redaction region, that portion of the image or path data is 
    ' destroyed and is not simply hidden with clipping or image masks. PDFNet API can also 
    ' be used to review and remove metadata and other content that can exist in a PDF 
    ' document, including XML Forms Architecture (XFA) content and Extensible Metadata 
    ' Platform (XMP) content.
    '
    ' The following sample illustrates how to redact a PDF document using 'pdftron.PDF.Redactor'.
    Sub Main()
        PDFNet.Initialize(PDFTronLicense.Key)

        Dim input_path As String = "../../../../TestFiles/"
        Dim output_path As String = "../../../../TestFiles/Output/"
        Dim input_filename As String = "newsletter.pdf"

        Try
            Dim rarr As ArrayList = New ArrayList
            rarr.Add(New Redactor.Redaction(1, New Rect(100, 100, 550, 600), False, "Top Secret"))
            rarr.Add(New Redactor.Redaction(2, New Rect(30, 30, 450, 450), True, "Negative Redaction"))
            rarr.Add(New Redactor.Redaction(2, New Rect(0, 0, 100, 100), False, "Positive"))
            rarr.Add(New Redactor.Redaction(2, New Rect(100, 100, 200, 200), False, "Positive"))
            rarr.Add(New Redactor.Redaction(2, New Rect(300, 300, 400, 400), False, ""))
            rarr.Add(New Redactor.Redaction(2, New Rect(500, 500, 600, 600), False, ""))
            rarr.Add(New Redactor.Redaction(3, New Rect(0, 0, 700, 20), False, ""))


            Dim app As Redactor.Appearance = New Redactor.Appearance()
            app.RedactionOverlay = True
            app.Border = False
            app.ShowRedactedContentRegions = True

            Redact(input_path + "newsletter.pdf", output_path + "redacted.pdf", rarr, app)

            Console.WriteLine("Done...")
        Catch ex As PDFNetException
            Console.WriteLine(ex.Message)
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try
        PDFNet.Terminate()
    End Sub

    Sub Redact(ByVal input As String, ByVal output As String, ByVal rarr As ArrayList, ByVal app As Redactor.Appearance)
        Try
            Using doc As PDFDoc = New PDFDoc(input)
                doc.InitSecurityHandler()

                Redactor.Redact(doc, rarr, app, False, True)
                doc.Save(output, SDFDoc.SaveOptions.e_linearized)
            End Using
        Catch ex As PDFNetException
            Console.WriteLine(ex.Message)
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try
    End Sub

End Module

