'---------------------------------------------------------------------------------------
' Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
' Consult legal.txt regarding legal and license information.     
'---------------------------------------------------------------------------------------
Imports System

Imports pdftron
Imports pdftron.PDF
Imports PDFTRON.PDF.PDFUA

'//---------------------------------------------------------------------------------------
'// The following sample illustrates how to make sure a file meets the PDF/UA standard, using the PDFUAConformance class object.
'// Note: this feature is currently experimental and subject to change
'//
'// DataExtractionModule is required (Mac users can use StructuredOutputModule instead)
'// https://docs.apryse.com/documentation/core/info/modules/#data-extraction-module
'// https://docs.apryse.com/documentation/core/info/modules/#structured-output-module (Mac)
'//---------------------------------------------------------------------------------------

Module mainModule
    Dim pdfNetLoader As PDFNetLoader
    Sub New()
        pdfNetLoader = pdftron.PDFNetLoader.Instance()
    End Sub

    '// Relative path to the folder containing test files.
    Dim input_path As String =  "../../../../TestFiles/"
    Dim output_path As String = "../../../../TestFiles/Output/"

    '// DataExtraction library location, replace if desired, should point to a folder that includes the contents of <DataExtractionModuleRoot>/Lib.
    '// If using default, unzip the DataExtraction zip to the parent folder of Samples, and merge with existing "Lib" folder
    Dim extraction_module_path As String = "../../../../../Lib/"

    ' The main entry point for the application.
    Sub Main()

        PDFNet.Initialize(PDFTronLicense.Key)

        Try
            Dim input_file1 As String = input_path + "autotag_input.pdf"
            Dim input_file2 As String = input_path + "table.pdf"
            Dim output_file1 As String = output_path + "autotag_pdfua.pdf"
            Dim output_file2 As String = output_path + "table_pdfua_linearized.pdf"

            '//-----------------------------------------------------------
            '// Example: PDF/UA Conversion
            '//-----------------------------------------------------------
            Console.WriteLine("AutoConverting...")

            PDFNet.AddResourceSearchPath(extraction_module_path)
            If Not DataExtractionModule.IsModuleAvailable(DataExtractionModule.DataExtractionEngine.e_doc_structure) Then
                Console.WriteLine("Unable to run PDFUATest: Apryse SDK Data Extraction module not available.")
                Console.WriteLine("---------------------------------------------------------------")
                Console.WriteLine("The Data Extraction module is an optional add-on, available for download")
                Console.WriteLine("at https://apryse.com/. If you have already downloaded this")
                Console.WriteLine("module, ensure that the SDK is able to find the required files")
                Console.WriteLine("using the PDFNet::AddResourceSearchPath() function.")
                Console.WriteLine()
                Return
            End If

            Dim pdf_ua As PDFUAConformance = New PDFUAConformance()

            Console.WriteLine("Simple Conversion...")

            '// Perform conversion using default options
            pdf_ua.AutoConvert(input_file1, output_file1)


            Console.WriteLine("Converting With Options...")

            Dim pdf_ua_opts As PDFUAOptions = New PDFUAOptions()
            pdf_ua_opts.SetSaveLinearized(True) '// Linearize When saving output
            '// Note: if file is password protected, you can use pdf_ua_opts.setPassword()

            '// Perform conversion using the options we specify
            pdf_ua.AutoConvert(input_file2, output_file2, pdf_ua_opts)
        Catch e As PDFTRON.Common.PDFNetException
            Console.WriteLine(e.Message)
        End Try

        PDFNet.Terminate()
        Console.WriteLine("PDFUAConformance test completed.")
    End Sub

End Module

