﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Windows.Threading;
using System.Diagnostics;
using System.Threading;

using pdftron;
using pdftron.PDF;
using pdftron.Common;
using pdftron.PDF.Tools.Utilities;

namespace PDFViewWPFTestCS
{
    /// <summary>
    /// Interaction logic for SideWindowControl.xaml
    /// </summary>
    public partial class SideWindowControl : UserControl
    {
        PDFViewWPF _current_viewer;
        pdftron.PDF.Tools.ToolManager _toolManager;

        PDFDoc _current_doc;
        WholeDocumentSearchControl _search_ctrl;
        ThumbnailsControl _thumbnail_ctrl;
        AnnotationsControl _annot_ctrl;

        public SideWindowControl()
        {
            InitializeComponent();
        }

        private void SideTabControl_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            
        }

        // Handle the bookmark select event (i.e. when the user selects a node in the bookmark tree).
        private void bookmark_tree_SelectedItemChanged(object sender, RoutedPropertyChangedEventArgs<object> e)
        {
            if (e.NewValue == null) return;
            _current_doc.Lock();
            TreeViewItem new_item = (TreeViewItem)e.NewValue;
            Bookmark item = (Bookmark)new_item.Tag;            
            pdftron.PDF.Action action = item.GetAction();
            if (action.IsValid())
            {
                ActionParameter action_param = new ActionParameter(action);
                ActionUtils.ExecuteAction(action_param, _current_viewer);
            }
            _current_doc.Unlock();
        }

        public void CreateSideWindow(PDFViewWPF viewer, pdftron.PDF.Tools.ToolManager toolManager)
        {
            if (viewer == null)
                return;

            _current_viewer = viewer;
            _toolManager = toolManager;
            _current_doc = viewer.GetDoc();

            SideTabControl.SelectionChanged += new SelectionChangedEventHandler(SideTabControl_SelectionChanged);

            _search_ctrl = new WholeDocumentSearchControl();
            SearchDisplayGrid.Children.Add(_search_ctrl);
            _thumbnail_ctrl = new ThumbnailsControl();
            ThumbnailGrid.Children.Add(_thumbnail_ctrl);
            _annot_ctrl = new AnnotationsControl();
            AnnotationControlGrid.Children.Add(_annot_ctrl);

            if (OutlineTabItem.IsSelected && !bookmark_tree.HasItems)
            {
                bookmark_tree.Items.Clear();                
                bookmark_tree.Dispatcher.BeginInvoke((System.Action)delegate
                {
                    _current_doc.Lock();
                    Bookmark root = _current_doc.GetFirstBookmark();
                    if (root.IsValid())
                    {
                        bookmark_tree.BeginInit();
                        BuildBookmarkTree(root, bookmark_tree.Items);
                        bookmark_tree.EndInit();
                    }
                    _current_doc.Unlock();
                });
                
            }

            bookmark_tree.SelectedItemChanged += new RoutedPropertyChangedEventHandler<object>(bookmark_tree_SelectedItemChanged);

            _thumbnail_ctrl.LoadThumbnails(_current_viewer);

            _annot_ctrl.CurrentToolManager = _toolManager;
            _annot_ctrl.EnableAnnotationTools(_current_viewer, _toolManager);
            _search_ctrl.EnableSearch(_current_viewer, _toolManager);
        }



        // Populate the bookmark tree control with bookmark items.
        static void BuildBookmarkTree(Bookmark item, ItemCollection nodes)
        {
            for (int i = 0; item.IsValid(); item = item.GetNext(), ++i)
            {
                TreeViewItem new_node = new TreeViewItem();
                new_node.Header = item.GetTitle();
                ToolTipService.SetToolTip(new_node, new_node.Header);
                nodes.Add(new_node);
                new_node.Tag = item;
                if (item.IsOpen()) new_node.IsExpanded = true;
                if (item.HasChildren()) // Recursively add children sub-trees
                {
                    BuildBookmarkTree(item.GetFirstChild(), new_node.Items);
                }
            }
        }

        public void Activate()
        {
            _thumbnail_ctrl.Reactivate();
        }

        public void Deactivate()
        {
            _thumbnail_ctrl.Stop();
        }
    }
}
