﻿using System;
using System.Windows;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using pdftron;
using pdftron.Common;
using pdftron.Filters;
using pdftron.SDF;
using pdftron.PDF;

namespace PDFViewWPFTestCS
{
    class PDFViewWPFSecurityHandler : StdSecurityHandler
    {
        public static MainWindow MainWindow;

        public PDFViewWPFSecurityHandler(Int32 key_len, Int32 enc_code) : base(key_len, enc_code) { }
        public PDFViewWPFSecurityHandler(PDFViewWPFSecurityHandler s) : base(s) { }

        // In this callback ask the user for password/authorization data. 
        // This may involve a dialog box used to collect authorization data or something else.
        override public bool GetAuthorizationData(SecurityHandler.Permission p)
        {
            AuthorizeDlg dlg = new AuthorizeDlg();
            if (MainWindow != null)
            {
                dlg.Owner = MainWindow;
            }
            if (dlg.ShowDialog() == true)
            {
                InitPassword(dlg.m_pass.Password);
                return true;
            }
            else
                return false;
        }

        // This callback could be used to customize security handler preferences.
        override public bool EditSecurityData(SDFDoc doc) { return false; }

        // This callback is used when authorization process fails. 
        override public void AuthorizeFailed()
        {
            MessageBox.Show("The Password is incorrect. Please make sure that the Caps lock is not on by mistake, and try again.", "PDFViewWPF Error");
        }

        public static SecurityHandler Create(String name, Int32 key_len, Int32 enc_code) { return new PDFViewWPFSecurityHandler(key_len, enc_code); }

        override public SecurityHandler Clone() { return new PDFViewWPFSecurityHandler(this); }
    }
}
