﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using pdftron.Common;
using System.Windows.Media;
using System.Windows.Shapes;

using UIPoint = System.Windows.Point;
using PDFPoint = pdftron.PDF.Point;
using PDFRect = pdftron.PDF.Rect;
using PDFPage = pdftron.PDF.Page;
using pdftron.PDF;

namespace pdftron.PDF.Tools
{
    public class PolygonCreate: AdvancedShapeCreate
    {
        public PolygonCreate(PDFViewWPF view, ToolManager manager)
            : base(view, manager)
        {
            mToolMode = ToolManager.ToolType.e_polygon_create;
            mNextToolMode = ToolManager.ToolType.e_polygon_create;
        }

        #region Override Functions

        protected override void Draw()
        {
            try
            {
                if (mShapeHasBeenCreated) // Shape is ready to draw
                {
                    var nextPoint = new UIPoint(mDragPoint.X - mPageCropOnClient.x1, mDragPoint.Y - mPageCropOnClient.y1);

                    if (mPdfPointList.Count == (mPreviousDrawPointIndex))
                    {
                        mPdfPointList.Add(new PDFPoint(nextPoint.X, nextPoint.Y));
                    }
                    else
                    {
                        mPdfPointList[mPdfPointList.Count - 1].x = nextPoint.X;
                        mPdfPointList[mPdfPointList.Count - 1].y = nextPoint.Y;
                    }

                    if (mFigure.Segments.Count == (mPreviousDrawPointIndex))
                    {
                        LineSegment segment = new LineSegment();
                        segment.Point = new UIPoint(nextPoint.X, nextPoint.Y);
                        mFigure.Segments.Add(segment);
                    }
                    else
                    {
                        (mFigure.Segments[mFigure.Segments.Count - 1] as LineSegment).Point = new UIPoint(nextPoint.X, nextPoint.Y);
                    }

                    if (mFigure.Segments.Count == 3)
                    {
                        mFigure.IsClosed = true;
                    }
                }
            }
            catch (Exception ex)
            {

            }
        }

        protected override void Create()
        {
            //creates a polyline annotation and adds it to the PDF page
            try
            {
                mPDFView.DocLock(true);

                PDFRect rect = GetAdvancedShapeBBox(mPdfPointList);
                if (rect != null)
                {
                    rect.Normalize();
                    rect.Inflate(mStrokeThickness / 2);
                    Annots.Polygon pdfPolygon = Annots.Polygon.Create(mPDFView.GetDoc().GetSDFDoc(), rect);

                    int vertexIdx = 0;
                    foreach (PDFPoint point in mPdfPointList)
                    {
                        // The Rect is normalized, so we need to recalculate the points if we don't want it to start from 0,0
                        // transform the 2 points to page space
                        double sx = mPDFView.GetHScrollPos();
                        double sy = mPDFView.GetVScrollPos();

                        double x1 = point.x - sx + mPageCropOnClient.x1;
                        double y1 = point.y - sy + mPageCropOnClient.y1;

                        mPDFView.ConvScreenPtToPagePt(ref x1, ref y1, mDownPageNumber);

                        PDFPoint pdfPoint = new PDFPoint(x1, y1);
                        pdfPolygon.SetVertex(vertexIdx++, pdfPoint);
                    }

                    SetStyle(pdfPolygon);
                    pdfPolygon.RefreshAppearance();

                    PDFPage page = mPDFView.GetDoc().GetPage(mDownPageNumber);
                    page.AnnotPushBack(pdfPolygon);

                    mAnnotPageNum = mDownPageNumber;
                    mAnnot = pdfPolygon;
                    mPDFView.Update(pdfPolygon, mDownPageNumber);
                }
            }
            catch (Exception ex)
            {

            }
            finally
            {
                mPDFView.DocUnlock();
            }

            mToolManager.RaiseAnnotationAddedEvent(mAnnot);
        }

        #endregion Override Functions
    }
}
