﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace pdftron.PDF.Tools.Utilities
{
    public class ActionUtils
    {
        public static void ExecuteAction(ActionParameter action_param, PDFViewWPF mPDFView)
        {
            Action action = action_param.GetAction();
            if (action != null)
            {
                Action.Type at = action.GetType();
                if (at == Action.Type.e_URI)
                {
                    pdftron.SDF.Obj o = action.GetSDFObj();
                    o = o.FindObj("URI");
                    if (o != null)
                    {
                        String uristring = o.GetAsPDFText();
                        if (uristring != null)
                        {
                            System.Text.RegularExpressions.Regex emailExpression = new System.Text.RegularExpressions.Regex("^([a-zA-Z0-9_\\-\\.]+)@((\\[[0-9]{1,3}" + "\\.[0-9]{1,3}\\.[0-9]{1,3}\\.)|(([a-zA-Z0-9\\-]+\\" + ".)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\\]?)$");
                            if (emailExpression.IsMatch(uristring))
                            {
                                if (!uristring.StartsWith("mailto:"))
                                {
                                    uristring = uristring.Insert(0, "mailto:");
                                }
                            }
                            System.Diagnostics.Process.Start(uristring);
                        }
                    }
                }
                else
                {
                    mPDFView.ExecuteAction(action_param);
                }
            }
        }
    }
}
