Imports System
Imports PDFTRON
Imports PDFTRON.Common
Imports PDFTRON.Filters
Imports PDFTRON.SDF
Imports PDFTRON.PDF
Module PatternTestVB
	Dim pdfNetLoader As PDFNetLoader
	Sub New()
		pdfNetLoader = pdftron.PDFNetLoader.Instance()
	End Sub

	' <summary>
	' This example illustrates how to create PDF patterns and shadings.
	' </summary>
	Sub Main()

		Const output_path As String = "../../../../TestFiles/Output/"
		PDFNet.Initialize(PDFTronLicense.Key)
		Try
			Using doc As PDFDoc = New PDFDoc
				Using writer As ElementWriter = New ElementWriter
					Using eb As ElementBuilder = New ElementBuilder

						' The following sample illustrates how to create and use tiling patterns
						Dim page As Page = doc.PageCreate
						writer.Begin(page)

						' Begin the text block
						Dim element As Element = eb.CreateTextBegin(Font.Create(doc, Font.StandardType1Font.e_times_bold), 1)
						writer.WriteElement(element)

						element = eb.CreateTextRun("G")
						element.SetTextMatrix(720, 0, 0, 720, 20, 240)
						Dim gs As GState = element.GetGState
						gs.SetTextRenderMode(GState.TextRenderingMode.e_fill_stroke_text)
						gs.SetLineWidth(4)

						' Set the fill color space to the Pattern color space. 
						gs.SetFillColorSpace(ColorSpace.CreatePattern)
						gs.SetFillColor(PatternTest.CreateTilingPattern(doc))


						writer.WriteElement(element)
						writer.WriteElement(eb.CreateTextEnd) ' Finish the text block

						writer.End() ' Save the page
						doc.PagePushBack(page)

						'-----------------------------------------------
						'  The following sample illustrates how to create and use image tiling pattern
						page = doc.PageCreate
						writer.Begin(page)

						eb.Reset()
						element = eb.CreateRect(0, 0, 612, 794)

						' Set the fill color space to the Pattern color space. 
						gs = element.GetGState
						gs.SetFillColorSpace(ColorSpace.CreatePattern)
						gs.SetFillColor(PatternTest.CreateImageTilingPattern(doc))
						element.SetPathFill(True)

						writer.WriteElement(element)

						writer.End() ' save the page
						doc.PagePushBack(page)
						'-----------------------------------------------

						' The following sample illustrates how to create and use PDF shadings
						page = doc.PageCreate
						writer.Begin(page)

						eb.Reset()
						element = eb.CreateRect(0, 0, 612, 794)

						' Set the fill color space to the Pattern color space. 
						gs = element.GetGState
						gs.SetFillColorSpace(ColorSpace.CreatePattern)
						gs.SetFillColor(PatternTest.CreateAxialShading(doc))
						element.SetPathFill(True)

						writer.WriteElement(element)

						writer.End() ' save the page
						doc.PagePushBack(page)

					End Using
				End Using

				doc.Save(output_path + "patterns.pdf", SDFDoc.SaveOptions.e_remove_unused)
			End Using
			Console.WriteLine("Done. Result saved in patterns.pdf...")
		Catch e As PDFNetException
			Console.WriteLine(e.Message)
		End Try
		PDFNet.Terminate()
	End Sub

	Class PatternTest
		'Relative path to the folder containing test files.
		Const input_path As String = "../../../../TestFiles/"



		Shared Function CreateTilingPattern(ByVal doc As PDFDoc) As PatternColor

			Using writer As ElementWriter = New ElementWriter
				Using eb As ElementBuilder = New ElementBuilder

					' Create a new pattern content stream - a heart. ------------
					writer.Begin(doc.GetSDFDoc)
					eb.PathBegin()
					eb.MoveTo(0, 0)
					eb.CurveTo(500, 500, 125, 625, 0, 500)
					eb.CurveTo(-125, 625, -500, 500, 0, 0)
					Dim heart As Element = eb.PathEnd
					heart.SetPathFill(True)

					' Set heart color to red.
					heart.GetGState.SetFillColorSpace(ColorSpace.CreateDeviceRGB)
					heart.GetGState.SetFillColor(New ColorPt(1, 0, 0))
					writer.WriteElement(heart)

					Dim pattern_dict As Obj = writer.End()

					' Initialize pattern dictionary. For details on what each parameter represents please 
					' refer to Table 4.22 (Section '4.6.2 Tiling Patterns') in PDF Reference Manual.
					pattern_dict.PutName("Type", "Pattern")
					pattern_dict.PutNumber("PatternType", 1)

					' TilingType - Constant spacing.
					pattern_dict.PutNumber("TilingType", 1)


					' This is a Type1 pattern - A colored tiling pattern.
					pattern_dict.PutNumber("PaintType", 1)

					' Set bounding box
					pattern_dict.PutRect("BBox", -253, 0, 253, 545)

					' Set the pattern matrix
					pattern_dict.PutMatrix("Matrix", New Matrix2D(0.04, 0, 0, 0.04, 0, 0))

					'Set the desired horizontal and vertical spacing between pattern cells, 
					' measured in the pattern coordinate system.
					pattern_dict.PutNumber("XStep", 1000)
					pattern_dict.PutNumber("YStep", 1000)

					Return New PatternColor(pattern_dict)			 ' finished creating the Pattern resource
				End Using
			End Using
		End Function

		Shared Function CreateImageTilingPattern(ByVal doc As PDFDoc) As PatternColor

			Using writer As ElementWriter = New ElementWriter
				Using eb As ElementBuilder = New ElementBuilder

					' Create a new pattern content stream - a single bitmap object ----------
					writer.Begin(doc.GetSDFDoc)
					Dim img As Image = Image.Create(doc.GetSDFDoc, input_path + "butterfly.png")
					Dim img_element As Element = eb.CreateImage(img, 0, 0, img.GetImageWidth, img.GetImageHeight)
					writer.WritePlacedElement(img_element)
					Dim pattern_dict As Obj = writer.End()

					' Initialize pattern dictionary. For details on what each parameter represents please 
					' refer to Table 4.22 (Section '4.6.2 Tiling Patterns') in PDF Reference Manual.
					pattern_dict.PutName("Type", "Pattern")
					pattern_dict.PutNumber("PatternType", 1)

					' TilingType - Constant spacing.
					pattern_dict.PutNumber("TilingType", 1)

					' This is a Type1 pattern - A colored tiling pattern.
					pattern_dict.PutNumber("PaintType", 1)

					' Set bounding box
					pattern_dict.PutRect("BBox", -253, 0, 253, 545)

					' Set the pattern matrix
					pattern_dict.PutMatrix("Matrix", New Matrix2D(0.3, 0, 0, 0.3, 0, 0))

					' Set the desired horizontal and vertical spacing between pattern cells, 
					' measured in the pattern coordinate system.
					pattern_dict.PutNumber("XStep", 300)
					pattern_dict.PutNumber("YStep", 300)
					Return New PatternColor(pattern_dict)			 ' finished creating the Pattern resource
				End Using
			End Using
		End Function

		Shared Function CreateAxialShading(ByVal doc As PDFDoc) As PatternColor

			' Create a new Shading object ------------
			Dim pattern_dict As Obj = doc.CreateIndirectDict()

			' Initialize pattern dictionary. For details on what each parameter represents 
			' please refer to Tables 4.30 and 4.26 in PDF Reference Manual
			pattern_dict.PutName("Type", "Pattern")
			pattern_dict.PutNumber("PatternType", 2)			 ' 2 stands for shading

			Dim shadingDict As Obj = pattern_dict.PutDict("Shading")
			shadingDict.PutNumber("ShadingType", 2)
			shadingDict.PutName("ColorSpace", "DeviceCMYK")

			' pass the coordinates of the axial shading to the output
			Dim shadingCoords As Obj = shadingDict.PutArray("Coords")
			shadingCoords.PushBackNumber(0)
			shadingCoords.PushBackNumber(0)
			shadingCoords.PushBackNumber(612)
			shadingCoords.PushBackNumber(794)

			' Set the shading Function for axial shading
			Dim funct As Obj = shadingDict.PutDict("Function")
			Dim C0 As Obj = funct.PutArray("C0")
			C0.PushBackNumber(1)
			C0.PushBackNumber(0)
			C0.PushBackNumber(0)
			C0.PushBackNumber(0)

			Dim C1 As Obj = funct.PutArray("C1")
			C1.PushBackNumber(0)
			C1.PushBackNumber(1)
			C1.PushBackNumber(0)
			C1.PushBackNumber(0)

			Dim domain As Obj = funct.PutArray("Domain")
			domain.PushBackNumber(0)
			domain.PushBackNumber(1)

			funct.PutNumber("FunctionType", 2)
			funct.PutNumber("N", 1)

			Return New PatternColor(pattern_dict)
		End Function
	End Class
End Module