'
' Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
'

Imports System

Imports pdftron
Imports pdftron.Common
Imports pdftron.Filters
Imports pdftron.SDF
Imports pdftron.PDF

Module RectTestVB
	Dim pdfNetLoader As PDFNetLoader
	Sub New()
		pdfNetLoader = pdftron.PDFNetLoader.Instance()
	End Sub

	Sub Main()

		PDFNet.Initialize(PDFTronLicense.Key)

		' Relative path to the folder containing test files.
		Dim input_path As String = "../../../../TestFiles/"
		Dim output_path As String = "../../../../TestFiles/Output/"

		Try
			Console.WriteLine("-------------------------------------------------")
			Console.WriteLine("Opening the input pdf...")

			' Test  - Adjust the position of content within the page.
			Using input_doc As PDFDoc = New PDFDoc(input_path + "tiger.pdf")
				input_doc.InitSecurityHandler()

				Dim pg As Page = input_doc.GetPage(1)
				Dim media_box As Rect = pg.GetMediaBox()

				media_box.x1 -= 200			 ' translate the page 200 units (1 uint = 1/72 inch)
				media_box.x2 -= 200

				media_box.Update()

				input_doc.Save(output_path + "tiger_shift.pdf", 0)

				Console.WriteLine("Done. Result saved in tiger_shift.pdf")
			End Using
		Catch ex As PDFNetException
			Console.WriteLine(ex.Message)
		Catch ex As Exception
			MsgBox(ex.Message)
		End Try
		PDFNet.Terminate()
	End Sub
End Module
