'
' Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
'

Imports System

Imports pdftron
Imports pdftron.Common
Imports pdftron.Filters
Imports pdftron.SDF
Imports pdftron.PDF

Module SDFTestVB
	Dim pdfNetLoader As PDFNetLoader
	Sub New()
		pdfNetLoader = pdftron.PDFNetLoader.Instance()
	End Sub

	' This sample illustrates how to use basic SDF API (also known as Cos) to edit an 
	' existing document.
	Sub Main()

		PDFNet.Initialize(PDFTronLicense.Key)

		' Relative path to the folder containing test files.
		Dim input_path As String = "../../../../TestFiles/"
		Dim output_path As String = "../../../../TestFiles/Output/"

		Try
			'------------------------------------------------------------------
			Console.WriteLine("-------------------------------------------------")
			Console.WriteLine("Opening the test file...")

			' Here we create a SDF/Cos document directly from PDF file. In case you have 
			' PDFDoc you can always access SDF/Cos document using PDFDoc.GetSDFDoc() method.
			Using doc As SDFDoc = New SDFDoc(input_path + "fish.pdf")
				doc.InitSecurityHandler()

				Console.WriteLine("-------------------------------------------------")
				Console.WriteLine("Modifying info dictionary, adding custom properties, embedding a stream...")

				Dim trailer As Obj = doc.GetTrailer()		   ' Get the trailer

				' Now we will change PDF document information properties using SDF API

				' Get the Info dictionary. 
				Dim itr As DictIterator = trailer.Find("Info")
				Dim info As Obj
				If itr.HasCurrent() Then
					info = itr.Value()
					' Modify 'Producer' entry.
					info.PutString("Producer", "PDFTron PDFNet")

					' Read title entry (if it is present)
					itr = info.Find("Author")
					If Not itr.HasCurrent() Then
						info.PutString("Author", "Joe Doe")
					Else
						info.PutString("Author", itr.Value().GetAsPDFText() + "- Modified")
					End If
				Else
					' Info dict is missing. 
					info = trailer.PutDict("Info")
					info.PutString("Producer", "PDFTron PDFNet")
					info.PutString("Title", "My document")
				End If


				' Create a custom inline dictionary within Info dictionary
				Dim custom_dict As Obj = info.PutDict("My Direct Dict")

				' Add some key/value pairs
				custom_dict.PutNumber("My Number", 100)
				Dim my_array As Obj = custom_dict.PutArray("My Array")

				' Create a custom indirect array within Info dictionary
				Dim custom_array As Obj = doc.CreateIndirectArray()
				info.Put("My Indirect Array", custom_array)

				' Create indirect link to root
				custom_array.PushBack(trailer.Get("Root").Value())

				' Embed a custom stream (file my_stream.txt).
				Dim embed_file As MappedFile = New MappedFile(input_path + "my_stream.txt")
				Dim mystm As FilterReader = New FilterReader(embed_file)
				custom_array.PushBack(doc.CreateIndirectStream(mystm))

				' Save the changes.
				Console.WriteLine("Saving modified test file...")
				doc.Save(output_path + "sdftest_out.pdf", 0, "%PDF-1.4")

				Console.WriteLine("Done. Result saved in sdftest_out.pdf")
			End Using
		Catch ex As PDFNetException
			Console.WriteLine(ex.Message)
		Catch ex As Exception
			MsgBox(ex.Message)
		End Try
		PDFNet.Terminate()
	End Sub
End Module
