'
' Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
'
Imports System

Imports pdftron
Imports pdftron.Common
Imports pdftron.Filters
Imports pdftron.SDF
Imports pdftron.PDF

Module StamperTestVB
	Dim pdfNetLoader As PDFNetLoader
	Sub New()
		pdfNetLoader = pdftron.PDFNetLoader.Instance()
	End Sub

	' The following sample shows how to add new content (or watermark) PDF pages
	' using 'pdftron.PDF.Stamper' utility class. 
	'
	' Stamper can be used to PDF pages with text, images, or with other PDF content 
	' in only a few lines of code. Although Stamper is very simple to use compared 
	' to ElementBuilder/ElementWriter it is not as powerful or flexible. In case you 
	' need full control over PDF creation use ElementBuilder/ElementWriter to add 
	' new content to existing PDF pages as shown in the ElementBuilder sample project.
	Sub Main()

		PDFNet.Initialize(PDFTronLicense.Key)

		Dim input_path As String = "../../../../TestFiles/"
		Dim output_path As String = "../../../../TestFiles/Output/"
		Dim input_filename As String = "newsletter"

		'--------------------------------------------------------------------------------
		' Example 1) Add text stamp to all pages, then remove text stamp from odd pages. 
		Try
			Using doc As PDFDoc = New PDFDoc(input_path + input_filename + ".pdf")
				doc.InitSecurityHandler()

				Using s As Stamper = New Stamper(Stamper.SizeType.e_relative_scale, 0.5, 0.5)
					s.SetAlignment(Stamper.HorizontalAlignment.e_horizontal_center, Stamper.VerticalAlignment.e_vertical_center)
					s.SetFontColor(New ColorPt(1, 0, 0)) ' set text color to red                
					s.StampText(doc, "If you are reading this" + ControlChars.Lf + "this is an even page", New PageSet(1, doc.GetPageCount()))
					'delete all text stamps in even pages
					Stamper.DeleteStamps(doc, New PageSet(1, doc.GetPageCount(), PageSet.Filter.e_odd))

					doc.Save(output_path + input_filename + ".ex1.pdf", SDFDoc.SaveOptions.e_linearized)
				End Using
			End Using
		Catch ex As PDFNetException
			Console.WriteLine(ex.Message)
		Catch ex As Exception
			MsgBox(ex.Message)
		End Try


		'--------------------------------------------------------------------------------
		' Example 2) Add Image stamp to first 2 pages. 
		Try
			Using doc As PDFDoc = New PDFDoc(input_path + input_filename + ".pdf")
				doc.InitSecurityHandler()

				Using s As Stamper = New Stamper(Stamper.SizeType.e_relative_scale, 0.05, 0.05)
					Dim img As Image = Image.Create(doc.GetSDFDoc(), input_path + "peppers.jpg")
					s.SetSize(Stamper.SizeType.e_relative_scale, 0.5, 0.5)
					'set position of the image to the center, left of PDF pages
					s.SetAlignment(Stamper.HorizontalAlignment.e_horizontal_left, Stamper.VerticalAlignment.e_vertical_center)
					s.SetFontColor(New ColorPt(0, 0, 0, 0))
					s.SetRotation(180)
					s.SetAsBackground(False)
					'only stamp first 2 pages
					s.StampImage(doc, img, New PageSet(1, 2))

					doc.Save(output_path + input_filename + ".ex2.pdf", SDFDoc.SaveOptions.e_linearized)
				End Using
			End Using
		Catch ex As PDFNetException
			Console.WriteLine(ex.Message)
		Catch ex As Exception
			MsgBox(ex.Message)
		End Try

		'--------------------------------------------------------------------------------
		' Example 3) Add Page stamp to all pages. 
		Try
			Using doc As PDFDoc = New PDFDoc(input_path + input_filename + ".pdf")
				doc.InitSecurityHandler()

				Using fish_doc As PDFDoc = New PDFDoc(input_path + "fish.pdf")
					fish_doc.InitSecurityHandler()

					Using s As Stamper = New Stamper(Stamper.SizeType.e_relative_scale, 0.5, 0.5)
						Dim src_page As Page = fish_doc.GetPage(1)
						Dim page_one_crop As Rect = src_page.GetCropBox()
						' set size of the image to 10% of the original while keep the old aspect ratio
						s.SetSize(Stamper.SizeType.e_absolute_size, page_one_crop.Width() * 0.1, -1)
						s.SetOpacity(0.4)
						s.SetRotation(-67)
						'put the image at the bottom right hand corner
						s.SetAlignment(Stamper.HorizontalAlignment.e_horizontal_right, Stamper.VerticalAlignment.e_vertical_bottom)
						s.StampPage(doc, src_page, New PageSet(1, doc.GetPageCount()))

						doc.Save(output_path + input_filename + ".ex3.pdf", SDFDoc.SaveOptions.e_linearized)
					End Using
				End Using
			End Using
		Catch ex As PDFNetException
			Console.WriteLine(ex.Message)
		Catch ex As Exception
			MsgBox(ex.Message)
		End Try

		'--------------------------------------------------------------------------------
		' Example 4) Add Image stamp to first 20 odd pages. 
		Try
			Using doc As PDFDoc = New PDFDoc(input_path + input_filename + ".pdf")
				doc.InitSecurityHandler()

				Using s As Stamper = New Stamper(Stamper.SizeType.e_absolute_size, 20, 20)
					s.SetOpacity(1)
					s.SetRotation(45)
					s.SetAsBackground(True)
					s.SetPosition(30, 40)
					Dim img As Image = Image.Create(doc.GetSDFDoc(), input_path + "peppers.jpg")
					s.StampImage(doc, img, New PageSet(1, 20, PageSet.Filter.e_odd))

					doc.Save(output_path + input_filename + ".ex4.pdf", SDFDoc.SaveOptions.e_linearized)
				End Using
			End Using
		Catch ex As PDFNetException
			Console.WriteLine(ex.Message)
		Catch ex As Exception
			MsgBox(ex.Message)
		End Try

		'--------------------------------------------------------------------------------
		' Example 5) Add text stamp to first 20 even pages
		Try
			Using doc As PDFDoc = New PDFDoc(input_path + input_filename + ".pdf")
				doc.InitSecurityHandler()

				Using s As Stamper = New Stamper(Stamper.SizeType.e_relative_scale, 0.05, 0.05)
					s.SetPosition(0, 0)
					s.SetOpacity(0.7)
					s.SetRotation(90)
					s.SetSize(Stamper.SizeType.e_font_size, 80, -1)
					s.SetTextAlignment(Stamper.TextAlignment.e_align_center)
					s.StampText(doc, "Goodbye" + ControlChars.Lf + "Moon", New PageSet(1, 20, PageSet.Filter.e_even))

					doc.Save(output_path + input_filename + ".ex5.pdf", SDFDoc.SaveOptions.e_linearized)
				End Using
			End Using
		Catch ex As PDFNetException
			Console.WriteLine(ex.Message)
		Catch ex As Exception
			MsgBox(ex.Message)
		End Try


		'--------------------------------------------------------------------------------
		' Example 6) Add first page as stamp to all even pages
		Try
			Using doc As PDFDoc = New PDFDoc(input_path + input_filename + ".pdf")
				doc.InitSecurityHandler()

				Using fish_doc As PDFDoc = New PDFDoc(input_path + "fish.pdf")
					fish_doc.InitSecurityHandler()

					Using s As Stamper = New Stamper(Stamper.SizeType.e_relative_scale, 0.3, 0.3)
						s.SetOpacity(1)
						s.SetRotation(270)
						s.SetAsBackground(True)
						s.SetPosition(0.5, 0.5, True)
						s.SetAlignment(Stamper.HorizontalAlignment.e_horizontal_left, Stamper.VerticalAlignment.e_vertical_bottom)
						Dim page_one As Page = fish_doc.GetPage(1)
						s.StampPage(doc, page_one, New PageSet(1, doc.GetPageCount(), PageSet.Filter.e_even))

						doc.Save(output_path + input_filename + ".ex6.pdf", SDFDoc.SaveOptions.e_linearized)
					End Using
				End Using
			End Using
		Catch ex As PDFNetException
			Console.WriteLine(ex.Message)
		Catch ex As Exception
			MsgBox(ex.Message)
		End Try

		'--------------------------------------------------------------------------------
		' Example 7) Add image stamp at top right corner in every pages
		Try
			Using doc As PDFDoc = New PDFDoc(input_path + input_filename + ".pdf")
				doc.InitSecurityHandler()

				Using s As Stamper = New Stamper(Stamper.SizeType.e_relative_scale, 0.1, 0.1)
					s.SetOpacity(0.8)
					s.SetRotation(135)
					s.SetAsBackground(False)
					s.ShowsOnPrint(False)
					s.SetAlignment(Stamper.HorizontalAlignment.e_horizontal_left, Stamper.VerticalAlignment.e_vertical_top)
					s.SetPosition(10, 10)

					Dim img As Image = Image.Create(doc.GetSDFDoc(), input_path + "peppers.jpg")
					s.StampImage(doc, img, New PageSet(1, doc.GetPageCount(), PageSet.Filter.e_all))

					doc.Save(output_path + input_filename + ".ex7.pdf", SDFDoc.SaveOptions.e_linearized)
				End Using
			End Using
		Catch ex As PDFNetException
			Console.WriteLine(ex.Message)
		Catch ex As Exception
			MsgBox(ex.Message)
		End Try

		'--------------------------------------------------------------------------------
		' Example 8) Add Text stamp to first 2 pages, and image stamp to first page.
		'          Because text stamp is set as background, the image is top of the text
		'          stamp. Text stamp on the first page is not visible.
		Try
			Using doc As PDFDoc = New PDFDoc(input_path + input_filename + ".pdf")
				doc.InitSecurityHandler()

				Using s As Stamper = New Stamper(Stamper.SizeType.e_relative_scale, 0.07, -0.1)
					s.SetAlignment(Stamper.HorizontalAlignment.e_horizontal_right, Stamper.VerticalAlignment.e_vertical_bottom)
					s.SetAlignment(Stamper.HorizontalAlignment.e_horizontal_center, Stamper.VerticalAlignment.e_vertical_top)
					s.SetFont(Font.Create(doc, Font.StandardType1Font.e_courier, True))
					s.SetFontColor(New ColorPt(1, 0, 0, 0))	'set color to red
					s.SetTextAlignment(Stamper.TextAlignment.e_align_right)
					s.SetAsBackground(True)	'set text stamp as background
					s.StampText(doc, "This is a title!", New PageSet(1, 2))

					Dim img As Image = Image.Create(doc.GetSDFDoc(), input_path + "peppers.jpg")
					s.SetAsBackground(False) ' set image stamp as foreground
					s.StampImage(doc, img, New PageSet(1))

					doc.Save(output_path + input_filename + ".ex8.pdf", SDFDoc.SaveOptions.e_linearized)
				End Using
			End Using
		Catch ex As PDFNetException
			Console.WriteLine(ex.Message)
		Catch ex As Exception
			MsgBox(ex.Message)
		End Try
		PDFNet.Terminate()
	End Sub
End Module
