'---------------------------------------------------------------------------------------
' Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
' Consult legal.txt regarding legal and license information.
'---------------------------------------------------------------------------------------
Imports System

Imports pdftron
Imports pdftron.Common
Imports pdftron.PDF

Module TransPDFTestVB
    Dim pdfNetLoader As PDFNetLoader
    Sub New()
        pdfNetLoader = pdftron.PDFNetLoader.Instance()
    End Sub

    ' The following sample illustrates how to extract xlf from a PDF document for translation.
    ' It then applies a pre-prepared translated xlf file to the PDF to produce a translated PDF. 
    Sub Main()

        ' The first step in every application using PDFNet is to initialize the 
        ' library and set the path to common PDF resources. The library is usually 
        ' initialized only once, but calling Initialize() multiple times is also fine.
        PDFNet.Initialize(PDFTronLicense.Key)

        ' Relative path to the folder containing test files.
        Dim input_path As String = "../../../../TestFiles/"
        Dim output_path As String = "../../../../TestFiles/Output/"

        Try

            ' Open a PDF document to translate
            Using doc As PDFDoc = New PDFDoc(input_path + "find-replace-test.pdf")
                Dim options As TransPDFOptions = New TransPDFOptions

                ' Set the source language in the options
                options.SetSourceLanguage("en")

                ' Set the number of pages to process in each batch
                options.SetBatchSize(20)

                ' Optionally, subset the pages to process
                ' This PDF only has a single page, but you can specify a subset of pages like this
                ' options.SetPages("-2,5-6,9,11-");

                ' Extract the xlf to file and field the PDF for translation
                TransPDF.ExtractXLIFF(doc, output_path + "find-replace-test.xlf", options)

                ' Save the fielded PDF
                doc.Save(output_path + "find-replace-test-fielded.pdf", SDF.SDFDoc.SaveOptions.e_linearized)

                ' The extracted xlf can be translated in a system of your choice.
                ' In this sample a pre-prepared translated file Is used - find-replace-test_(en_to_fr).xlf

                ' Perform the translation using the pre-prepared translated xliff
                TransPDF.ApplyXLIFF(doc, input_path + "find-replace-test_(en_to_fr).xlf", options)

                ' Save the translated PDF
                doc.Save(output_path + "find-replace-test-fr.pdf", SDF.SDFDoc.SaveOptions.e_linearized)
                doc.Close()
            End Using
        Catch e As PDFNetException
            Console.WriteLine(e.Message)
        End Try
        PDFNet.Terminate()
    End Sub

End Module
