'
' Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
'
Imports System
Imports pdftron 
Imports pdftron.Common 
Imports pdftron.Filters 
Imports pdftron.SDF 
Imports PDFTRON.PDF
Module U3DTestVB
    Dim pdfNetLoader As PDFNetLoader
	Sub New()
		pdfNetLoader = pdftron.PDFNetLoader.Instance()
	End Sub

    Sub Main()
        PDFNet.Initialize(PDFTronLicense.Key)
        Const output_path As String = "../../../../TestFiles/Output/"

        Try
			Using doc As PDFDoc = New PDFDoc
				Dim page As Page = doc.PageCreate
				doc.PagePushBack(page)
				Dim annots As Obj = doc.CreateIndirectArray
				page.GetSDFObj.Put("Annots", annots)
				U3DTest.Create3DAnnotation(doc, annots)
				doc.Save(output_path + "dice_u3d.pdf", SDFDoc.SaveOptions.e_linearized)
				Console.WriteLine("Done. Result saved in dice_u3d.pdf")
			End Using
        Catch e As PDFNetException
            Console.WriteLine(e.Message)
        End Try
        PDFNet.Terminate()
    End Sub

    Class U3DTest
        Shared Sub Create3DAnnotation(ByVal doc As PDFDoc, ByVal annots As Obj)
            ' ---------------------------------------------------------------------------------
            ' Create a 3D annotation based on U3D content. PDF 1.6 introduces the capability 
            ' for collections of three-dimensional objects, such as those used by CAD software, 
            ' to be embedded in PDF files.

            Const input_path As String = "../../../../TestFiles/"
            Dim link_3D As Obj = doc.CreateIndirectDict
            link_3D.PutName("Subtype", "3D")

            ' Annotation location on the page
            Dim bbox As Rect = New Rect(25, 180, 585, 643)
            link_3D.PutRect("Rect", bbox.x1, bbox.y1, bbox.x2, bbox.y2)
            annots.PushBack(link_3D)

            ' The 3DA entry is an activation dictionary (see Table 9.34 in the PDF Reference Manual) 
            ' that determines how the state of the annotation and its associated artwork can change.
            Dim activation_dict_3D As Obj = link_3D.PutDict("3DA")

            ' Set the annotation so that it is activated as soon as the page containing the 
            ' annotation is opened. Other options are: PV (page view) and XA (explicit) activation.

            ' Embed U3D Streams (3D Model/Artwork).
            activation_dict_3D.PutName("A", "PO")
            Dim u3d_file As MappedFile = New MappedFile(input_path + "dice.u3d")
            Dim u3d_reader As FilterReader = New FilterReader(u3d_file)
            Dim u3d_data_dict As Obj = doc.CreateIndirectStream(u3d_reader)
            u3d_data_dict.PutName("Subtype", "U3D")
            link_3D.Put("3DD", u3d_data_dict)

            ' Set the initial view of the 3D artwork that should be used when the annotation is activated.
            Dim view3D_dict As Obj = link_3D.PutDict("3DV")
            view3D_dict.PutString("IN", "Unnamed")
            view3D_dict.PutString("XN", "Default")
            view3D_dict.PutName("MS", "M")
            view3D_dict.PutNumber("CO", 27.5)

            ' A 12-element 3D transformation matrix that specifies a position and orientation 
            ' of the camera in world coordinates.
            Dim tr3d As Obj = view3D_dict.PutArray("C2W")
            tr3d.PushBackNumber(1)
            tr3d.PushBackNumber(0)
            tr3d.PushBackNumber(0)
            tr3d.PushBackNumber(0)
            tr3d.PushBackNumber(0)
            tr3d.PushBackNumber(-1)
            tr3d.PushBackNumber(0)
            tr3d.PushBackNumber(1)
            tr3d.PushBackNumber(0)
            tr3d.PushBackNumber(0)
            tr3d.PushBackNumber(-27.5)
            tr3d.PushBackNumber(0)

            ' Create annotation appearance stream, a thumbnail which is used during printing or
            ' in PDF processors that do not understand 3D data.
            Dim ap_dict As Obj = link_3D.PutDict("AP")

			Using builder As ElementBuilder = New ElementBuilder
				Using writer As ElementWriter = New ElementWriter
					writer.Begin(doc.GetSDFDoc)
					writer.WritePlacedElement(builder.CreateImage(Image.Create(doc.GetSDFDoc, input_path + "dice.jpg"), 0, 0, bbox.Width, bbox.Height))
					Dim normal_ap_stream As Obj = writer.End
					normal_ap_stream.PutName("Subtype", "Form")
					normal_ap_stream.PutRect("BBox", 0, 0, bbox.Width, bbox.Height)
					ap_dict.Put("N", normal_ap_stream)
				End Using
			End Using
		End Sub
    End Class

End Module
