'---------------------------------------------------------------------------------------
' Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
' Consult legal.txt regarding legal and license information.     
'---------------------------------------------------------------------------------------
Imports System
Imports pdftron
Imports pdftron.Common
Imports pdftron.PDF
Imports pdftron.SDF

Module UndoRedoTestVB
	Dim pdfNetLoader As PDFNetLoader
	Sub New()
		pdfNetLoader = pdftron.PDFNetLoader.Instance()
	End Sub

	
	Sub Main()
		' The first step in every application using PDFNet is to initialize the 
		' library and set the path to common PDF resources. The library is usually 
		' initialized only once, but calling Initialize() multiple times is also fine.
		PDFNet.Initialize(PDFTronLicense.Key)
		
		' Relative path to the folder containing test files.
		Dim input_path As String = "../../../../TestFiles/"
		Dim output_path As String = "../../../../TestFiles/Output/"

		Try
			' Open the PDF document.
			Using doc As PDFDoc = New PDFDoc(input_path & "newsletter.pdf")
				Using bld As ElementBuilder = New ElementBuilder()       ' Used to build new Element objects
					Using writer As ElementWriter = New ElementWriter()      ' Used to write Elements to the page
						Dim undo_manager As UndoManager = doc.GetUndoManager()
						' Take a snapshot to which we can undo after making changes.
						Dim snap0 As ResultSnapshot = undo_manager.TakeSnapshot()
						Dim snap0_state As DocSnapshot = snap0.CurrentState()
						Dim page As Page = doc.PageCreate()	' Start a new page
						writer.Begin(page)		' Begin writing to this page
						' ----------------------------------------------------------
						' Add JPEG image to the file
						Dim img As Image = Image.Create(doc, input_path & "peppers.jpg")
						Dim element As Element = bld.CreateImage(img, New Matrix2D(200, 0, 0, 250, 50, 500))
						writer.WritePlacedElement(element)
						writer.End()	' Finish writing to the page
						doc.PagePushFront(page)
						
						' Take a snapshot after making changes, so that we can redo later (after undoing first).
						Dim snap1 As ResultSnapshot = undo_manager.TakeSnapshot()
						If snap1.PreviousState().Equals(snap0_state) Then
							Console.WriteLine("snap1 previous state equals snap0_state; previous state is correct")
						End If

						Dim snap1_state As DocSnapshot = snap1.CurrentState()
						doc.Save(output_path & "addimage.pdf", SDFDoc.SaveOptions.e_incremental)
						
						If undo_manager.CanUndo() Then
							Dim undo_snap As ResultSnapshot = undo_manager.Undo()
							doc.Save(output_path & "addimage_undone.pdf", SDFDoc.SaveOptions.e_incremental)
							
							Dim undo_snap_state As DocSnapshot = undo_snap.CurrentState()
							If undo_snap_state.Equals(snap0_state) Then
								Console.WriteLine("undo_snap_state equals snap0_state; undo was successful")
							End If

							If undo_manager.CanRedo() Then
								Dim redo_snap As ResultSnapshot = undo_manager.Redo()
								doc.Save(output_path & "addimage_redone.pdf", SDFDoc.SaveOptions.e_incremental)

								If redo_snap.PreviousState().Equals(undo_snap_state) Then
									Console.WriteLine("redo_snap previous state equals undo_snap_state; previous state is correct")
								End If

								Dim redo_snap_state As DocSnapshot = redo_snap.CurrentState()

								If redo_snap_state.Equals(snap1_state) Then
									Console.WriteLine("Snap1 and redo_snap are equal; redo was successful")
								End If
							Else
								Console.WriteLine("Problem encountered - cannot undo.")
							End If
						Else
							Console.WriteLine("Problem encountered - cannot undo.")
						End If
					End Using
				End Using
			End Using

		Catch e As PDFNetException
			Console.WriteLine(e.Message)
		End Try
		PDFNet.Terminate()
	End Sub
End Module
