'
' Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
'

Imports pdftron
Imports pdftron.Common
Imports pdftron.Filters
Imports pdftron.SDF
Imports pdftron.PDF

''' <summary>
''' The following sample illustrates how to convert PDF, XPS, image, MS Office, and 
''' other image document formats to XOD format.
'''
''' Certain file formats such as PDF, generic XPS, EMF, and raster image formats can 
''' be directly converted to XOD. Other formats such as MS Office 
''' (Word, Excel, Publisher, Powerpoint, etc) can be directly converted via interop. 
''' These types of conversions guarantee optimal output, while preserving important 
''' information such as document metadata, intra document links and hyper-links, 
''' bookmarks etc. 
'''
''' In case there is no direct conversion available, PDFNet can still convert from 
''' any printable document to XOD using a virtual printer driver. To check 
''' if a virtual printer is required use Convert::RequiresPrinter(filename). In this 
''' case the installing application must be run as administrator. The manifest for this 
''' sample specifies appropriate the UAC elevation. The administrator privileges are 
''' not required for direct or interop conversions. 
'''
''' Please note that PDFNet Publisher (i.e. 'pdftron.PDF.Convert.ToXod') is an
''' optionally licensable add-on to PDFNet Core SDK. For details, please see
''' https://apryse.com/pricing
''' </summary> 
Class Testfile
	Public inputFile As String, outputFile As String
	Public Sub New(ByVal inFile As String, ByVal outFile As String)
		inputFile = inFile
		outputFile = outFile
	End Sub
End Class

Module WebViewerConvertTestVB
	Dim pdfNetLoader As PDFNetLoader
	Sub New()
		pdfNetLoader = pdftron.PDFNetLoader.Instance()
	End Sub
	
	' Relative path to the folder containing test files.
	Dim inputPath As String = "../../../../TestFiles/"
	Dim outputPath As String = "../../../../TestFiles/Output/"

	Private Sub BulkConvertRandomFilesToXod()
		Dim err As Integer = 0
		Dim testfiles As New System.Collections.ArrayList()
		testfiles.Add(New Testfile("simple-powerpoint_2007.pptx", "simple-powerpoint_2007.xod"))
		testfiles.Add(New Testfile("simple-word_2007.docx", "simple-word_2007.xod"))
		testfiles.Add(New Testfile("butterfly.png", "butterfly.xod"))
		testfiles.Add(New Testfile("numbered.pdf", "numbered.xod"))
		testfiles.Add(New Testfile("dice.jpg", "dice.xod"))
		testfiles.Add(New Testfile("simple-xps.xps", "simple-xps.xod"))

		For Each file As Testfile In testfiles
			Try
				If pdftron.PDF.Convert.RequiresPrinter(inputPath + file.inputFile) Then
					Console.WriteLine("Using PDFNet printer to convert file " & file.inputFile)
				End If

				pdftron.PDF.Convert.ToXod(inputPath + file.inputFile, outputPath + file.outputFile)
				Console.WriteLine("Converted file: " & file.inputFile & "to: " & file.outputFile)
			Catch e As PDFNetException
				Console.WriteLine("ERROR: on input file " & file.inputFile)
				Console.WriteLine(e.Message)
				err = 1
			End Try
		Next
		If err = 1 Then
			Console.WriteLine("ConvertFile failed")
		Else
			Console.WriteLine("ConvertFile succeeded")
		End If

	End Sub

	Sub Main()
		PDFNet.Initialize(PDFTronLicense.Key)

		' Sample 1:
		' Directly convert from PDF to XOD.
		pdftron.PDF.Convert.ToXod(inputPath + "newsletter.pdf", outputPath + "from_pdf.xod")

		' Sample 2:
		' Directly convert from generic XPS to XOD.
		pdftron.PDF.Convert.ToXod(inputPath + "simple-xps.xps", outputPath + "from_xps.xod")

		' Sample 3:
		' Convert from MS Office (does not require printer driver for Office 2007+)
		' and other document formats to XOD.
		BulkConvertRandomFilesToXod()
		PDFNet.Terminate()
		Console.WriteLine("Done.")
	End Sub

End Module

