﻿<%--
//
// Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved.
//
--%>

<%--
    This code demonstrates how to convert and stream a given file.

    In this example, the file is provided by the query parameter "file", which will
    be converted and streamed using PDFNet SDK.// Note that when using the 64-bit version of PDFNet, it must be run in a 64-bit web server.

    The Microsoft development web server is 32-bit only. The options are to use the 32-bit version of PDFNet
    for development purposes, or to configure Visual Studio to run an alternate, 64-bit web server,
    such as IIS or Cassini (http://cassinidev.codeplex.com/).
--%>
<%@ Page Language="C#" AutoEventWireup="true" %>

<%@ Import Namespace="pdftron" %>
<%@ Import Namespace="System.Diagnostics" %>

<%   
    String file = Request["file"];
    if (String.IsNullOrEmpty(file)) {
        // if no parameter passed, just use the default file
        file = "newsletter.pdf";
    }

    file = String.Format("{0}{1}{2}", Server.MapPath("."), "/../../TestFiles/", file);
    
    // Clear the header and contents in order to serve xod file instead of html.
    Response.Clear();
    Response.ContentType = "application/vnd.ms-xpsdocument";

    try {
        PDFNet.Initialize();

        // thumbnails are not used for streaming, so generating and transfering them is a waste of resources
        pdftron.PDF.Convert.XODOutputOptions options = new pdftron.PDF.Convert.XODOutputOptions();
        options.SetOutputThumbnails(false);

        // point to the source file on disk that is to be converted, and begin the conversion
        Debug.WriteLine("Prepare conversion...");
        pdftron.Filters.Filter filter = pdftron.PDF.Convert.ToXod(file, options);

        // now ready to stream the document as it is converted
        pdftron.Filters.FilterReader fReader = new pdftron.Filters.FilterReader(filter);

        byte[] buffer = new byte[64 * 1024]; //64 KB chunks

        int bytesRead = 0;
        bytesRead = fReader.Read(buffer);
        Response.BufferOutput = false;

        int totalBytesSent = 0;

        Debug.WriteLine("Commence streaming...");
        while (bytesRead > 0) {
            // write bytes to the response stream
            Response.OutputStream.Write(buffer, 0, bytesRead);

            // write to output how many bytes have been sent
            totalBytesSent += bytesRead;
            Debug.WriteLine("Server sent total " + totalBytesSent + " bytes.");
            // read next bytes
            bytesRead = fReader.Read(buffer);
        }

        Debug.WriteLine("Done.");     
        
        HttpContext.Current.ApplicationInstance.CompleteRequest();  // ensure all bytes have been sent and stop execution
    }
    catch (HttpException ex) {
        // if the page is left part way through streaming
        Debug.WriteLine("Error: " + ex.Message);
    }
    catch (Exception ex) {
        Debug.WriteLine("Error: " + ex.Message);
        Debug.WriteLine("at " + ex.StackTrace);
        Response.StatusCode = 500;
    }
%>

