/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.crypto;

import com.pdftron.common.PDFNetException;
import com.pdftron.crypto.DigestAlgorithm;

public class ObjectIdentifier
implements AutoCloseable {
    static final int e_common_name = 0;
    static final int e_surname = 1;
    static final int e_country_name = 2;
    static final int e_locality_name = 3;
    static final int e_state_or_province_name = 4;
    static final int e_street_address = 5;
    static final int e_organization_name = 6;
    static final int e_organizational_unit_name = 7;
    static final int e_SHA1 = 8;
    static final int e_SHA256 = 9;
    static final int e_SHA384 = 10;
    static final int e_SHA512 = 11;
    static final int e_RIPEMD160 = 12;
    static final int e_RSA_encryption_PKCS1 = 13;
    static final int e_RSASSA_PSS = 14;
    static final int e_MGF1 = 15;
    private long mImpl;

    public void destroy() throws PDFNetException {
        if (this.mImpl != 0L) {
            ObjectIdentifier.Destroy(this.mImpl);
            this.mImpl = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    ObjectIdentifier(long l) {
        this.mImpl = l;
    }

    public ObjectIdentifier(Predefined predefined) throws PDFNetException {
        this.mImpl = ObjectIdentifier.CreateFromPredefined(predefined.getValue());
    }

    public ObjectIdentifier(DigestAlgorithm digestAlgorithm) throws PDFNetException {
        this.mImpl = ObjectIdentifier.CreateFromDigestAlgorithm(digestAlgorithm.value);
    }

    public int[] getRawValue() throws PDFNetException {
        return ObjectIdentifier.GetRawValue(this.mImpl);
    }

    public ObjectIdentifier(int[] nArray) throws PDFNetException {
        this.mImpl = ObjectIdentifier.CreateFromIntArr(nArray);
    }

    public long __GetHandle() {
        return this.mImpl;
    }

    @Override
    public void close() throws PDFNetException {
        this.destroy();
    }

    static native void Destroy(long var0);

    static native long CreateFromPredefined(int var0);

    static native long CreateFromIntArr(int[] var0);

    static native long CreateFromDigestAlgorithm(int var0);

    static native int[] GetRawValue(long var0);

    public static enum Predefined {
        common_name(0),
        surname(1),
        country_name(2),
        locality_name(3),
        state_or_province_name(4),
        street_address(5),
        organization_name(6),
        organizational_unit_name(7),
        SHA1(8),
        SHA256(9),
        SHA384(10),
        SHA512(11),
        RIPEMD160(12),
        RSA_encryption_PKCS1(13),
        RSASSA_PSS(14),
        MGF1(15);

        private final int mode;

        private Predefined(int n2) {
            this.mode = n2;
        }

        public int getValue() {
            return this.mode;
        }
    }
}

