/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.BarcodeOptions;
import com.pdftron.pdf.PDFDoc;

public class BarcodeModule {
    private BarcodeModule() {
    }

    public static boolean isModuleAvailable() throws PDFNetException {
        return BarcodeModule.IsModuleAvailable();
    }

    public static void extractBarcodes(PDFDoc pDFDoc, String string, BarcodeOptions barcodeOptions) throws PDFNetException {
        if (barcodeOptions == null) {
            barcodeOptions = new BarcodeOptions();
        }
        BarcodeModule.ExtractBarcodes(pDFDoc.__GetHandle(), string, barcodeOptions.getObjHandle());
        ReachabilityHelper.ensureReachable(barcodeOptions);
        ReachabilityHelper.ensureReachable(pDFDoc);
    }

    public static void extractBarcodes(PDFDoc pDFDoc, String string) throws PDFNetException {
        BarcodeModule.extractBarcodes(pDFDoc, string, null);
    }

    public static String extractBarcodesAsString(PDFDoc pDFDoc, BarcodeOptions barcodeOptions) throws PDFNetException {
        if (barcodeOptions == null) {
            barcodeOptions = new BarcodeOptions();
        }
        String string = BarcodeModule.ExtractBarcodesAsString(pDFDoc.__GetHandle(), barcodeOptions.getObjHandle());
        ReachabilityHelper.ensureReachable(barcodeOptions);
        ReachabilityHelper.ensureReachable(pDFDoc);
        return string;
    }

    public static String extractBarcodesAsString(PDFDoc pDFDoc) throws PDFNetException {
        return BarcodeModule.extractBarcodesAsString(pDFDoc, null);
    }

    static native boolean IsModuleAvailable();

    static native void ExtractBarcodes(long var0, String var2, long var3);

    static native String ExtractBarcodesAsString(long var0, long var2);
}

