/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.pdf.OptionsBase;
import com.pdftron.sdf.Obj;
import java.util.HashMap;

public class BarcodeOptions
extends OptionsBase {
    public BarcodeOptions() throws PDFNetException {
    }

    public BarcodeOptions(String string) throws PDFNetException {
        super(string);
    }

    @Override
    long getObjHandle() throws PDFNetException {
        return this.mDict.__GetHandle();
    }

    public int getBarcodeOrientations() throws PDFNetException {
        Obj obj = this.mDict.findObj("BarcodeOrientations");
        if (obj != null && !obj.isNull()) {
            return (int)obj.getNumber();
        }
        return Integer.MAX_VALUE;
    }

    public BarcodeOptions setBarcodeOrientations(int n) throws PDFNetException {
        this.putNumber("BarcodeOrientations", n);
        return this;
    }

    public BarcodeProfile getBarcodeProfile() throws PDFNetException {
        Obj obj = this.mDict.findObj("BarcodeProfile");
        if (obj != null && !obj.isNull()) {
            return BarcodeProfile.valueToEnum((int)obj.getNumber());
        }
        return BarcodeProfile.valueToEnum(1);
    }

    public BarcodeOptions setBarcodeProfile(BarcodeProfile barcodeProfile) throws PDFNetException {
        this.putNumber("BarcodeProfile", barcodeProfile.value);
        return this;
    }

    public int getBarcodeSearchTypes() throws PDFNetException {
        Obj obj = this.mDict.findObj("BarcodeSearchTypes");
        if (obj != null && !obj.isNull()) {
            return (int)obj.getNumber();
        }
        return Integer.MAX_VALUE;
    }

    public BarcodeOptions setBarcodeSearchTypes(int n) throws PDFNetException {
        this.putNumber("BarcodeSearchTypes", n);
        return this;
    }

    public OutputFormat getDataOutputFormat() throws PDFNetException {
        Obj obj = this.mDict.findObj("DataOutputFormat");
        if (obj != null && !obj.isNull()) {
            return OutputFormat.valueToEnum((int)obj.getNumber());
        }
        return OutputFormat.valueToEnum(0);
    }

    public BarcodeOptions setDataOutputFormat(OutputFormat outputFormat) throws PDFNetException {
        this.putNumber("DataOutputFormat", outputFormat.value);
        return this;
    }

    public String getPages() throws PDFNetException {
        Obj obj = this.mDict.findObj("Pages");
        if (obj != null && !obj.isNull()) {
            return obj.getAsPDFText();
        }
        return "";
    }

    public BarcodeOptions setPages(String string) throws PDFNetException {
        this.putText("Pages", string);
        return this;
    }

    public static enum OutputFormat {
        e_auto(0),
        e_binary(1);

        final int value;
        private static HashMap<Integer, OutputFormat> output_format_map;

        private OutputFormat(int n2) {
            this.value = n2;
        }

        static OutputFormat valueToEnum(int n) {
            return output_format_map.get(n);
        }

        static {
            output_format_map = new HashMap();
            for (OutputFormat outputFormat : OutputFormat.values()) {
                output_format_map.put(outputFormat.value, outputFormat);
            }
        }
    }

    public static enum BarcodeProfile {
        e_high_quality_source_profile(1),
        e_low_quality_source_profile(2),
        e_small_barcodes_profile(3),
        e_natural_picture_profile(4);

        final int value;
        private static HashMap<Integer, BarcodeProfile> barcode_profile_map;

        private BarcodeProfile(int n2) {
            this.value = n2;
        }

        static BarcodeProfile valueToEnum(int n) {
            return barcode_profile_map.get(n);
        }

        static {
            barcode_profile_map = new HashMap();
            for (BarcodeProfile barcodeProfile : BarcodeProfile.values()) {
                barcode_profile_map.put(barcodeProfile.value, barcodeProfile);
            }
        }
    }

    public static final class BarcodeOrientation {
        public static final int e_horizontal = 1;
        public static final int e_vertical = 2;
        public static final int e_diagonal = 4;
    }

    public static final class BarcodeTypeGroup {
        public static final int e_none = 0;
        public static final int e_linear = 1;
        public static final int e_post_net_planet = 2;
        public static final int e_four_state = 4;
        public static final int e_gs1_databar_stacked = 8;
        public static final int e_qr = 16;
        public static final int e_data_matrix = 32;
        public static final int e_aztec = 64;
        public static final int e_maxi = 128;
        public static final int e_micro_qr = 256;
        public static final int e_pdf417 = 512;
        public static final int e_micro_pdf417 = 1024;
        public static final int e_patch_code = 2048;
        public static final int e_pharma_code = 4096;
    }
}

