/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.filters.Filter;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.AdvancedImagingConvertOptions;
import com.pdftron.pdf.BlackBoxContext;
import com.pdftron.pdf.CADConvertOptions;
import com.pdftron.pdf.ConversionOptions;
import com.pdftron.pdf.DocumentConversion;
import com.pdftron.pdf.Page;
import com.pdftron.pdf.Reflow;
import com.pdftron.pdf.SVGConvertOptions;
import com.pdftron.pdf.TemplateDocument;
import com.pdftron.pdf.WordToPDFOptions;
import com.pdftron.sdf.Doc;
import com.pdftron.sdf.Obj;
import com.pdftron.sdf.ObjSet;
import java.util.HashMap;

public class Convert {
    public static final int e_very_strict = 0;
    public static final int e_strict = 1;
    public static final int e_default = 2;
    public static final int e_keep_most = 3;
    public static final int e_keep_all = 4;
    public static final int e_off = 0;
    public static final int e_simple = 1;
    public static final int e_fast = 2;
    public static final int e_high_quality = 3;

    public static void fromXps(Doc doc, String string) throws PDFNetException {
        Convert.FromXps(doc.__GetHandle(), string);
        ReachabilityHelper.ensureReachable(doc);
    }

    public static void fromXps(Doc doc, byte[] byArray) throws PDFNetException {
        Convert.FromXpsBuf(doc.__GetHandle(), byArray);
        ReachabilityHelper.ensureReachable(doc);
    }

    public static void fromEmf(Doc doc, String string) throws PDFNetException {
        Convert.FromEmf(doc.__GetHandle(), string);
        ReachabilityHelper.ensureReachable(doc);
    }

    public static void fromText(Doc doc, String string, Obj obj) throws PDFNetException {
        Convert.FromText(doc.__GetHandle(), string, obj.__GetHandle());
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(obj);
    }

    public static void toEmf(Doc doc, String string) throws PDFNetException {
        Convert.DocToEmf(doc.__GetHandle(), string);
        ReachabilityHelper.ensureReachable(doc);
    }

    public static void toEmf(Page page, String string) throws PDFNetException {
        Convert.PageToEmf(page.impl, string);
        ReachabilityHelper.ensureReachable(page);
    }

    public static void toSvg(Doc doc, String string) throws PDFNetException {
        Convert.DocToSvg(doc.__GetHandle(), string);
        ReachabilityHelper.ensureReachable(doc);
    }

    public static void toSvg(Doc doc, String string, SVGOutputOptions sVGOutputOptions) throws PDFNetException {
        Convert.DocToSvgWithOptions(doc.__GetHandle(), string, sVGOutputOptions.m_obj.__GetHandle());
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(sVGOutputOptions);
    }

    public static void toSvg(Page page, String string) throws PDFNetException {
        Convert.PageToSvg(page.impl, string);
        ReachabilityHelper.ensureReachable(page);
    }

    public static void toSvg(Page page, String string, SVGOutputOptions sVGOutputOptions) throws PDFNetException {
        Convert.PageToSvgWithOptions(page.impl, string, sVGOutputOptions.m_obj.__GetHandle());
        ReachabilityHelper.ensureReachable(page);
        ReachabilityHelper.ensureReachable(sVGOutputOptions);
    }

    public static void toXps(Doc doc, String string) throws PDFNetException {
        Convert.DocToXps(doc.__GetHandle(), string, 0L);
        ReachabilityHelper.ensureReachable(doc);
    }

    public static void toXps(Doc doc, String string, XPSOutputOptions xPSOutputOptions) throws PDFNetException {
        Convert.DocToXps(doc.__GetHandle(), string, xPSOutputOptions.m_obj.__GetHandle());
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(xPSOutputOptions);
    }

    public static void toXps(String string, String string2) throws PDFNetException {
        Convert.FileToXps(string, string2, 0L);
    }

    public static void toXps(String string, String string2, XPSOutputOptions xPSOutputOptions) throws PDFNetException {
        Convert.FileToXps(string, string2, xPSOutputOptions.m_obj.__GetHandle());
        ReachabilityHelper.ensureReachable(xPSOutputOptions);
    }

    public static void toXod(String string, String string2) throws PDFNetException {
        Convert.FileToXod(string, string2, 0L);
    }

    public static void toXod(String string, String string2, XODOutputOptions xODOutputOptions) throws PDFNetException {
        Convert.FileToXod(string, string2, xODOutputOptions.m_obj.__GetHandle());
        ReachabilityHelper.ensureReachable(xODOutputOptions);
    }

    public static void toXod(Doc doc, String string) throws PDFNetException {
        Convert.DocToXod(doc.__GetHandle(), string, 0L);
        ReachabilityHelper.ensureReachable(doc);
    }

    public static void toXod(Doc doc, String string, XODOutputOptions xODOutputOptions) throws PDFNetException {
        Convert.DocToXod(doc.__GetHandle(), string, xODOutputOptions.m_obj.__GetHandle());
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(xODOutputOptions);
    }

    public static Filter toXod(Doc doc) throws PDFNetException {
        Filter filter = Filter.__Create(Convert.DocToXodStream(doc.__GetHandle(), 0L), null);
        ReachabilityHelper.ensureReachable(doc);
        return filter;
    }

    public static Filter toXod(Doc doc, XODOutputOptions xODOutputOptions) throws PDFNetException {
        Filter filter = Filter.__Create(Convert.DocToXodStream(doc.__GetHandle(), xODOutputOptions.m_obj.__GetHandle()), null);
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(xODOutputOptions);
        return filter;
    }

    public static Filter toXod(String string) throws PDFNetException {
        return Filter.__Create(Convert.FileToXodStream(string, 0L), null);
    }

    public static Filter toXod(String string, XODOutputOptions xODOutputOptions) throws PDFNetException {
        Filter filter = Filter.__Create(Convert.FileToXodStream(string, xODOutputOptions.m_obj.__GetHandle()), null);
        ReachabilityHelper.ensureReachable(xODOutputOptions);
        return filter;
    }

    public static void toHtml(String string, String string2) throws PDFNetException {
        Convert.FileToHtml(string, string2, 0L);
    }

    public static void toHtml(String string, String string2, HTMLOutputOptions hTMLOutputOptions) throws PDFNetException {
        Convert.FileToHtml(string, string2, hTMLOutputOptions.m_obj.__GetHandle());
        ReachabilityHelper.ensureReachable(hTMLOutputOptions);
    }

    public static void toHtml(Doc doc, String string) throws PDFNetException {
        Convert.DocToHtml(doc.__GetHandle(), string, 0L);
        ReachabilityHelper.ensureReachable(doc);
    }

    public static void toHtml(Doc doc, String string, HTMLOutputOptions hTMLOutputOptions) throws PDFNetException {
        Convert.DocToHtml(doc.__GetHandle(), string, hTMLOutputOptions.m_obj.__GetHandle());
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(hTMLOutputOptions);
    }

    public static void toWord(String string, String string2) throws PDFNetException {
        Convert.FileToWord(string, string2, 0L);
    }

    public static void toWord(String string, String string2, WordOutputOptions wordOutputOptions) throws PDFNetException {
        Convert.FileToWord(string, string2, wordOutputOptions.m_obj.__GetHandle());
        ReachabilityHelper.ensureReachable(wordOutputOptions);
    }

    public static void toWord(Doc doc, String string) throws PDFNetException {
        Convert.DocToWord(doc.__GetHandle(), string, 0L);
        ReachabilityHelper.ensureReachable(doc);
    }

    public static void toWord(Doc doc, String string, WordOutputOptions wordOutputOptions) throws PDFNetException {
        Convert.DocToWord(doc.__GetHandle(), string, wordOutputOptions.m_obj.__GetHandle());
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(wordOutputOptions);
    }

    public static void toWord(Doc doc, Filter filter) throws PDFNetException {
        Convert.DocToWordWithFilter(doc.__GetHandle(), filter.__GetHandle(), 0L);
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(filter);
    }

    public static void toWord(Doc doc, Filter filter, WordOutputOptions wordOutputOptions) throws PDFNetException {
        Convert.DocToWordWithFilter(doc.__GetHandle(), filter.__GetHandle(), wordOutputOptions.m_obj.__GetHandle());
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(filter);
        ReachabilityHelper.ensureReachable(wordOutputOptions);
    }

    public static void toExcel(String string, String string2) throws PDFNetException {
        Convert.FileToExcel(string, string2, 0L);
    }

    public static void toExcel(String string, String string2, ExcelOutputOptions excelOutputOptions) throws PDFNetException {
        Convert.FileToExcel(string, string2, excelOutputOptions.m_obj.__GetHandle());
        ReachabilityHelper.ensureReachable(excelOutputOptions);
    }

    public static void toExcel(Doc doc, String string) throws PDFNetException {
        Convert.DocToExcel(doc.__GetHandle(), string, 0L);
        ReachabilityHelper.ensureReachable(doc);
    }

    public static void toExcel(Doc doc, String string, ExcelOutputOptions excelOutputOptions) throws PDFNetException {
        Convert.DocToExcel(doc.__GetHandle(), string, excelOutputOptions.m_obj.__GetHandle());
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(excelOutputOptions);
    }

    public static void toExcel(Doc doc, Filter filter) throws PDFNetException {
        Convert.DocToExcelWithFilter(doc.__GetHandle(), filter.__GetHandle(), 0L);
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(filter);
    }

    public static void toExcel(Doc doc, Filter filter, ExcelOutputOptions excelOutputOptions) throws PDFNetException {
        Convert.DocToExcelWithFilter(doc.__GetHandle(), filter.__GetHandle(), excelOutputOptions.m_obj.__GetHandle());
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(filter);
        ReachabilityHelper.ensureReachable(excelOutputOptions);
    }

    public static void toPowerPoint(String string, String string2) throws PDFNetException {
        Convert.FileToPowerPoint(string, string2, 0L);
    }

    public static void toPowerPoint(String string, String string2, PowerPointOutputOptions powerPointOutputOptions) throws PDFNetException {
        Convert.FileToPowerPoint(string, string2, powerPointOutputOptions.m_obj.__GetHandle());
        ReachabilityHelper.ensureReachable(powerPointOutputOptions);
    }

    public static void toPowerPoint(Doc doc, String string) throws PDFNetException {
        Convert.DocToPowerPoint(doc.__GetHandle(), string, 0L);
        ReachabilityHelper.ensureReachable(doc);
    }

    public static void toPowerPoint(Doc doc, String string, PowerPointOutputOptions powerPointOutputOptions) throws PDFNetException {
        Convert.DocToPowerPoint(doc.__GetHandle(), string, powerPointOutputOptions.m_obj.__GetHandle());
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(powerPointOutputOptions);
    }

    public static void toPowerPoint(Doc doc, Filter filter) throws PDFNetException {
        Convert.DocToPowerPointWithFilter(doc.__GetHandle(), filter.__GetHandle(), 0L);
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(filter);
    }

    public static void toPowerPoint(Doc doc, Filter filter, PowerPointOutputOptions powerPointOutputOptions) throws PDFNetException {
        Convert.DocToPowerPointWithFilter(doc.__GetHandle(), filter.__GetHandle(), powerPointOutputOptions.m_obj.__GetHandle());
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(filter);
        ReachabilityHelper.ensureReachable(powerPointOutputOptions);
    }

    public static void toEpub(String string, String string2) throws PDFNetException {
        Convert.FileToEpub(string, string2, 0L, 0L);
    }

    public static void toEpub(String string, String string2, HTMLOutputOptions hTMLOutputOptions) throws PDFNetException {
        Convert.FileToEpub(string, string2, hTMLOutputOptions.m_obj.__GetHandle(), 0L);
        ReachabilityHelper.ensureReachable(hTMLOutputOptions);
    }

    public static void toEpub(String string, String string2, EPUBOutputOptions ePUBOutputOptions) throws PDFNetException {
        Convert.FileToEpub(string, string2, 0L, ePUBOutputOptions.m_obj.__GetHandle());
        ReachabilityHelper.ensureReachable(ePUBOutputOptions);
    }

    public static void toEpub(String string, String string2, HTMLOutputOptions hTMLOutputOptions, EPUBOutputOptions ePUBOutputOptions) throws PDFNetException {
        Convert.FileToEpub(string, string2, hTMLOutputOptions.m_obj.__GetHandle(), ePUBOutputOptions.m_obj.__GetHandle());
        ReachabilityHelper.ensureReachable(hTMLOutputOptions);
        ReachabilityHelper.ensureReachable(ePUBOutputOptions);
    }

    public static void toEpub(Doc doc, String string) throws PDFNetException {
        Convert.DocToEpub(doc.__GetHandle(), string, 0L, 0L);
        ReachabilityHelper.ensureReachable(doc);
    }

    public static void toEpub(Doc doc, String string, HTMLOutputOptions hTMLOutputOptions) throws PDFNetException {
        Convert.DocToEpub(doc.__GetHandle(), string, hTMLOutputOptions.m_obj.__GetHandle(), 0L);
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(hTMLOutputOptions);
    }

    public static void toEpub(Doc doc, String string, EPUBOutputOptions ePUBOutputOptions) throws PDFNetException {
        Convert.DocToEpub(doc.__GetHandle(), string, 0L, ePUBOutputOptions.m_obj.__GetHandle());
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(ePUBOutputOptions);
    }

    public static void toEpub(Doc doc, String string, HTMLOutputOptions hTMLOutputOptions, EPUBOutputOptions ePUBOutputOptions) throws PDFNetException {
        Convert.DocToEpub(doc.__GetHandle(), string, hTMLOutputOptions.m_obj.__GetHandle(), ePUBOutputOptions.m_obj.__GetHandle());
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(hTMLOutputOptions);
        ReachabilityHelper.ensureReachable(ePUBOutputOptions);
    }

    public static void toTiff(String string, String string2) throws PDFNetException {
        Convert.FileToTiff(string, string2, 0L);
    }

    public static void toTiff(String string, String string2, TiffOutputOptions tiffOutputOptions) throws PDFNetException {
        Convert.FileToTiff(string, string2, tiffOutputOptions.m_obj.__GetHandle());
        ReachabilityHelper.ensureReachable(tiffOutputOptions);
    }

    public static void toTiff(Doc doc, String string) throws PDFNetException {
        Convert.DocToTiff(doc.__GetHandle(), string, 0L);
        ReachabilityHelper.ensureReachable(doc);
    }

    public static void toTiff(Doc doc, String string, TiffOutputOptions tiffOutputOptions) throws PDFNetException {
        Convert.DocToTiff(doc.__GetHandle(), string, tiffOutputOptions.m_obj.__GetHandle());
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(tiffOutputOptions);
    }

    public static void toTiff(String string, Filter filter) throws PDFNetException {
        Convert.FileToTiffWithFilter(string, filter.__GetHandle(), 0L);
        ReachabilityHelper.ensureReachable(filter);
    }

    public static void toTiff(String string, Filter filter, TiffOutputOptions tiffOutputOptions) throws PDFNetException {
        Convert.FileToTiffWithFilter(string, filter.__GetHandle(), tiffOutputOptions.m_obj.__GetHandle());
        ReachabilityHelper.ensureReachable(filter);
        ReachabilityHelper.ensureReachable(tiffOutputOptions);
    }

    public static void toTiff(Doc doc, Filter filter) throws PDFNetException {
        Convert.DocToTiffWithFilter(doc.__GetHandle(), filter.__GetHandle(), 0L);
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(filter);
    }

    public static void toTiff(Doc doc, Filter filter, TiffOutputOptions tiffOutputOptions) throws PDFNetException {
        Convert.DocToTiffWithFilter(doc.__GetHandle(), filter.__GetHandle(), tiffOutputOptions.m_obj.__GetHandle());
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(filter);
        ReachabilityHelper.ensureReachable(tiffOutputOptions);
    }

    public static DocumentConversion universalConversion(String string, ConversionOptions conversionOptions) throws PDFNetException {
        long l = 0L;
        if (conversionOptions != null) {
            l = conversionOptions.getObjHandle();
        }
        DocumentConversion documentConversion = new DocumentConversion(Convert.UniversalConversion(string, l));
        ReachabilityHelper.ensureReachable(conversionOptions);
        return documentConversion;
    }

    public static DocumentConversion universalConversion(Filter filter, ConversionOptions conversionOptions) throws PDFNetException {
        long l = 0L;
        if (conversionOptions != null) {
            l = conversionOptions.getObjHandle();
        }
        DocumentConversion documentConversion = new DocumentConversion(Convert.UniversalConversionWithFilter(filter.__GetHandle(), l));
        ReachabilityHelper.ensureReachable(conversionOptions);
        ReachabilityHelper.ensureReachable(filter);
        return documentConversion;
    }

    public static DocumentConversion appendUniversalConversion(DocumentConversion documentConversion, String string, ConversionOptions conversionOptions) throws PDFNetException {
        long l = 0L;
        if (conversionOptions != null) {
            l = conversionOptions.getObjHandle();
        }
        DocumentConversion documentConversion2 = new DocumentConversion(Convert.AppendUniversalConversion(documentConversion.__GetHandle(), string, l));
        ReachabilityHelper.ensureReachable(documentConversion);
        ReachabilityHelper.ensureReachable(conversionOptions);
        return documentConversion2;
    }

    public static DocumentConversion appendUniversalConversion(DocumentConversion documentConversion, Filter filter, ConversionOptions conversionOptions) throws PDFNetException {
        long l = 0L;
        if (conversionOptions != null) {
            l = conversionOptions.getObjHandle();
        }
        DocumentConversion documentConversion2 = new DocumentConversion(Convert.AppendUniversalConversionWithFilter(documentConversion.__GetHandle(), filter.__GetHandle(), l));
        ReachabilityHelper.ensureReachable(documentConversion);
        ReachabilityHelper.ensureReachable(conversionOptions);
        ReachabilityHelper.ensureReachable(filter);
        return documentConversion2;
    }

    public static void wordToPdf(Doc doc, String string, WordToPDFOptions wordToPDFOptions) throws PDFNetException {
        long l = 0L;
        if (wordToPDFOptions != null) {
            l = wordToPDFOptions.getObjHandle();
        }
        Convert.WordToPdf(doc.__GetHandle(), string, l);
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(wordToPDFOptions);
    }

    public static DocumentConversion wordToPdfConversion(Doc doc, String string, WordToPDFOptions wordToPDFOptions) throws PDFNetException {
        long l = 0L;
        if (wordToPDFOptions != null) {
            l = wordToPDFOptions.getObjHandle();
        }
        DocumentConversion documentConversion = new DocumentConversion(Convert.WordToPdfConversion(doc.__GetHandle(), string, l));
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(wordToPDFOptions);
        return documentConversion;
    }

    public static void wordToPdf(Doc doc, Filter filter, WordToPDFOptions wordToPDFOptions) throws PDFNetException {
        long l = 0L;
        if (wordToPDFOptions != null) {
            l = wordToPDFOptions.getObjHandle();
        }
        Convert.WordToPdfWithFilter(doc.__GetHandle(), filter.__GetHandle(), l);
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(wordToPDFOptions);
        ReachabilityHelper.ensureReachable(filter);
    }

    public static DocumentConversion wordToPdfConversion(Doc doc, Filter filter, WordToPDFOptions wordToPDFOptions) throws PDFNetException {
        long l = 0L;
        if (wordToPDFOptions != null) {
            l = wordToPDFOptions.getObjHandle();
        }
        DocumentConversion documentConversion = new DocumentConversion(Convert.WordToPdfConversionWithFilter(doc.__GetHandle(), filter.__GetHandle(), l));
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(wordToPDFOptions);
        ReachabilityHelper.ensureReachable(filter);
        return documentConversion;
    }

    public static void officeToPdf(Doc doc, String string, ConversionOptions conversionOptions) throws PDFNetException {
        long l = 0L;
        if (conversionOptions != null) {
            l = conversionOptions.getObjHandle();
        }
        Convert.OfficeToPdf(doc.__GetHandle(), string, l);
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(conversionOptions);
    }

    public static DocumentConversion streamingPdfConversion(String string, ConversionOptions conversionOptions) throws PDFNetException {
        long l = 0L;
        if (conversionOptions != null) {
            l = conversionOptions.getObjHandle();
        }
        DocumentConversion documentConversion = new DocumentConversion(Convert.UniversalConversion(string, l));
        ReachabilityHelper.ensureReachable(conversionOptions);
        return documentConversion;
    }

    public static void officeToPdf(Doc doc, Filter filter, ConversionOptions conversionOptions) throws PDFNetException {
        long l = 0L;
        if (conversionOptions != null) {
            l = conversionOptions.getObjHandle();
        }
        Convert.OfficeToPdfWithFilter(doc.__GetHandle(), filter.__GetHandle(), l);
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(conversionOptions);
        ReachabilityHelper.ensureReachable(filter);
    }

    public static DocumentConversion streamingPdfConversion(Filter filter, ConversionOptions conversionOptions) throws PDFNetException {
        long l = 0L;
        if (conversionOptions != null) {
            l = conversionOptions.getObjHandle();
        }
        DocumentConversion documentConversion = new DocumentConversion(Convert.UniversalConversionWithFilter(filter.__GetHandle(), l));
        ReachabilityHelper.ensureReachable(conversionOptions);
        ReachabilityHelper.ensureReachable(filter);
        return documentConversion;
    }

    public static DocumentConversion streamingPdfConversion(Doc doc, String string, ConversionOptions conversionOptions) throws PDFNetException {
        long l = 0L;
        if (conversionOptions != null) {
            l = conversionOptions.getObjHandle();
        }
        DocumentConversion documentConversion = new DocumentConversion(Convert.UniversalConversionWithPdf(doc.__GetHandle(), string, l));
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(conversionOptions);
        return documentConversion;
    }

    public static DocumentConversion streamingPdfConversion(Doc doc, Filter filter, ConversionOptions conversionOptions) throws PDFNetException {
        long l = 0L;
        if (conversionOptions != null) {
            l = conversionOptions.getObjHandle();
        }
        DocumentConversion documentConversion = new DocumentConversion(Convert.UniversalConversionWithPdfAndFilter(doc.__GetHandle(), filter.__GetHandle(), l));
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(conversionOptions);
        ReachabilityHelper.ensureReachable(filter);
        return documentConversion;
    }

    public static TemplateDocument createOfficeTemplate(String string, ConversionOptions conversionOptions) throws PDFNetException {
        long l = 0L;
        if (conversionOptions != null) {
            l = conversionOptions.getObjHandle();
        }
        TemplateDocument templateDocument = new TemplateDocument(Convert.CreateOfficeTemplateConversion(string, l));
        ReachabilityHelper.ensureReachable(conversionOptions);
        return templateDocument;
    }

    public static TemplateDocument createOfficeTemplate(Filter filter, ConversionOptions conversionOptions) throws PDFNetException {
        long l = 0L;
        if (conversionOptions != null) {
            l = conversionOptions.getObjHandle();
        }
        TemplateDocument templateDocument = new TemplateDocument(Convert.CreateOfficeTemplateConversionWithFilter(filter.__GetHandle(), l));
        ReachabilityHelper.ensureReachable(conversionOptions);
        ReachabilityHelper.ensureReachable(filter);
        return templateDocument;
    }

    public static BlackBoxContext createBlackBoxContext(String string) throws PDFNetException {
        return new BlackBoxContext(Convert.CreateBlackBoxContext(string));
    }

    public static BlackBoxContext createBlackBoxContextConvert(String string, String string2) throws PDFNetException {
        return new BlackBoxContext(Convert.CreateBlackBoxContextConvert(string, string2));
    }

    public static Reflow createReflow(Page page, String string) throws PDFNetException {
        Reflow reflow = new Reflow(Convert.CreateReflow(page.impl, string));
        ReachabilityHelper.ensureReachable(page);
        return reflow;
    }

    public static void toPdf(Doc doc, String string) throws PDFNetException {
        Convert.FileToPdf(doc.__GetHandle(), string);
        ReachabilityHelper.ensureReachable(doc);
    }

    public static void fromCAD(Doc doc, String string, CADConvertOptions cADConvertOptions) throws PDFNetException {
        long l = 0L;
        if (cADConvertOptions != null) {
            l = cADConvertOptions.getObjHandle();
        }
        Convert.FromCAD(doc.__GetHandle(), string, l);
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(cADConvertOptions);
    }

    public static void fromDICOM(Doc doc, String string, AdvancedImagingConvertOptions advancedImagingConvertOptions) throws PDFNetException {
        long l = 0L;
        if (advancedImagingConvertOptions != null) {
            l = advancedImagingConvertOptions.getObjHandle();
        }
        Convert.FromDICOM(doc.__GetHandle(), string, l);
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(advancedImagingConvertOptions);
    }

    public static void fromSVG(Doc doc, String string, SVGConvertOptions sVGConvertOptions) throws PDFNetException {
        long l = 0L;
        if (sVGConvertOptions != null) {
            l = sVGConvertOptions.getObjHandle();
        }
        Convert.FromSVG(doc.__GetHandle(), string, l);
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(sVGConvertOptions);
    }

    public static void fromTiff(Doc doc, Filter filter) throws PDFNetException {
        Convert.FromTiff(doc.__GetHandle(), filter.__GetHandle());
        ReachabilityHelper.ensureReachable(doc);
        ReachabilityHelper.ensureReachable(filter);
    }

    public static boolean requiresPrinter(String string) throws PDFNetException {
        return Convert.RequiresPrinter(string);
    }

    private static void setFlattenThresholdImpl(Obj obj, int n) throws PDFNetException {
        switch (n) {
            case 0: {
                obj.putName("FLATTEN_THRESHOLD", "VERY_STRICT");
                break;
            }
            case 1: {
                obj.putName("FLATTEN_THRESHOLD", "STRICT");
                break;
            }
            case 2: {
                obj.putName("FLATTEN_THRESHOLD", "DEFAULT");
                break;
            }
            case 3: {
                obj.putName("FLATTEN_THRESHOLD", "KEEP_MOST");
                break;
            }
            case 4: {
                obj.putName("FLATTEN_THRESHOLD", "KEEP_ALL");
            }
        }
    }

    private static void setFlattenContentImpl(Obj obj, int n) throws PDFNetException {
        switch (n) {
            case 0: {
                obj.putName("FLATTEN_CONTENT", "OFF");
                break;
            }
            case 1: {
                obj.putName("FLATTEN_CONTENT", "SIMPLE");
                break;
            }
            case 2: {
                obj.putName("FLATTEN_CONTENT", "FAST");
                break;
            }
            case 3: {
                obj.putName("FLATTEN_CONTENT", "HIGH_QUALITY");
            }
        }
    }

    static native void FromXps(long var0, String var2);

    static native void FromXpsBuf(long var0, byte[] var2);

    static native void FromEmf(long var0, String var2);

    static native void FromText(long var0, String var2, long var3);

    static native void DocToEmf(long var0, String var2);

    static native void PageToEmf(long var0, String var2);

    static native void DocToSvg(long var0, String var2);

    static native void DocToSvgWithOptions(long var0, String var2, long var3);

    static native void PageToSvg(long var0, String var2);

    static native void PageToSvgWithOptions(long var0, String var2, long var3);

    static native void DocToXps(long var0, String var2, long var3);

    static native void FileToXps(String var0, String var1, long var2);

    static native void FileToXod(String var0, String var1, long var2);

    static native void DocToXod(long var0, String var2, long var3);

    static native long FileToXodStream(String var0, long var1);

    static native long DocToXodStream(long var0, long var2);

    static native void FileToHtml(String var0, String var1, long var2);

    static native void DocToHtml(long var0, String var2, long var3);

    static native void FileToWord(String var0, String var1, long var2);

    static native void DocToWord(long var0, String var2, long var3);

    static native void DocToWordWithFilter(long var0, long var2, long var4);

    static native void FileToExcel(String var0, String var1, long var2);

    static native void DocToExcel(long var0, String var2, long var3);

    static native void DocToExcelWithFilter(long var0, long var2, long var4);

    static native void FileToPowerPoint(String var0, String var1, long var2);

    static native void DocToPowerPoint(long var0, String var2, long var3);

    static native void DocToPowerPointWithFilter(long var0, long var2, long var4);

    static native void FileToEpub(String var0, String var1, long var2, long var4);

    static native void DocToEpub(long var0, String var2, long var3, long var5);

    static native void FileToTiff(String var0, String var1, long var2);

    static native void DocToTiff(long var0, String var2, long var3);

    static native void FileToTiffWithFilter(String var0, long var1, long var3);

    static native void DocToTiffWithFilter(long var0, long var2, long var4);

    static native long UniversalConversion(String var0, long var1);

    static native long UniversalConversionWithFilter(long var0, long var2);

    static native long UniversalConversionWithPdf(long var0, String var2, long var3);

    static native long UniversalConversionWithPdfAndFilter(long var0, long var2, long var4);

    static native long AppendUniversalConversion(long var0, String var2, long var3);

    static native long AppendUniversalConversionWithFilter(long var0, long var2, long var4);

    static native void OfficeToPdf(long var0, String var2, long var3);

    static native void WordToPdf(long var0, String var2, long var3);

    static native long WordToPdfConversion(long var0, String var2, long var3);

    static native void OfficeToPdfWithFilter(long var0, long var2, long var4);

    static native void WordToPdfWithFilter(long var0, long var2, long var4);

    static native long WordToPdfConversionWithFilter(long var0, long var2, long var4);

    static native long CreateBlackBoxContext(String var0);

    static native long CreateBlackBoxContextConvert(String var0, String var1);

    static native long CreateReflow(long var0, String var2);

    static native void FileToPdf(long var0, String var2);

    static native void FromCAD(long var0, String var2, long var3);

    static native void FromDICOM(long var0, String var2, long var3);

    static native void FromSVG(long var0, String var2, long var3);

    static native void FromTiff(long var0, long var2);

    static native boolean RequiresPrinter(String var0);

    static native long CreateOfficeTemplateConversion(String var0, long var1);

    static native long CreateOfficeTemplateConversionWithFilter(long var0, long var2);

    public static class SVGOutputOptions {
        public static final int e_op_off = 0;
        public static final int e_op_on = 1;
        public static final int e_op_pdfx_on = 2;
        Obj m_obj;
        ObjSet m_objset;

        public SVGOutputOptions() {
            try {
                this.m_objset = new ObjSet();
                this.m_obj = this.m_objset.createDict();
            }
            catch (PDFNetException pDFNetException) {
                System.err.println("Error occurred when creating SVGOutputOptions.");
            }
        }

        public void setEmbedImages(boolean bl) throws PDFNetException {
            this.m_obj.putBool("EMBEDIMAGES", bl);
        }

        public void setNoFonts(boolean bl) throws PDFNetException {
            this.m_obj.putBool("NOFONTS", bl);
        }

        public void setSvgFonts(boolean bl) throws PDFNetException {
            this.m_obj.putBool("SVGFONTS", bl);
        }

        public void setEmbedFonts(boolean bl) throws PDFNetException {
            this.m_obj.putBool("EMBEDFONTS", bl);
        }

        public void setNoUnicode(boolean bl) throws PDFNetException {
            this.m_obj.putBool("NOUNICODE", bl);
        }

        public void setIndividualCharPlacement(boolean bl) throws PDFNetException {
            this.m_obj.putBool("INDIVIDUALCHARPLACEMENT", bl);
        }

        public void setRemoveCharPlacement(boolean bl) throws PDFNetException {
            this.m_obj.putBool("REMOVECHARPLACEMENT", bl);
        }

        public void setFlattenContent(int n) throws PDFNetException {
            Convert.setFlattenContentImpl(this.m_obj, n);
        }

        public void setFlattenThreshold(int n) throws PDFNetException {
            Convert.setFlattenThresholdImpl(this.m_obj, n);
        }

        void setFlattenDPI(int n) throws PDFNetException {
            this.m_obj.putNumber("DPI", n);
        }

        void setFlattenMaximumImagePixels(int n) throws PDFNetException {
            this.m_obj.putNumber("MAX_IMAGE_PIXELS", n);
        }

        public void setCompress(boolean bl) throws PDFNetException {
            this.m_obj.putBool("SVGZ", bl);
        }

        public void setOutputThumbnails(boolean bl) throws PDFNetException {
            this.m_obj.putBool("NOTHUMBS", !bl);
        }

        public void setThumbnailSize(int n) throws PDFNetException {
            this.m_obj.putNumber("THUMB_SIZE", n);
        }

        public void setCreateXmlWrapper(boolean bl) throws PDFNetException {
            this.m_obj.putBool("NOXMLDOC", !bl);
        }

        public void setDtd(boolean bl) throws PDFNetException {
            this.m_obj.putBool("OMITDTD", !bl);
        }

        public void setAnnots(boolean bl) throws PDFNetException {
            this.m_obj.putBool("NOANNOTS", !bl);
        }

        public void setOverprint(int n) throws PDFNetException {
            switch (n) {
                case 0: {
                    this.m_obj.putName("OVERPRINT_MODE", "OFF");
                    break;
                }
                case 1: {
                    this.m_obj.putName("OVERPRINT_MODE", "ON");
                    break;
                }
                case 2: {
                    this.m_obj.putName("OVERPRINT_MODE", "PDFX");
                }
            }
        }
    }

    public static class TiffOutputOptions {
        public static final int e_media = 0;
        public static final int e_crop = 1;
        public static final int e_bleed = 2;
        public static final int e_trim = 3;
        public static final int e_art = 4;
        public static final int e_op_off = 0;
        public static final int e_op_on = 1;
        public static final int e_op_pdfx_on = 2;
        Obj m_obj;
        ObjSet m_objset;

        public TiffOutputOptions() {
            try {
                this.m_objset = new ObjSet();
                this.m_obj = this.m_objset.createDict();
            }
            catch (PDFNetException pDFNetException) {
                System.err.println("Error Occurred when creating TiffOutputOptions.");
            }
        }

        public void setBox(int n) throws PDFNetException {
            switch (n) {
                case 0: {
                    this.m_obj.putName("BOX", "media");
                    break;
                }
                case 1: {
                    this.m_obj.putName("BOX", "crop");
                    break;
                }
                case 2: {
                    this.m_obj.putName("BOX", "bleed");
                    break;
                }
                case 3: {
                    this.m_obj.putName("BOX", "trim");
                    break;
                }
                case 4: {
                    this.m_obj.putName("BOX", "art");
                }
            }
        }

        public void setRotate(int n) throws PDFNetException {
            switch (n) {
                case 0: {
                    this.m_obj.putName("ROTATE", "0");
                    break;
                }
                case 90: {
                    this.m_obj.putName("ROTATE", "90");
                    break;
                }
                case 180: {
                    this.m_obj.putName("ROTATE", "180");
                    break;
                }
                case 270: {
                    this.m_obj.putName("ROTATE", "270");
                }
            }
        }

        public void setRotate(double d, double d2, double d3, double d4) throws PDFNetException {
            this.m_obj.putNumber("CLIP_X1", d);
            this.m_obj.putNumber("CLIP_Y1", d2);
            this.m_obj.putNumber("CLIP_X2", d3);
            this.m_obj.putNumber("CLIP_Y2", d4);
        }

        public void setPages(String string) throws PDFNetException {
            this.m_obj.putName("PAGES", string);
        }

        public void setOverprint(int n) throws PDFNetException {
            switch (n) {
                case 0: {
                    this.m_obj.putName("OVERPRINT", "off");
                    break;
                }
                case 1: {
                    this.m_obj.putName("OVERPRINT", "on");
                    break;
                }
                case 2: {
                    this.m_obj.putName("OVERPRINT", "pdfx");
                }
            }
        }

        public void setCMYK(boolean bl) throws PDFNetException {
            this.m_obj.putBool("CMYK", bl);
        }

        public void setDither(boolean bl) throws PDFNetException {
            this.m_obj.putBool("DITHER", bl);
        }

        public void setGray(boolean bl) throws PDFNetException {
            this.m_obj.putBool("GRAY", bl);
        }

        public void setMono(boolean bl) throws PDFNetException {
            this.m_obj.putBool("MONO", bl);
        }

        public void setAnnots(boolean bl) throws PDFNetException {
            this.m_obj.putBool("ANNOTS", bl);
        }

        public void setSmooth(boolean bl) throws PDFNetException {
            this.m_obj.putBool("SMOOTH", bl);
        }

        public void setPrintmode(boolean bl) throws PDFNetException {
            this.m_obj.putBool("PRINTMODE", bl);
        }

        public void setTransparentPage(boolean bl) throws PDFNetException {
            this.m_obj.putBool("TRANSPARENT_PAGE", bl);
        }

        public void setPalettized(boolean bl) throws PDFNetException {
            this.m_obj.putBool("PALETTIZED", bl);
        }

        public void setDPI(double d) throws PDFNetException {
            this.m_obj.putNumber("DPI", d);
        }

        public void setGamma(double d) throws PDFNetException {
            this.m_obj.putNumber("GAMMA", d);
        }

        public void setHRes(int n) throws PDFNetException {
            this.m_obj.putNumber("HRES", n);
        }

        public void setVRes(int n) throws PDFNetException {
            this.m_obj.putNumber("VRES", n);
        }
    }

    public static class EPUBOutputOptions {
        Obj m_obj;
        ObjSet m_objset;

        public EPUBOutputOptions() {
            try {
                this.m_objset = new ObjSet();
                this.m_obj = this.m_objset.createDict();
            }
            catch (PDFNetException pDFNetException) {
                System.err.println("Error Occurred when creating EPUBOutputOptions.");
            }
        }

        public void setExpanded(boolean bl) throws PDFNetException {
            this.m_obj.putBool("EPUB_EXPANDED", bl);
        }

        public void setReuseCover(boolean bl) throws PDFNetException {
            this.m_obj.putBool("EPUB_REUSE_COVER", bl);
        }
    }

    public static class PowerPointOutputOptions {
        public static final int e_ocr_text = 2;
        public static final int e_ocr_off = 3;
        public static final int e_ocr_always = 4;
        Obj m_obj;
        ObjSet m_objset;

        public PowerPointOutputOptions() {
            try {
                this.m_objset = new ObjSet();
                this.m_obj = this.m_objset.createDict();
            }
            catch (PDFNetException pDFNetException) {
                System.err.println("Error Occurred when creating PowerPointOutputOptions.");
            }
        }

        public void setPages(int n, int n2) throws PDFNetException {
            this.m_obj.putNumber("PAGE_FROM", n);
            this.m_obj.putNumber("PAGE_TO", n2);
        }

        public void setPDFPassword(String string) throws PDFNetException {
            this.m_obj.putText("PASSWORD", string);
        }

        public void setSearchableImageSetting(int n) throws PDFNetException {
            switch (n) {
                case 2: {
                    this.m_obj.putName("OCRED", "TEXT");
                    break;
                }
                case 4: {
                    this.m_obj.putName("OCRED", "ALWAYS");
                    break;
                }
                case 3: {
                    this.m_obj.putName("OCRED", "OFF");
                }
            }
        }

        public void setTextRecoveryNSE(boolean bl) throws PDFNetException {
            this.m_obj.putBool("USE_OCR_NSE", bl);
        }

        public void setLanguage(OutputOptionsOCR.LanguageChoice languageChoice) throws PDFNetException {
            this.m_obj.putText("LANGUAGE", OutputOptionsOCR.LanguageChoiceToString(languageChoice));
        }

        public void setPreferredOCREngine(OutputOptionsOCR.PreferredOCREngine preferredOCREngine) throws PDFNetException {
            this.m_obj.putText("PREFERREDOCR", OutputOptionsOCR.PreferredOCRChoiceToString(preferredOCREngine));
        }

        public void setCustomOCRLanguage(String string) throws PDFNetException {
            this.m_obj.putText("LANGUAGE", string);
        }

        public void setHeadersAndFootersSetting(StructuredOutputOptions.SectionConversionSetting sectionConversionSetting) throws PDFNetException {
            this.m_obj.putNumber("DETECT_HEADERSANDFOOTERS", sectionConversionSetting.ordinal());
        }

        public StructuredOutputOptions.SectionConversionSetting getHeadersAndFootersSetting() throws PDFNetException {
            Obj obj = this.m_obj.findObj("DETECT_HEADERSANDFOOTERS");
            return StructuredOutputOptions.sectionConversionSettingFromOption(obj);
        }

        public void setFootnotesSetting(StructuredOutputOptions.SectionConversionSetting sectionConversionSetting) throws PDFNetException {
            this.m_obj.putNumber("DETECT_FOOTNOTES", sectionConversionSetting.ordinal());
        }

        public StructuredOutputOptions.SectionConversionSetting getFootnotesSetting() throws PDFNetException {
            Obj obj = this.m_obj.findObj("DETECT_FOOTNOTES");
            return StructuredOutputOptions.sectionConversionSettingFromOption(obj);
        }
    }

    public static class ExcelOutputOptions {
        public static final int e_ocr_text = 2;
        public static final int e_ocr_off = 3;
        public static final int e_ocr_always = 4;
        Obj m_obj;
        ObjSet m_objset;

        public ExcelOutputOptions() {
            try {
                this.m_objset = new ObjSet();
                this.m_obj = this.m_objset.createDict();
            }
            catch (PDFNetException pDFNetException) {
                System.err.println("Error Occurred when creating ExcelOutputOptions.");
            }
        }

        public void setPages(int n, int n2) throws PDFNetException {
            this.m_obj.putNumber("PAGE_FROM", n);
            this.m_obj.putNumber("PAGE_TO", n2);
        }

        public void setPDFPassword(String string) throws PDFNetException {
            this.m_obj.putText("PASSWORD", string);
        }

        public void setSearchableImageSetting(int n) throws PDFNetException {
            switch (n) {
                case 2: {
                    this.m_obj.putName("OCRED", "TEXT");
                    break;
                }
                case 4: {
                    this.m_obj.putName("OCRED", "ALWAYS");
                    break;
                }
                case 3: {
                    this.m_obj.putName("OCRED", "OFF");
                }
            }
        }

        public void setTextRecoveryNSE(boolean bl) throws PDFNetException {
            this.m_obj.putBool("USE_OCR_NSE", bl);
        }

        public void setLanguage(OutputOptionsOCR.LanguageChoice languageChoice) throws PDFNetException {
            this.m_obj.putText("LANGUAGE", OutputOptionsOCR.LanguageChoiceToString(languageChoice));
        }

        public void setPreferredOCREngine(OutputOptionsOCR.PreferredOCREngine preferredOCREngine) throws PDFNetException {
            this.m_obj.putText("PREFERREDOCR", OutputOptionsOCR.PreferredOCRChoiceToString(preferredOCREngine));
        }

        public void setCustomOCRLanguage(String string) throws PDFNetException {
            this.m_obj.putText("LANGUAGE", string);
        }

        public void setNonTableContent(boolean bl) throws PDFNetException {
            this.m_obj.putBool("NON_TABLES", bl);
        }

        public void setSingleSheet(boolean bl) throws PDFNetException {
            this.m_obj.putBool("SINGLE_SHEET", bl);
        }

        public void setPageSingleSheet(boolean bl) throws PDFNetException {
            this.m_obj.putBool("PAGE_SINGLE", bl);
        }

        public void setHeadersAndFootersSetting(StructuredOutputOptions.SectionConversionSetting sectionConversionSetting) throws PDFNetException {
            this.m_obj.putNumber("DETECT_HEADERSANDFOOTERS", sectionConversionSetting.ordinal());
        }

        public StructuredOutputOptions.SectionConversionSetting getHeadersAndFootersSetting() throws PDFNetException {
            Obj obj = this.m_obj.findObj("DETECT_HEADERSANDFOOTERS");
            return StructuredOutputOptions.sectionConversionSettingFromOption(obj);
        }

        public void setFootnotesSetting(StructuredOutputOptions.SectionConversionSetting sectionConversionSetting) throws PDFNetException {
            this.m_obj.putNumber("DETECT_FOOTNOTES", sectionConversionSetting.ordinal());
        }

        public StructuredOutputOptions.SectionConversionSetting getFootnotesSetting() throws PDFNetException {
            Obj obj = this.m_obj.findObj("DETECT_FOOTNOTES");
            return StructuredOutputOptions.sectionConversionSettingFromOption(obj);
        }
    }

    public static class WordOutputOptions {
        public static final int e_wof_docx = 0;
        public static final int e_wof_doc = 1;
        public static final int e_wof_rtf = 2;
        public static final int e_wof_txt = 3;
        public static final int e_ocr_image_text = 0;
        public static final int e_ocr_image = 1;
        public static final int e_ocr_text = 2;
        public static final int e_ocr_off = 3;
        public static final int e_ocr_always = 4;
        Obj m_obj;
        ObjSet m_objset;

        public WordOutputOptions() {
            try {
                this.m_objset = new ObjSet();
                this.m_obj = this.m_objset.createDict();
            }
            catch (PDFNetException pDFNetException) {
                System.err.println("Error Occurred when creating WordOutputOptions.");
            }
        }

        public void setWordOutputFormat(int n) throws PDFNetException {
            switch (n) {
                case 0: {
                    this.m_obj.putName("OUTPUT_FORMAT", "DOCX");
                    break;
                }
                case 1: {
                    this.m_obj.putName("OUTPUT_FORMAT", "DOC");
                    break;
                }
                case 2: {
                    this.m_obj.putName("OUTPUT_FORMAT", "RTF");
                    break;
                }
                case 3: {
                    this.m_obj.putName("OUTPUT_FORMAT", "TXT");
                }
            }
        }

        public void setPages(int n, int n2) throws PDFNetException {
            this.m_obj.putNumber("PAGE_FROM", n);
            this.m_obj.putNumber("PAGE_TO", n2);
        }

        public void setPDFPassword(String string) throws PDFNetException {
            this.m_obj.putText("PASSWORD", string);
        }

        public void setSearchableImageSetting(int n) throws PDFNetException {
            switch (n) {
                case 0: {
                    this.m_obj.putName("OCRED", "IMAGE+TEXT");
                    break;
                }
                case 1: {
                    this.m_obj.putName("OCRED", "IMAGE");
                    break;
                }
                case 2: {
                    this.m_obj.putName("OCRED", "TEXT");
                    break;
                }
                case 4: {
                    this.m_obj.putName("OCRED", "ALWAYS");
                    break;
                }
                case 3: {
                    this.m_obj.putName("OCRED", "OFF");
                }
            }
        }

        public void setTextRecoveryNSE(boolean bl) throws PDFNetException {
            this.m_obj.putBool("USE_OCR_NSE", bl);
        }

        public void setDetectTOC(boolean bl) throws PDFNetException {
            this.m_obj.putBool("DETECT_TOC", bl);
        }

        public void setConnectHyphens(boolean bl) throws PDFNetException {
            this.m_obj.putBool("CONNECT_HYPHENS", bl);
        }

        public void setLanguage(OutputOptionsOCR.LanguageChoice languageChoice) throws PDFNetException {
            this.m_obj.putText("LANGUAGE", OutputOptionsOCR.LanguageChoiceToString(languageChoice));
        }

        public void setPreferredOCREngine(OutputOptionsOCR.PreferredOCREngine preferredOCREngine) throws PDFNetException {
            this.m_obj.putText("PREFERREDOCR", OutputOptionsOCR.PreferredOCRChoiceToString(preferredOCREngine));
        }

        public void setCustomOCRLanguage(String string) throws PDFNetException {
            this.m_obj.putText("LANGUAGE", string);
        }

        public void setPrioritizeVisualAppearance(boolean bl) throws PDFNetException {
            this.m_obj.putBool("VISUAL_REPLICA", bl);
        }

        public void setHeadersAndFootersSetting(StructuredOutputOptions.SectionConversionSetting sectionConversionSetting) throws PDFNetException {
            this.m_obj.putNumber("DETECT_HEADERSANDFOOTERS", sectionConversionSetting.ordinal());
        }

        public StructuredOutputOptions.SectionConversionSetting getHeadersAndFootersSetting() throws PDFNetException {
            Obj obj = this.m_obj.findObj("DETECT_HEADERSANDFOOTERS");
            return StructuredOutputOptions.sectionConversionSettingFromOption(obj);
        }

        public void setFootnotesSetting(StructuredOutputOptions.SectionConversionSetting sectionConversionSetting) throws PDFNetException {
            this.m_obj.putNumber("DETECT_FOOTNOTES", sectionConversionSetting.ordinal());
        }

        public StructuredOutputOptions.SectionConversionSetting getFootnotesSetting() throws PDFNetException {
            Obj obj = this.m_obj.findObj("DETECT_FOOTNOTES");
            return StructuredOutputOptions.sectionConversionSettingFromOption(obj);
        }
    }

    public static class HTMLOutputOptions {
        public static final int e_fixed_position = 0;
        public static final int e_reflow_paragraphs = 1;
        public static final int e_reflow_full = 2;
        public static final int e_ocr_image_text = 0;
        public static final int e_ocr_image = 1;
        public static final int e_ocr_text = 2;
        public static final int e_ocr_off = 3;
        public static final int e_ocr_always = 4;
        Obj m_obj;
        ObjSet m_objset;

        public HTMLOutputOptions() {
            try {
                this.m_objset = new ObjSet();
                this.m_obj = this.m_objset.createDict();
            }
            catch (PDFNetException pDFNetException) {
                System.err.println("Error Occurred when creating HTMLOutputOptions.");
            }
        }

        public void setPreferJPG(boolean bl) throws PDFNetException {
            this.m_obj.putBool("PREFER_JPEG", bl);
        }

        public void setJPGQuality(int n) throws PDFNetException {
            this.m_obj.putNumber("JPEG_QUALITY", n);
        }

        public void setDPI(int n) throws PDFNetException {
            this.m_obj.putNumber("DPI", n);
        }

        public void setMaximumImagePixels(int n) throws PDFNetException {
            this.m_obj.putNumber("MAX_IMAGE_PIXELS", n);
        }

        public void setContentReflowSetting(int n) throws PDFNetException {
            switch (n) {
                case 0: {
                    this.m_obj.putName("REFLOW", "FIXED_POSITION");
                    break;
                }
                case 1: {
                    this.m_obj.putName("REFLOW", "REFLOW_PARAGRAPHS");
                    break;
                }
                case 2: {
                    this.m_obj.putName("REFLOW", "REFLOW_FULL");
                }
            }
        }

        public void setScale(double d) throws PDFNetException {
            this.m_obj.putNumber("SCALE", d);
        }

        public void setExternalLinks(boolean bl) throws PDFNetException {
            this.m_obj.putBool("EXTERNAL_LINKS", bl);
        }

        public void setInternalLinks(boolean bl) throws PDFNetException {
            this.m_obj.putBool("INTERNAL_LINKS", bl);
        }

        public void setSimplifyText(boolean bl) throws PDFNetException {
            this.m_obj.putBool("SIMPLIFY_TEXT", bl);
        }

        void SetReportFile(String string) throws PDFNetException {
            this.m_obj.putString("REPORT_FILE", string);
        }

        public void setTitle(String string) throws PDFNetException {
            this.m_obj.putText("TITLE", string);
        }

        public void setImageDPI(int n) throws PDFNetException {
            this.m_obj.putNumber("IMAGE_DPI", n);
        }

        public void setEmbedImages(boolean bl) throws PDFNetException {
            this.m_obj.putBool("EMBED_IMAGES", bl);
        }

        public void setFileConversionTimeoutSeconds(int n) throws PDFNetException {
            this.m_obj.putNumber("FILE_TIMEOUT", n);
        }

        public void setPages(int n, int n2) throws PDFNetException {
            this.m_obj.putNumber("PAGE_FROM", n);
            this.m_obj.putNumber("PAGE_TO", n2);
        }

        public void setPDFPassword(String string) throws PDFNetException {
            this.m_obj.putText("PASSWORD", string);
        }

        public void setSearchableImageSetting(int n) throws PDFNetException {
            switch (n) {
                case 0: {
                    this.m_obj.putName("OCRED", "IMAGE+TEXT");
                    break;
                }
                case 1: {
                    this.m_obj.putName("OCRED", "IMAGE");
                    break;
                }
                case 2: {
                    this.m_obj.putName("OCRED", "TEXT");
                    break;
                }
                case 4: {
                    this.m_obj.putName("OCRED", "ALWAYS");
                    break;
                }
                case 3: {
                    this.m_obj.putName("OCRED", "OFF");
                }
            }
        }

        public void setTextRecoveryNSE(boolean bl) throws PDFNetException {
            this.m_obj.putBool("USE_OCR_NSE", bl);
        }

        public void setSimpleLists(boolean bl) throws PDFNetException {
            this.m_obj.putBool("SIMPLE_LISTS", bl);
        }

        public void setConnectHyphens(boolean bl) throws PDFNetException {
            this.m_obj.putBool("CONNECT_HYPHENS", bl);
        }

        public void setDisableVerticalSplit(boolean bl) throws PDFNetException {
            this.m_obj.putBool("DISABLE_VERTICAL_SPLIT", bl);
        }

        public void setNoPageWidth(boolean bl) throws PDFNetException {
            this.m_obj.putBool("NO_PAGE_WIDTH", bl);
        }

        public void setLanguage(OutputOptionsOCR.LanguageChoice languageChoice) throws PDFNetException {
            this.m_obj.putText("LANGUAGE", OutputOptionsOCR.LanguageChoiceToString(languageChoice));
        }

        public void setPreferredOCREngine(OutputOptionsOCR.PreferredOCREngine preferredOCREngine) throws PDFNetException {
            this.m_obj.putText("PREFERREDOCR", OutputOptionsOCR.PreferredOCRChoiceToString(preferredOCREngine));
        }

        public void setHeadersAndFootersSetting(StructuredOutputOptions.SectionConversionSetting sectionConversionSetting) throws PDFNetException {
            this.m_obj.putNumber("DETECT_HEADERSANDFOOTERS", sectionConversionSetting.ordinal());
        }

        public StructuredOutputOptions.SectionConversionSetting getHeadersAndFootersSetting() throws PDFNetException {
            Obj obj = this.m_obj.findObj("DETECT_HEADERSANDFOOTERS");
            return StructuredOutputOptions.sectionConversionSettingFromOption(obj);
        }

        public void setFootnotesSetting(StructuredOutputOptions.SectionConversionSetting sectionConversionSetting) throws PDFNetException {
            this.m_obj.putNumber("DETECT_FOOTNOTES", sectionConversionSetting.ordinal());
        }

        public StructuredOutputOptions.SectionConversionSetting getFootnotesSetting() throws PDFNetException {
            Obj obj = this.m_obj.findObj("DETECT_FOOTNOTES");
            return StructuredOutputOptions.sectionConversionSettingFromOption(obj);
        }
    }

    public static class StructuredOutputOptions {
        static SectionConversionSetting sectionConversionSettingFromOption(Obj obj) throws PDFNetException {
            if (obj != null && !obj.isNull()) {
                int n = (int)obj.getNumber();
                switch (n) {
                    case 1: {
                        return SectionConversionSetting.e_DoNotDetect;
                    }
                    case 2: {
                        return SectionConversionSetting.e_DetectAndRemove;
                    }
                }
                return SectionConversionSetting.e_Recover;
            }
            return SectionConversionSetting.e_Recover;
        }

        public static enum SectionConversionSetting {
            e_Recover,
            e_DoNotDetect,
            e_DetectAndRemove;

        }
    }

    public static class OutputOptionsOCR {
        static String LanguageChoiceToString(LanguageChoice languageChoice) {
            String string = "au";
            switch (languageChoice) {
                case e_lang_catalan: {
                    string = "ca";
                    break;
                }
                case e_lang_danish: {
                    string = "da";
                    break;
                }
                case e_lang_german: {
                    string = "de";
                    break;
                }
                case e_lang_english: {
                    string = "en";
                    break;
                }
                case e_lang_spanish: {
                    string = "es";
                    break;
                }
                case e_lang_finnish: {
                    string = "fi";
                    break;
                }
                case e_lang_french: {
                    string = "fr";
                    break;
                }
                case e_lang_italian: {
                    string = "it";
                    break;
                }
                case e_lang_dutch: {
                    string = "nl";
                    break;
                }
                case e_lang_norwegian: {
                    string = "no";
                    break;
                }
                case e_lang_portuguese: {
                    string = "pt";
                    break;
                }
                case e_lang_polish: {
                    string = "pl";
                    break;
                }
                case e_lang_romanian: {
                    string = "ro";
                    break;
                }
                case e_lang_russian: {
                    string = "ru";
                    break;
                }
                case e_lang_slovenian: {
                    string = "sl";
                    break;
                }
                case e_lang_swedish: {
                    string = "sv";
                    break;
                }
                case e_lang_turkish: {
                    string = "tr";
                }
            }
            return string;
        }

        static String PreferredOCRChoiceToString(PreferredOCREngine preferredOCREngine) {
            String string = "DEFAULT";
            switch (preferredOCREngine) {
                case e_engine_tesseract: {
                    string = "TESS";
                }
            }
            return string;
        }

        public static enum PreferredOCREngine {
            e_engine_default(0),
            e_engine_tesseract(1);

            final int value;
            private static HashMap<Integer, PreferredOCREngine> engine_map;

            private PreferredOCREngine(int n2) {
                this.value = n2;
            }

            static PreferredOCREngine valueToEnum(int n) {
                return engine_map.get(n);
            }

            static {
                engine_map = new HashMap();
                for (PreferredOCREngine preferredOCREngine : PreferredOCREngine.values()) {
                    engine_map.put(preferredOCREngine.value, preferredOCREngine);
                }
            }
        }

        public static enum LanguageChoice {
            e_lang_auto(0),
            e_lang_catalan(1),
            e_lang_danish(2),
            e_lang_german(3),
            e_lang_english(4),
            e_lang_spanish(5),
            e_lang_finnish(6),
            e_lang_french(7),
            e_lang_italian(8),
            e_lang_dutch(9),
            e_lang_norwegian(10),
            e_lang_portuguese(11),
            e_lang_polish(12),
            e_lang_romanian(13),
            e_lang_russian(14),
            e_lang_slovenian(15),
            e_lang_swedish(16),
            e_lang_turkish(17);

            final int value;
            private static HashMap<Integer, LanguageChoice> language_map;

            private LanguageChoice(int n2) {
                this.value = n2;
            }

            static LanguageChoice valueToEnum(int n) {
                return language_map.get(n);
            }

            static {
                language_map = new HashMap();
                for (LanguageChoice languageChoice : LanguageChoice.values()) {
                    language_map.put(languageChoice.value, languageChoice);
                }
            }
        }
    }

    public static class XODOutputOptions
    extends XPSOutputCommonOptions {
        public static final int e_internal_xfdf = 0;
        public static final int e_external_xfdf = 1;
        public static final int e_flatten = 2;

        public void setExtractUsingZorder(boolean bl) throws PDFNetException {
            this.m_obj.putBool("USEZORDER", bl);
        }

        public void setOutputThumbnails(boolean bl) throws PDFNetException {
            this.m_obj.putBool("NOTHUMBS", !bl);
        }

        public void setThumbnailSize(int n) throws PDFNetException {
            this.setThumbnailSize(n, n);
        }

        public void setThumbnailSize(int n, int n2) throws PDFNetException {
            this.m_obj.putNumber("THUMB_SIZE", n);
            this.m_obj.putNumber("LARGE_THUMB_SIZE", n2);
        }

        public void setElementLimit(int n) throws PDFNetException {
            this.m_obj.putNumber("ELEMENTLIMIT", n);
        }

        public void setOpacityMaskWorkaround(boolean bl) throws PDFNetException {
            this.m_obj.putBool("MASKRENDER", bl);
        }

        public void setMaximumImagePixels(int n) throws PDFNetException {
            this.m_obj.putNumber("MAX_IMAGE_PIXELS", n);
        }

        public void setFlattenThreshold(int n) throws PDFNetException {
            Convert.setFlattenThresholdImpl(this.m_obj, n);
        }

        public void setFlattenContent(int n) throws PDFNetException {
            Convert.setFlattenContentImpl(this.m_obj, n);
        }

        public void setPreferJPG(boolean bl) throws PDFNetException {
            this.m_obj.putBool("PREFER_JPEG", bl);
        }

        public void setJPGQuality(int n) throws PDFNetException {
            this.m_obj.putNumber("JPEG_QUALITY", n);
        }

        public void setSilverlightTextWorkaround(boolean bl) throws PDFNetException {
            this.m_obj.putBool("REMOVE_ROTATED_TEXT", bl);
        }

        public void setAnnotationOutput(int n) throws PDFNetException {
            switch (n) {
                case 0: {
                    this.m_obj.putName("ANNOTATION_OUTPUT", "INTERNAL");
                    break;
                }
                case 1: {
                    this.m_obj.putName("ANNOTATION_OUTPUT", "EXTERNAL");
                    break;
                }
                case 2: {
                    this.m_obj.putName("ANNOTATION_OUTPUT", "FLATTEN");
                }
            }
        }

        public void setExternalParts(boolean bl) throws PDFNetException {
            this.m_obj.putBool("EXTERNAL_PARTS", bl);
        }

        public void setEncryptPassword(String string) throws PDFNetException {
            this.m_obj.putName("ENCRYPT_PASSWORD", string);
        }

        public void UseSilverlightFlashCompatible(boolean bl) throws PDFNetException {
            this.m_obj.putBool("COMPATIBLE_XOD", bl);
        }
    }

    public static class XPSOutputOptions
    extends XPSOutputCommonOptions {
        public void setOpenXps(boolean bl) throws PDFNetException {
            this.m_obj.putBool("OPENXPS", bl);
        }
    }

    public static class XPSOutputCommonOptions {
        public static final int e_op_off = 0;
        public static final int e_op_on = 1;
        public static final int e_op_pdfx_on = 2;
        Obj m_obj;
        ObjSet m_objset;

        public XPSOutputCommonOptions() {
            try {
                this.m_objset = new ObjSet();
                this.m_obj = this.m_objset.createDict();
            }
            catch (PDFNetException pDFNetException) {
                System.err.println("Error Occurred when creating XPSOutputCommonOptions.");
            }
        }

        public void setPrintMode(boolean bl) throws PDFNetException {
            this.m_obj.putBool("PRINTMODE", bl);
        }

        public void setDPI(int n) throws PDFNetException {
            this.m_obj.putNumber("DPI", n);
        }

        public void setRenderPages(boolean bl) throws PDFNetException {
            this.m_obj.putBool("RENDER", bl);
        }

        public void setThickenLines(boolean bl) throws PDFNetException {
            this.m_obj.putBool("THICKENLINES", bl);
        }

        public void generateURLLinks(boolean bl) throws PDFNetException {
            this.m_obj.putBool("URL_LINKS", bl);
        }

        public void setOverprint(int n) throws PDFNetException {
            switch (n) {
                case 0: {
                    this.m_obj.putName("OVERPRINT_MODE", "OFF");
                    break;
                }
                case 1: {
                    this.m_obj.putName("OVERPRINT_MODE", "ON");
                    break;
                }
                case 2: {
                    this.m_obj.putName("OVERPRINT_MODE", "PDFX");
                }
            }
        }
    }
}

