/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.Matrix2D;
import com.pdftron.common.PDFNetException;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.Annot;
import com.pdftron.pdf.Field;
import com.pdftron.pdf.Rect;
import com.pdftron.pdf.TaggingOptions;
import com.pdftron.sdf.Obj;

public class Page {
    public static final int e_action_trigger_page_open = 11;
    public static final int e_action_trigger_page_close = 12;
    public static final int e_media = 0;
    public static final int e_crop = 1;
    public static final int e_bleed = 2;
    public static final int e_trim = 3;
    public static final int e_art = 4;
    public static final int e_user_crop = 5;
    public static final int e_0 = 0;
    public static final int e_90 = 1;
    public static final int e_180 = 2;
    public static final int e_270 = 3;
    long impl;
    Object ref;

    public Page() {
        this.impl = 0L;
    }

    public Page(Obj obj) {
        this.impl = obj.__GetHandle();
        this.ref = obj.__GetRefHandle();
    }

    public boolean isValid() throws PDFNetException {
        return Page.IsValid(this.impl);
    }

    public int getIndex() throws PDFNetException {
        return Page.GetIndex(this.impl);
    }

    public Obj getTriggerAction(int n) throws PDFNetException {
        return Obj.__Create(Page.GetTriggerAction(this.impl, n), this.ref);
    }

    public Rect getBox(int n) throws PDFNetException {
        return new Rect(Page.GetBox(this.impl, n));
    }

    public void setBox(int n, Rect rect) throws PDFNetException {
        Page.SetBox(this.impl, n, rect.impl);
        ReachabilityHelper.ensureReachable(rect);
    }

    public Rect getCropBox() throws PDFNetException {
        return new Rect(Page.GetCropBox(this.impl));
    }

    public void setCropBox(Rect rect) throws PDFNetException {
        Page.SetCropBox(this.impl, rect.impl);
        ReachabilityHelper.ensureReachable(rect);
    }

    public Rect getMediaBox() throws PDFNetException {
        return new Rect(Page.GetMediaBox(this.impl));
    }

    public void setMediaBox(Rect rect) throws PDFNetException {
        Page.SetMediaBox(this.impl, rect.impl);
        ReachabilityHelper.ensureReachable(rect);
    }

    public Rect getVisibleContentBox() throws PDFNetException {
        return new Rect(Page.GetVisibleContentBox(this.impl));
    }

    public static int addRotations(int n, int n2) throws PDFNetException {
        return Page.AddRotations(n, n2);
    }

    public static int subtractRotations(int n, int n2) throws PDFNetException {
        return Page.SubtractRotations(n, n2);
    }

    public static int rotationToDegree(int n) throws PDFNetException {
        return Page.RotationToDegree(n);
    }

    public static int degreeToRotation(int n) throws PDFNetException {
        return Page.DegreeToRotation(n);
    }

    public int getRotation() throws PDFNetException {
        return Page.GetRotation(this.impl);
    }

    public void setRotation(int n) throws PDFNetException {
        Page.SetRotation(this.impl, n);
    }

    public double getPageWidth() throws PDFNetException {
        return Page.GetPageWidth(this.impl, 1);
    }

    public double getPageWidth(int n) throws PDFNetException {
        return Page.GetPageWidth(this.impl, n);
    }

    public double getPageHeight() throws PDFNetException {
        return Page.GetPageHeight(this.impl, 1);
    }

    public double getPageHeight(int n) throws PDFNetException {
        return Page.GetPageHeight(this.impl, n);
    }

    public Matrix2D getDefaultMatrix() throws PDFNetException {
        return Matrix2D.__Create(Page.GetDefaultMatrix(this.impl, false, 1, 0));
    }

    public Matrix2D getDefaultMatrix(boolean bl, int n, int n2) throws PDFNetException {
        return Matrix2D.__Create(Page.GetDefaultMatrix(this.impl, bl, n, n2));
    }

    public Obj getAnnots() throws PDFNetException {
        return Obj.__Create(Page.GetAnnots(this.impl), this.ref);
    }

    public int getNumAnnots() throws PDFNetException {
        return Page.GetNumAnnots(this.impl);
    }

    public Annot getAnnot(int n) throws PDFNetException {
        return new Annot(Page.GetAnnot(this.impl, n), this.ref);
    }

    public void annotInsert(int n, Annot annot) throws PDFNetException {
        Page.AnnotInsert(this.impl, n, annot.impl);
        ReachabilityHelper.ensureReachable(annot);
    }

    public void annotInsertWithTagging(int n, Annot annot, Obj obj, TaggingOptions taggingOptions) throws PDFNetException {
        Page.AnnotInsertWithTagging(this.impl, n, annot.impl, obj.__GetHandle(), taggingOptions.getObjHandle());
    }

    public void annotPushBack(Annot annot) throws PDFNetException {
        Page.AnnotPushBack(this.impl, annot.impl);
        ReachabilityHelper.ensureReachable(annot);
    }

    public void annotPushFront(Annot annot) throws PDFNetException {
        Page.AnnotPushFront(this.impl, annot.impl);
        ReachabilityHelper.ensureReachable(annot);
    }

    public void annotRemove(Annot annot) throws PDFNetException {
        Page.AnnotRemove(this.impl, annot.impl);
        ReachabilityHelper.ensureReachable(annot);
    }

    public void annotRemove(int n) throws PDFNetException {
        Page.AnnotRemove(this.impl, n);
    }

    public void scale(double d) throws PDFNetException {
        Page.Scale(this.impl, d);
    }

    public void flattenField(Field field) throws PDFNetException {
        Page.FlattenField(this.impl, field.impl);
        ReachabilityHelper.ensureReachable(field);
    }

    public boolean hasTransition() throws PDFNetException {
        return Page.HasTransition(this.impl);
    }

    public double getUserUnitSize() throws PDFNetException {
        return Page.GetUserUnitSize(this.impl);
    }

    public void setUserUnitSize(double d) throws PDFNetException {
        Page.SetUserUnitSize(this.impl, d);
    }

    public Obj getResourceDict() throws PDFNetException {
        return Obj.__Create(Page.GetResourceDict(this.impl), this.ref);
    }

    public Obj getContents() throws PDFNetException {
        return Obj.__Create(Page.GetContents(this.impl), this.ref);
    }

    public Obj getSDFObj() {
        return Obj.__Create(this.impl, this.ref);
    }

    public Obj findInheritedAttribute(String string) throws PDFNetException {
        return Obj.__Create(this.impl, string);
    }

    public Obj getThumb() throws PDFNetException {
        return Obj.__Create(Page.GetThumb(this.impl), this.ref);
    }

    public int[] getThumbInfo() throws PDFNetException {
        return Page.GetThumbInfo(this.impl);
    }

    public static Page __Create(long l, Object object) {
        return new Page(l, object);
    }

    Page(long l, Object object) {
        this.impl = l;
        this.ref = object;
    }

    public long __GetHandle() {
        return this.impl;
    }

    static native long GetTriggerAction(long var0, int var2);

    static native boolean IsValid(long var0);

    static native int GetIndex(long var0);

    static native long GetBox(long var0, int var2);

    static native void SetBox(long var0, int var2, long var3);

    static native long GetCropBox(long var0);

    static native void SetCropBox(long var0, long var2);

    static native long GetMediaBox(long var0);

    static native void SetMediaBox(long var0, long var2);

    static native long GetVisibleContentBox(long var0);

    static native int AddRotations(int var0, int var1);

    static native int SubtractRotations(int var0, int var1);

    static native int RotationToDegree(int var0);

    static native int DegreeToRotation(int var0);

    static native int GetRotation(long var0);

    static native void SetRotation(long var0, int var2);

    static native double GetPageWidth(long var0, int var2);

    static native double GetPageHeight(long var0, int var2);

    static native long GetDefaultMatrix(long var0, boolean var2, int var3, int var4);

    static native long GetAnnots(long var0);

    static native int GetNumAnnots(long var0);

    static native long GetAnnot(long var0, int var2);

    static native void AnnotInsert(long var0, int var2, long var3);

    static native void AnnotInsertWithTagging(long var0, int var2, long var3, long var5, long var7);

    static native void AnnotPushBack(long var0, long var2);

    static native void AnnotPushFront(long var0, long var2);

    static native void AnnotRemove(long var0, long var2);

    static native void AnnotRemove(long var0, int var2);

    static native void Scale(long var0, double var2);

    static native void FlattenField(long var0, long var2);

    static native boolean HasTransition(long var0);

    static native double GetUserUnitSize(long var0);

    static native void SetUserUnitSize(long var0, double var2);

    static native long GetResourceDict(long var0);

    static native long GetContents(long var0);

    static native long FindInheritedAttribute(long var0, String var2);

    static native int[] GetThumbInfo(long var0);

    static native long GetThumb(long var0);
}

