/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.pdf.OptionsBase;
import com.pdftron.sdf.Obj;

public class PrintToPdfOptions
extends OptionsBase {
    public PrintToPdfOptions() throws PDFNetException {
    }

    public PrintToPdfOptions(String string) throws PDFNetException {
        super(string);
    }

    @Override
    long getObjHandle() throws PDFNetException {
        return this.mDict.__GetHandle();
    }

    public double getHorizontalPageMargin() throws PDFNetException {
        Obj obj = this.mDict.findObj("horizontal-page-margin");
        if (obj != null && !obj.isNull()) {
            return obj.getNumber();
        }
        return 18.0;
    }

    public PrintToPdfOptions setHorizontalPageMargin(double d) throws PDFNetException {
        this.putNumber("horizontal-page-margin", d);
        return this;
    }

    public double getPageHeight() throws PDFNetException {
        Obj obj = this.mDict.findObj("page-height");
        if (obj != null && !obj.isNull()) {
            return obj.getNumber();
        }
        return 0.0;
    }

    public PrintToPdfOptions setPageHeight(double d) throws PDFNetException {
        this.putNumber("page-height", d);
        return this;
    }

    public String getPageOrientation() throws PDFNetException {
        Obj obj = this.mDict.findObj("page-orientation");
        if (obj != null && !obj.isNull()) {
            return obj.getAsPDFText();
        }
        return "";
    }

    public PrintToPdfOptions setPageOrientation(String string) throws PDFNetException {
        this.putText("page-orientation", string);
        return this;
    }

    public double getPageWidth() throws PDFNetException {
        Obj obj = this.mDict.findObj("page-width");
        if (obj != null && !obj.isNull()) {
            return obj.getNumber();
        }
        return 0.0;
    }

    public PrintToPdfOptions setPageWidth(double d) throws PDFNetException {
        this.putNumber("page-width", d);
        return this;
    }

    public double getVerticalPageMargin() throws PDFNetException {
        Obj obj = this.mDict.findObj("vertical-page-margin");
        if (obj != null && !obj.isNull()) {
            return obj.getNumber();
        }
        return 18.0;
    }

    public PrintToPdfOptions setVerticalPageMargin(double d) throws PDFNetException {
        this.putNumber("vertical-page-margin", d);
        return this;
    }
}

