/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.pdf.OptionsBase;
import com.pdftron.sdf.Obj;

public class TransPDFOptions
extends OptionsBase {
    public TransPDFOptions() throws PDFNetException {
    }

    public TransPDFOptions(String string) throws PDFNetException {
        super(string);
    }

    @Override
    long getObjHandle() throws PDFNetException {
        return this.mDict.__GetHandle();
    }

    public int getBatchSize() throws PDFNetException {
        Obj obj = this.mDict.findObj("BatchSize");
        if (obj != null && !obj.isNull()) {
            return (int)obj.getNumber();
        }
        return 20;
    }

    public TransPDFOptions setBatchSize(int n) throws PDFNetException {
        this.putNumber("BatchSize", n);
        return this;
    }

    public String getPages() throws PDFNetException {
        Obj obj = this.mDict.findObj("Pages");
        if (obj != null && !obj.isNull()) {
            return obj.getAsPDFText();
        }
        return "";
    }

    public TransPDFOptions setPages(String string) throws PDFNetException {
        this.putText("Pages", string);
        return this;
    }

    public boolean getResizeSingleLine() throws PDFNetException {
        Obj obj = this.mDict.findObj("ResizeSingleLine");
        if (obj != null && !obj.isNull()) {
            return obj.getBool();
        }
        return false;
    }

    public TransPDFOptions setResizeSingleLine(boolean bl) throws PDFNetException {
        this.putBool("ResizeSingleLine", bl);
        return this;
    }

    public String getSourceLanguage() throws PDFNetException {
        Obj obj = this.mDict.findObj("SourceLanguage");
        if (obj != null && !obj.isNull()) {
            return obj.getAsPDFText();
        }
        return "en";
    }

    public TransPDFOptions setSourceLanguage(String string) throws PDFNetException {
        this.putText("SourceLanguage", string);
        return this;
    }
}

