/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.pdf.struct;

import com.pdftron.common.PDFNetException;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.pdf.struct.ContentItem;
import com.pdftron.pdf.struct.STree;
import com.pdftron.sdf.Obj;

public class SElement
implements AutoCloseable {
    long impl;
    Object ref;

    public SElement() throws PDFNetException {
        this.impl = SElement.SElementCreate(0L);
    }

    public SElement(Obj obj) throws PDFNetException {
        this.impl = SElement.SElementCreate(obj.__GetHandle());
        ReachabilityHelper.ensureReachable(obj);
    }

    public boolean isValid() throws PDFNetException {
        return SElement.IsValid(this.impl);
    }

    public String getType() throws PDFNetException {
        return SElement.GetType(this.impl);
    }

    public int getNumKids() throws PDFNetException {
        return SElement.GetNumKids(this.impl);
    }

    public boolean isContentItem(int n) throws PDFNetException {
        return SElement.IsContentItem(this.impl, n);
    }

    public ContentItem getAsContentItem(int n) throws PDFNetException {
        return new ContentItem(SElement.GetAsContentItem(this.impl, n), this.ref);
    }

    public SElement getAsStructElem(int n) throws PDFNetException {
        return new SElement(SElement.GetAsStructElem(this.impl, n), this.ref);
    }

    public SElement getParent() throws PDFNetException {
        return new SElement(SElement.GetParent(this.impl), this.ref);
    }

    public STree getStructTreeRoot() throws PDFNetException {
        return new STree(SElement.GetStructTreeRoot(this.impl), this.ref);
    }

    public boolean hasTitle() throws PDFNetException {
        return SElement.HasTitle(this.impl);
    }

    public String getTitle() throws PDFNetException {
        return SElement.GetTitle(this.impl);
    }

    public Obj getID() throws PDFNetException {
        return Obj.__Create(SElement.GetID(this.impl), this.ref);
    }

    public boolean hasActualText() throws PDFNetException {
        return SElement.HasActualText(this.impl);
    }

    public String getActualText() throws PDFNetException {
        return SElement.GetActualText(this.impl);
    }

    public boolean hasAlt() throws PDFNetException {
        return SElement.HasAlt(this.impl);
    }

    public String getAlt() throws PDFNetException {
        return SElement.GetAlt(this.impl);
    }

    public Obj getSDFObj() throws PDFNetException {
        return Obj.__Create(SElement.GetSDFObj(this.impl), this.ref);
    }

    public void destroy() throws PDFNetException {
        if (this.impl != 0L) {
            SElement.Destroy(this.impl);
            this.impl = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    public static SElement __Create(long l, Object object) {
        return new SElement(l, object);
    }

    SElement(long l, Object object) {
        this.impl = l;
        this.ref = object;
    }

    @Override
    public void close() throws PDFNetException {
        this.destroy();
    }

    static native void Destroy(long var0);

    static native long SElementCreate(long var0);

    static native boolean IsValid(long var0);

    static native String GetType(long var0);

    static native int GetNumKids(long var0);

    static native boolean IsContentItem(long var0, int var2);

    static native long GetAsContentItem(long var0, int var2);

    static native long GetAsStructElem(long var0, int var2);

    static native long GetParent(long var0);

    static native long GetStructTreeRoot(long var0);

    static native boolean HasTitle(long var0);

    static native String GetTitle(long var0);

    static native long GetID(long var0);

    static native boolean HasActualText(long var0);

    static native String GetActualText(long var0);

    static native boolean HasAlt(long var0);

    static native String GetAlt(long var0);

    static native long GetSDFObj(long var0);
}

