/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.sdf;

import com.pdftron.common.PDFNetException;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.sdf.DictIterator;
import com.pdftron.sdf.Doc;
import com.pdftron.sdf.NameTreeIterator;
import com.pdftron.sdf.Obj;

public class NameTree {
    long impl;
    Object ref;

    public static NameTree create(Doc doc, String string) throws PDFNetException {
        NameTree nameTree = new NameTree(NameTree.Create(doc.impl, string), doc);
        ReachabilityHelper.ensureReachable(doc);
        return nameTree;
    }

    public static NameTree find(Doc doc, String string) throws PDFNetException {
        NameTree nameTree = new NameTree(NameTree.Find(doc.impl, string), doc);
        ReachabilityHelper.ensureReachable(doc);
        return nameTree;
    }

    public NameTree(Obj obj) {
        this.impl = obj.impl;
        this.ref = obj.ref;
    }

    public boolean isValid() throws PDFNetException {
        return NameTree.IsValid(this.impl);
    }

    public NameTreeIterator getIterator(byte[] byArray) throws PDFNetException {
        return new NameTreeIterator(NameTree.GetIterator(this.impl, byArray), this.ref);
    }

    public Obj getValue(byte[] byArray) throws PDFNetException {
        return Obj.__Create(NameTree.GetValue(this.impl, byArray), this.ref);
    }

    public NameTreeIterator getIterator() throws PDFNetException {
        return new NameTreeIterator(NameTree.GetIterator(this.impl), this.ref);
    }

    public void put(byte[] byArray, Obj obj) throws PDFNetException {
        NameTree.Put(this.impl, byArray, obj.impl);
        ReachabilityHelper.ensureReachable(obj);
    }

    public void erase(byte[] byArray) throws PDFNetException {
        NameTree.Erase(this.impl, byArray);
    }

    public void erase(DictIterator dictIterator) throws PDFNetException {
        NameTree.Erase(this.impl, dictIterator.impl);
        ReachabilityHelper.ensureReachable(dictIterator);
    }

    public Obj getSDFObj() {
        return Obj.__Create(this.impl, this.ref);
    }

    NameTree(long l, Object object) {
        this.impl = l;
        this.ref = object;
    }

    static native long Create(long var0, String var2);

    static native long Find(long var0, String var2);

    static native boolean IsValid(long var0);

    static native long GetIterator(long var0, byte[] var2);

    static native long GetValue(long var0, byte[] var2);

    static native long GetIterator(long var0);

    static native void Put(long var0, byte[] var2, long var3);

    static native void Erase(long var0, byte[] var2);

    static native void Erase(long var0, long var2);
}

