/*
 * Decompiled with CFR 0.152.
 */
package com.pdftron.sdf;

import com.pdftron.common.Matrix2D;
import com.pdftron.common.PDFNetException;
import com.pdftron.filters.Filter;
import com.pdftron.filters.FilterWriter;
import com.pdftron.helpers.ReachabilityHelper;
import com.pdftron.sdf.DictIterator;
import com.pdftron.sdf.SDFDoc;
import java.awt.geom.Rectangle2D;

public class Obj {
    public static final int e_null = 0;
    public static final int e_bool = 1;
    public static final int e_number = 2;
    public static final int e_name = 3;
    public static final int e_string = 4;
    public static final int e_dict = 5;
    public static final int e_array = 6;
    public static final int e_stream = 7;
    long impl;
    Object ref;

    public int getType() throws PDFNetException {
        return Obj.GetType(this.impl);
    }

    public boolean isBool() throws PDFNetException {
        return Obj.IsBool(this.impl);
    }

    public boolean isNumber() throws PDFNetException {
        return Obj.IsNumber(this.impl);
    }

    public boolean isNull() throws PDFNetException {
        return Obj.IsNull(this.impl);
    }

    public boolean isString() throws PDFNetException {
        return Obj.IsString(this.impl);
    }

    public boolean isName() throws PDFNetException {
        return Obj.IsName(this.impl);
    }

    public boolean isIndirect() throws PDFNetException {
        return Obj.IsIndirect(this.impl);
    }

    public boolean isContainer() throws PDFNetException {
        return Obj.IsContainer(this.impl);
    }

    public boolean isDict() throws PDFNetException {
        return Obj.IsDict(this.impl);
    }

    public boolean isArray() throws PDFNetException {
        return Obj.IsArray(this.impl);
    }

    public boolean isStream() throws PDFNetException {
        return Obj.IsStream(this.impl);
    }

    public SDFDoc getDoc() throws PDFNetException {
        return new SDFDoc(Obj.GetDoc(this.impl), this.ref);
    }

    public void write(FilterWriter filterWriter) throws PDFNetException {
        Obj.Write(this.impl, filterWriter.__GetHandle());
        ReachabilityHelper.ensureReachable(filterWriter);
    }

    public long size() throws PDFNetException {
        return Obj.Size(this.impl);
    }

    public long getObjNum() throws PDFNetException {
        return Obj.GetObjNum(this.impl);
    }

    public short getGenNum() throws PDFNetException {
        return Obj.GetGenNum(this.impl);
    }

    public long getOffset() throws PDFNetException {
        return Obj.GetOffset(this.impl);
    }

    public boolean isFree() throws PDFNetException {
        return Obj.IsFree(this.impl);
    }

    public void setMark(boolean bl) throws PDFNetException {
        Obj.SetMark(this.impl, bl);
    }

    public boolean isMarked() throws PDFNetException {
        return Obj.IsMarked(this.impl);
    }

    public boolean isLoaded() throws PDFNetException {
        return Obj.IsLoaded(this.impl);
    }

    public boolean isEqual(Obj obj) throws PDFNetException {
        boolean bl = Obj.IsEqual(this.impl, obj.impl);
        ReachabilityHelper.ensureReachable(obj);
        return bl;
    }

    public boolean getBool() throws PDFNetException {
        return Obj.GetBool(this.impl);
    }

    public void setBool(boolean bl) throws PDFNetException {
        Obj.SetBool(this.impl, bl);
    }

    public double getNumber() throws PDFNetException {
        return Obj.GetNumber(this.impl);
    }

    public void setNumber(double d) throws PDFNetException {
        Obj.SetNumber(this.impl, d);
    }

    public byte[] getBuffer() throws PDFNetException {
        return Obj.GetBuffer(this.impl);
    }

    public byte[] getRawBuffer() throws PDFNetException {
        return Obj.GetRawBuffer(this.impl);
    }

    public String getAsPDFText() throws PDFNetException {
        return Obj.GetAsPDFText(this.impl);
    }

    public void setString(byte[] byArray) throws PDFNetException {
        Obj.SetString(this.impl, byArray);
    }

    public void setString(String string) throws PDFNetException {
        Obj.SetString(this.impl, string);
    }

    public String getName() throws PDFNetException {
        return Obj.GetName(this.impl);
    }

    public void setName(String string) throws PDFNetException {
        Obj.SetName(this.impl, string);
    }

    public DictIterator getDictIterator() throws PDFNetException {
        return new DictIterator(Obj.GetDictIterator(this.impl), this.ref);
    }

    public DictIterator find(String string) throws PDFNetException {
        return new DictIterator(Obj.Find(this.impl, string), this.ref);
    }

    public Obj findObj(String string) throws PDFNetException {
        return Obj.__Create(Obj.FindObj(this.impl, string), this.ref);
    }

    public DictIterator get(String string) throws PDFNetException {
        return new DictIterator(Obj.Get(this.impl, string), this.ref);
    }

    public Obj putName(String string, String string2) throws PDFNetException {
        return Obj.__Create(Obj.PutName(this.impl, string, string2), this.ref);
    }

    public Obj putArray(String string) throws PDFNetException {
        return Obj.__Create(Obj.PutArray(this.impl, string), this.ref);
    }

    public Obj putBool(String string, boolean bl) throws PDFNetException {
        return Obj.__Create(Obj.PutBool(this.impl, string, bl), this.ref);
    }

    public Obj putDict(String string) throws PDFNetException {
        return Obj.__Create(Obj.PutDict(this.impl, string), this.ref);
    }

    public Obj putNumber(String string, double d) throws PDFNetException {
        return Obj.__Create(Obj.PutNumber(this.impl, string, d), this.ref);
    }

    public Obj putString(String string, String string2) throws PDFNetException {
        return Obj.__Create(Obj.PutString(this.impl, string, string2), this.ref);
    }

    public Obj putString(String string, byte[] byArray) throws PDFNetException {
        return Obj.__Create(Obj.PutString(this.impl, string, byArray), this.ref);
    }

    public Obj putText(String string, String string2) throws PDFNetException {
        return Obj.__Create(Obj.PutText(this.impl, string, string2), this.ref);
    }

    public void putNull(String string) throws PDFNetException {
        Obj.PutNull(this.impl, string);
    }

    public Obj put(String string, Obj obj) throws PDFNetException {
        return Obj.__Create(Obj.Put(this.impl, string, obj.impl), this.ref);
    }

    public Obj putRect(String string, double d, double d2, double d3, double d4) throws PDFNetException {
        return Obj.__Create(Obj.PutRect(this.impl, string, d, d2, d3, d4), this.ref);
    }

    public Obj putRect(String string, Rectangle2D.Double double_) throws PDFNetException {
        return Obj.__Create(Obj.PutRect(this.impl, string, double_.x, double_.y, double_.x + double_.width, double_.y + double_.height), this.ref);
    }

    public Obj putMatrix(String string, Matrix2D matrix2D) throws PDFNetException {
        return Obj.__Create(Obj.PutMatrix(this.impl, string, matrix2D.__GetHandle()), this.ref);
    }

    public void erase(String string) throws PDFNetException {
        Obj.Erase(this.impl, string);
    }

    public void erase(DictIterator dictIterator) throws PDFNetException {
        Obj.Erase(this.impl, dictIterator.__GetHandle());
        ReachabilityHelper.ensureReachable(dictIterator);
    }

    public boolean rename(String string, String string2) throws PDFNetException {
        return Obj.Rename(this.impl, string, string2);
    }

    public Obj getAt(int n) throws PDFNetException {
        return Obj.__Create(Obj.GetAt(this.impl, n), this.ref);
    }

    public Obj insertName(int n, String string) throws PDFNetException {
        return Obj.__Create(Obj.InsertName(this.impl, n, string), this.ref);
    }

    public Obj insertArray(int n) throws PDFNetException {
        return Obj.__Create(Obj.InsertArray(this.impl, n), this.ref);
    }

    public Obj insertBool(int n, boolean bl) throws PDFNetException {
        return Obj.__Create(Obj.InsertBool(this.impl, n, bl), this.ref);
    }

    public Obj insertDict(int n) throws PDFNetException {
        return Obj.__Create(Obj.InsertDict(this.impl, n), this.ref);
    }

    public Obj insertNumber(int n, double d) throws PDFNetException {
        return Obj.__Create(Obj.InsertNumber(this.impl, n, d), this.ref);
    }

    public Obj insertString(int n, String string) throws PDFNetException {
        return Obj.__Create(Obj.InsertString(this.impl, n, string), this.ref);
    }

    public Obj insertString(int n, byte[] byArray) throws PDFNetException {
        return Obj.__Create(Obj.InsertString(this.impl, n, byArray), this.ref);
    }

    public Obj insertText(int n, String string) throws PDFNetException {
        return Obj.__Create(Obj.InsertText(this.impl, n, string), this.ref);
    }

    public Obj insertNull(int n) throws PDFNetException {
        return Obj.__Create(Obj.InsertNull(this.impl, n), this.ref);
    }

    public Obj insert(int n, Obj obj) throws PDFNetException {
        return Obj.__Create(Obj.Insert(this.impl, n, obj.impl), this.ref);
    }

    public Obj insertRect(int n, double d, double d2, double d3, double d4) throws PDFNetException {
        return Obj.__Create(Obj.InsertRect(this.impl, n, d, d2, d3, d4), this.ref);
    }

    public Obj insertRect(int n, Rectangle2D.Double double_) throws PDFNetException {
        return Obj.__Create(Obj.InsertRect(this.impl, n, double_.x, double_.y, double_.x + double_.width, double_.y + double_.height), this.ref);
    }

    public Obj insertMatrix(int n, Matrix2D matrix2D) throws PDFNetException {
        return Obj.__Create(Obj.InsertMatrix(this.impl, n, matrix2D.__GetHandle()), this.ref);
    }

    public Obj pushBackName(String string) throws PDFNetException {
        return Obj.__Create(Obj.PushBackName(this.impl, string), this.ref);
    }

    public Obj pushBackArray() throws PDFNetException {
        return Obj.__Create(Obj.PushBackArray(this.impl), this.ref);
    }

    public Obj pushBackBool(boolean bl) throws PDFNetException {
        return Obj.__Create(Obj.PushBackBool(this.impl, bl), this.ref);
    }

    public Obj pushBackDict() throws PDFNetException {
        return Obj.__Create(Obj.PushBackDict(this.impl), this.ref);
    }

    public Obj pushBackNumber(double d) throws PDFNetException {
        return Obj.__Create(Obj.PushBackNumber(this.impl, d), this.ref);
    }

    public Obj pushBackString(String string) throws PDFNetException {
        return Obj.__Create(Obj.PushBackString(this.impl, string), this.ref);
    }

    public Obj pushBackString(byte[] byArray) throws PDFNetException {
        return Obj.__Create(Obj.PushBackString(this.impl, byArray), this.ref);
    }

    public Obj pushBackText(String string) throws PDFNetException {
        return Obj.__Create(Obj.PushBackText(this.impl, string), this.ref);
    }

    public Obj pushBackNull() throws PDFNetException {
        return Obj.__Create(Obj.PushBackNull(this.impl), this.ref);
    }

    public Obj pushBack(Obj obj) throws PDFNetException {
        return Obj.__Create(Obj.PushBack(this.impl, obj.impl), this.ref);
    }

    public Obj pushBackRect(double d, double d2, double d3, double d4) throws PDFNetException {
        return Obj.__Create(Obj.PushBackRect(this.impl, d, d2, d3, d4), this.ref);
    }

    public Obj pushBackRect(Rectangle2D.Double double_) throws PDFNetException {
        return Obj.__Create(Obj.PushBackRect(this.impl, double_.x, double_.y, double_.x + double_.width, double_.y + double_.height), this.ref);
    }

    public Obj pushBackMatrix(Matrix2D matrix2D) throws PDFNetException {
        return Obj.__Create(Obj.PushBackMatrix(this.impl, matrix2D.__GetHandle()), this.ref);
    }

    public void eraseAt(int n) throws PDFNetException {
        Obj.EraseAt(this.impl, n);
    }

    public long getRawStreamLength() throws PDFNetException {
        return Obj.GetRawStreamLength(this.impl);
    }

    public Filter getRawStream(boolean bl) throws PDFNetException {
        return Filter.__Create(Obj.GetRawStream(this.impl, bl), null);
    }

    public Filter getDecodedStream() throws PDFNetException {
        return Filter.__Create(Obj.GetDecodedStream(this.impl), null);
    }

    public void setStreamData(byte[] byArray, Filter filter) throws PDFNetException {
        if (filter != null) {
            filter.__SetRefHandle(this);
        }
        Obj.SetStreamData(this.impl, byArray, filter.__GetHandle());
        ReachabilityHelper.ensureReachable(filter);
    }

    private Obj(long l, Object object) {
        this.impl = l;
        this.ref = object;
    }

    public static Obj __Create(long l, Object object) {
        if (l == 0L) {
            return null;
        }
        return new Obj(l, object);
    }

    public long __GetHandle() {
        return this.impl;
    }

    public Object __GetRefHandle() {
        return this.ref;
    }

    static native int GetType(long var0);

    static native long GetDoc(long var0);

    static native void Write(long var0, long var2);

    static native boolean IsEqual(long var0, long var2);

    static native boolean IsBool(long var0);

    static native boolean GetBool(long var0);

    static native void SetBool(long var0, boolean var2);

    static native boolean IsNumber(long var0);

    static native double GetNumber(long var0);

    static native void SetNumber(long var0, double var2);

    static native boolean IsNull(long var0);

    static native boolean IsString(long var0);

    static native byte[] GetBuffer(long var0);

    static native byte[] GetRawBuffer(long var0);

    static native String GetAsPDFText(long var0);

    static native void SetString(long var0, byte[] var2);

    static native void SetString(long var0, String var2);

    static native boolean IsName(long var0);

    static native String GetName(long var0);

    static native void SetName(long var0, String var2);

    static native boolean IsIndirect(long var0);

    static native long GetObjNum(long var0);

    static native short GetGenNum(long var0);

    static native long GetOffset(long var0);

    static native boolean IsFree(long var0);

    static native void SetMark(long var0, boolean var2);

    static native boolean IsMarked(long var0);

    static native boolean IsLoaded(long var0);

    static native boolean IsContainer(long var0);

    static native long Size(long var0);

    static native long GetDictIterator(long var0);

    static native boolean IsDict(long var0);

    static native long Find(long var0, String var2);

    static native long FindObj(long var0, String var2);

    static native long Get(long var0, String var2);

    static native long PutName(long var0, String var2, String var3);

    static native long PutArray(long var0, String var2);

    static native long PutBool(long var0, String var2, boolean var3);

    static native long PutDict(long var0, String var2);

    static native long PutNumber(long var0, String var2, double var3);

    static native long PutString(long var0, String var2, String var3);

    static native long PutString(long var0, String var2, byte[] var3);

    static native long PutText(long var0, String var2, String var3);

    static native void PutNull(long var0, String var2);

    static native long Put(long var0, String var2, long var3);

    static native long PutRect(long var0, String var2, double var3, double var5, double var7, double var9);

    static native long PutMatrix(long var0, String var2, long var3);

    static native void Erase(long var0, String var2);

    static native void Erase(long var0, long var2);

    static native boolean Rename(long var0, String var2, String var3);

    static native boolean IsArray(long var0);

    static native long GetAt(long var0, int var2);

    static native long InsertName(long var0, int var2, String var3);

    static native long InsertArray(long var0, int var2);

    static native long InsertBool(long var0, int var2, boolean var3);

    static native long InsertDict(long var0, int var2);

    static native long InsertNumber(long var0, int var2, double var3);

    static native long InsertString(long var0, int var2, String var3);

    static native long InsertString(long var0, int var2, byte[] var3);

    static native long InsertText(long var0, int var2, String var3);

    static native long InsertNull(long var0, int var2);

    static native long Insert(long var0, int var2, long var3);

    static native long InsertRect(long var0, int var2, double var3, double var5, double var7, double var9);

    static native long InsertMatrix(long var0, int var2, long var3);

    static native long PushBackName(long var0, String var2);

    static native long PushBackArray(long var0);

    static native long PushBackBool(long var0, boolean var2);

    static native long PushBackDict(long var0);

    static native long PushBackNumber(long var0, double var2);

    static native long PushBackString(long var0, String var2);

    static native long PushBackString(long var0, byte[] var2);

    static native long PushBackText(long var0, String var2);

    static native long PushBackNull(long var0);

    static native long PushBack(long var0, long var2);

    static native long PushBackRect(long var0, double var2, double var4, double var6, double var8);

    static native long PushBackMatrix(long var0, long var2);

    static native void EraseAt(long var0, int var2);

    static native boolean IsStream(long var0);

    static native long GetRawStreamLength(long var0);

    static native long GetRawStream(long var0, boolean var2);

    static native long GetDecodedStream(long var0);

    static native void SetStreamData(long var0, byte[] var2, long var3);
}

