#!/bin/sh
echo "Command-line samples for Pagemaster"
echo "Copyright 2014 Apryse Software Inc."
echo
echo "Example 1) Split the documents in this folder into files one per page:"
./pagemaster -s -o test_out/ex1/ *.pdf
echo "Example 2) Merge all created PDF documents using default options:"
./pagemaster -m -o test_out/ex2/out.pdf test_out/ex1/
echo
echo "Example 3) Remove all even pages of the resulting document:"
./pagemaster -r -o test_out/ex3/ test_out/ex2/out.pdf,e
mv ./test_out/ex3/out.pdf ./test_out/ex3/out3.pdf
echo
echo "Example 4) Append the file created in example 2 to the one created in example 3:"
./pagemaster -i test_out/ex2/out.pdf -o test_out/ex4/ test_out/ex3/out3.pdf
mv ./test_out/ex4/out3.pdf ./test_out/ex4/out4.pdf
echo
