---
title: PDF to HTML Command Line Conversion
platform: Windows
metaTitle: "PDF to HTML Command Line | PDFTron"
---

PDFTron's **PDF2HTML** is an easy-to-use, stand-alone command-line application that
provides users with an efficient means of converting PDF documents to HTML files.
PDF2HTML exports high quality HTML that authentically maintains the contents of the original PDF.

**Like other PDFTron products, PDF2HTML does not rely on any other
third-party software. PDF2HTML can be used in server environments or as
a batch conversion process.**

<a class="Button medium" href="https://www.pdftron.com/documentation/cli/download/windows/" >Download PDF2HTML</a>

## Why PDF2HTML?

PDF2HTML is easy to use and reliably preserves the contents of the PDF in the HTML output.
PDF fonts are mapped to the appropriate system fonts with style, size and kerning to make
accurate fit. PDF tables with and without PDF table structures are detected and converted
to HTML tables automatically. Single and multi-column pages are converted to equivalent
structures with text flow preserved to facilitate editing. Graphics are converted authentically
and placed accurately on the page.

PDF2HTML can be used in server environments and is also suitable for use in batch conversion workflows.

## **Key Functions**

-   Convert PDF to HTML and HTM.

-   Support for all versions of Acrobat documents.

-   Support for Unicode and all PDF font formats.

-   Support for password-protected PDF.

-   Batch conversion.

-   Options to improve text readability and layout.

-   Automatically converts to structured content.

-   Option to convert specific page ranges.

-   Options to control image quality.

-   Options to handle OCRed PDFs.

## **Common Use Case Scenarios**

-   Simple conversion of PDF to HTML for Web posting.

-   Server-based, on-demand conversion of PDF documents to HTML format.

-   Batch processing of PDF files for data collection.

## **Operating Systems Supported**

-   Windows, Linux and Mac.

## **System Requirements**

-   At least 30 MB of free disk space.

-   Memory requirement is dependent on the source document being converted.
    We recommend a minimum of 4 GB.

## Example

```
pdf2html -in input.pdf -out output.html
```
