<?xml version='1.0'?>
<!-- 
  Simple XSLT example used to transform SVG wrapper XML 
  document to the HTML bookmark tree.
		
  Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved. 
-->
<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

  <xsl:output method='html' indent='yes' doctype-public='-//W3C//DTD HTML 3.2 Final//EN'/>

  <xsl:template match='/'>
    <HTML>
      <HEAD>
        <TITLE>HTML SVG Wrapper</TITLE>
      </HEAD>
      <BODY>
	    <xsl:apply-templates select='doc/info'/>
	    <HR/>      
        <xsl:apply-templates select='doc/bookmarks'/>
      </BODY>
    </HTML>
  </xsl:template>

  <xsl:template match='info'>
   <table border="0" cellspacing="0" cellpadding="4">
     <tr><td nowrap="nowrap">Title:</td><td nowrap="nowrap"><xsl:value-of select='title'/></td></tr>
     <tr><td nowrap="nowrap">Author:</td><td nowrap="nowrap"><xsl:value-of select='author'/></td></tr>
     <tr><td nowrap="nowrap">Subject:</td><td nowrap="nowrap"><xsl:value-of select='subject'/></td></tr>
     <tr><td nowrap="nowrap">Keywords:</td><td nowrap="nowrap"><xsl:value-of select='keywords'/></td></tr>
     <tr><td nowrap="nowrap">Creator:</td><td nowrap="nowrap"><xsl:value-of select='creator'/></td></tr>
     <tr><td nowrap="nowrap">Producer:</td><td nowrap="nowrap"><xsl:value-of select='producer'/></td></tr> 
   </table>  
  </xsl:template>

  <xsl:template match='bookmarks'>
     <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match='bookmark'>
    <UL>
    <LI><A TARGET="view" HREF="{@href}"><xsl:value-of select='@title'/></A></LI>
    <xsl:apply-templates/>
    </UL>
  </xsl:template>

</xsl:stylesheet>
