<?xml version='1.0'?>
<!-- 
  Simple XSLT example used to transform SVG wrapper XML 
  document to the HTML thumbnail index.
		
  Copyright (c) 2001-2025 by Apryse Software Inc. All Rights Reserved. 
-->
<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

  <xsl:output method='html' indent='yes' doctype-public='-//W3C//DTD HTML 3.2 Final//EN'/>

  <xsl:template match='/'>
    <HTML>
      <HEAD>
      <style>
        .page { border:5px solid grey; }
      </style>
      </HEAD>
      <BODY>
        <xsl:apply-templates select='doc/pages'/>
      </BODY>
    </HTML>
  </xsl:template>
  
  <xsl:template match='pages'>
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match='page'>
    <div class="page" width="{@width}pt" height="{@height}pt"><embed SRC="{@href}" type="image/svg+xml"></embed>
    </div>
  </xsl:template>
    
</xsl:stylesheet>
