---
title: Command-Line Summary for PDF2Word
metaTitle: Command-line Summary for PDF to Word | PDFTron CLI
---

```
Usage: pdf2word [options] -in inputfile -out outputfile

BASIC PARAMETERS:

  -in [ -i ] arg            The input file. The default input folder is the
                            current working folder. When running the
                            application from the console or a BAT file, you may
                            use relative file names. However, if you are
                            calling it from an application or a server, we
                            recommend using absolute file names for robustness.

  -out [ -o ] arg           The output file. The file extension (".docx",
                            ".doc" or ".rtf") of the output file will also set
                            the output file type. When running the
                            application from the console or a BAT file, you may
                            use relative file names. However, if you are
                            calling it from an application or a server, we
                            recommend using absolute file names for robustness.

OPTIONS:

  -output arg               The output file type. Valid parameter values are
                            "docx", "doc" and "rtf". If this option is
                            completely omitted, the default output file type
                            is "docx".

  -pages arg (=all)         Page numbers of pages to be converted. You may
                            specify a single page number, e.g. 2, or a range of
                            pages, e.g. 2-6. If omitted, all pages will be
                            converted.

  -fileTimeout arg (=300)   The maximum amount of time allowed, in seconds,
                            for each document conversion. The default timeout
                            is 300 seconds (5 minutes).

  -quality arg (=85)        The image compression quality for JPEG,
                            from 5 to 100. The default quality is 85.

  -resolution arg (=192)    The image resolution in pixels per inch,
                            from 8 to 600. The default resolution is 192.

  -password arg             The master password to open the PDF. The password
                            must give unrestricted content extraction
                            permissions.

  -bookmarks arg (=page)    Bookmark generation in the output, either the
                            default "page" option to create a bookmark at the
                            beginning of each page, "extract" to extract
                            bookmarks from the PDF or "none" to not create any
                            bookmark in the output.

  -ocred arg (=image+text)  Handling of special OCRed PDFs that only contain
                            full-page images with hidden selectable text. This
                            option is only applicable to a PDF produced by an
                            OCR engine based on a scanned image. Valid
                            parameter values are "image+text", "text" and
                            "image". The default option, "image+text", converts
                            both images and text, making the hidden text
                            visible in the output. Use "text" to convert only
                            the text to make the hidden text visible in the
                            output or "image" to convert only the images.

  -connectHyphens arg       Flag to re-connect basic English dictionary words
                            that are hyphenated at the end of a line. This
                            does not remove hyphens from expressions that
                            require a hyphen, such as "counter-clockwise" or
                            "well-intentioned". Valid parameter values are "on"
                            and "off". By default, this option is turned "on"
                            if specified without an argument. However, if this
                            option is completely omitted, it defaults to "off".

  -condense arg             Flag to shrink character spacing to prevent wrap.
                            Valid parameter values are "on" and "off". By
                            default, this option is turned "on" if specified
                            without an argument. However, if this option is
                            completely omitted, it defaults to "off".

  -matchLines arg           Flag to insert newline characters into the output
                            in order to match precise line breaks in the PDF.
                            Please note that this interferes with paragraph
                            detection and you may end up with a new paragraph
                            for each line. Valid parameter values are "on" and
                            "off". By default, this option is turned "on" if
                            specified without an argument. However, if this
                            option is completely omitted, it defaults to "off".

  -noAdjustFonts arg        Flag to stop adjusting and shrinking the fonts to
                            fit text in the available space. Take note that
                            disabling font adjustments may sometimes cause a
                            single page PDF to come out as two pages in Word.
                            Valid parameter values are "on" and "off". By
                            default, this option is turned "on" if specified
                            without an argument. However, if this option is
                            completely omitted, it defaults to "off".

  -removeInvisibleText arg  Flag to remove text that shares the same color as
                            the background. Valid parameter values are "on" and
                            "off". By default, this option is turned "on".

  -wordPad arg              Flag to generate RTF with uncompressed images for
                            WordPad compatibility. This applies to RTF output
                            files only. Please note that uncompressed images
                            can significantly blow up the output file size.
                            Valid parameter values are "on" and "off". By
                            default, this option is turned "on" if specified
                            without an argument. However, if this option is
                            completely omitted, it defaults to "off".

  -advanced [ -a ] arg      Advanced option to ignore angled text
                            (IgnoreAngledText=True) and/or vertical text
                            (IgnoreVerticalText=True). 
                            By default, these are turned off.

  -version                  Print the version number. Only available in Windows.

  -silent                   Switches the application to Silent Mode. Warnings
                            and progress messages are not displayed. Only
                            errors that are considered failures are shown.



Examples:
  pdf2word -in myInput.pdf -out myOutput.docx
  pdf2word -password MyPDFPassword -in my.pdf -out myDOC.doc
```
